// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetCollaborationTrainedModelResponse private constructor(builder: Builder) {
    /**
     * The collaboration ID of the collaboration that contains the trained model.
     */
    public val collaborationIdentifier: kotlin.String = requireNotNull(builder.collaborationIdentifier) { "A non-null value must be provided for collaborationIdentifier" }
    /**
     * The Amazon Resource Name (ARN) of the configured model algorithm association that was used to create this trained model.
     */
    public val configuredModelAlgorithmAssociationArn: kotlin.String = requireNotNull(builder.configuredModelAlgorithmAssociationArn) { "A non-null value must be provided for configuredModelAlgorithmAssociationArn" }
    /**
     * The time at which the trained model was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The account ID of the member that created the trained model.
     */
    public val creatorAccountId: kotlin.String = requireNotNull(builder.creatorAccountId) { "A non-null value must be provided for creatorAccountId" }
    /**
     * The description of the trained model.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Status information for the logs.
     */
    public val logsStatus: aws.sdk.kotlin.services.cleanroomsml.model.LogsStatus? = builder.logsStatus
    /**
     * Details about the status information for the logs.
     */
    public val logsStatusDetails: kotlin.String? = builder.logsStatusDetails
    /**
     * The membership ID of the member that created the trained model.
     */
    public val membershipIdentifier: kotlin.String = requireNotNull(builder.membershipIdentifier) { "A non-null value must be provided for membershipIdentifier" }
    /**
     * The status of the model metrics.
     */
    public val metricsStatus: aws.sdk.kotlin.services.cleanroomsml.model.MetricsStatus? = builder.metricsStatus
    /**
     * Details about the status information for the model metrics.
     */
    public val metricsStatusDetails: kotlin.String? = builder.metricsStatusDetails
    /**
     * The name of the trained model.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The EC2 resource configuration that was used to train this model.
     */
    public val resourceConfig: aws.sdk.kotlin.services.cleanroomsml.model.ResourceConfig? = builder.resourceConfig
    /**
     * The status of the trained model.
     */
    public val status: aws.sdk.kotlin.services.cleanroomsml.model.TrainedModelStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * Details about the status of a resource.
     */
    public val statusDetails: aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails? = builder.statusDetails
    /**
     * The stopping condition that determined when model training ended.
     */
    public val stoppingCondition: aws.sdk.kotlin.services.cleanroomsml.model.StoppingCondition? = builder.stoppingCondition
    /**
     * The Amazon Resource Name (ARN) of the trained model.
     */
    public val trainedModelArn: kotlin.String = requireNotNull(builder.trainedModelArn) { "A non-null value must be provided for trainedModelArn" }
    /**
     * Information about the training container image.
     */
    public val trainingContainerImageDigest: kotlin.String? = builder.trainingContainerImageDigest
    /**
     * The most recent time at which the trained model was updated.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.GetCollaborationTrainedModelResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetCollaborationTrainedModelResponse(")
        append("collaborationIdentifier=$collaborationIdentifier,")
        append("configuredModelAlgorithmAssociationArn=$configuredModelAlgorithmAssociationArn,")
        append("createTime=$createTime,")
        append("creatorAccountId=$creatorAccountId,")
        append("description=$description,")
        append("logsStatus=$logsStatus,")
        append("logsStatusDetails=$logsStatusDetails,")
        append("membershipIdentifier=$membershipIdentifier,")
        append("metricsStatus=$metricsStatus,")
        append("metricsStatusDetails=$metricsStatusDetails,")
        append("name=$name,")
        append("resourceConfig=$resourceConfig,")
        append("status=$status,")
        append("statusDetails=$statusDetails,")
        append("stoppingCondition=$stoppingCondition,")
        append("trainedModelArn=$trainedModelArn,")
        append("trainingContainerImageDigest=$trainingContainerImageDigest,")
        append("updateTime=$updateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = collaborationIdentifier.hashCode()
        result = 31 * result + (configuredModelAlgorithmAssociationArn.hashCode())
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (creatorAccountId.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (logsStatus?.hashCode() ?: 0)
        result = 31 * result + (logsStatusDetails?.hashCode() ?: 0)
        result = 31 * result + (membershipIdentifier.hashCode())
        result = 31 * result + (metricsStatus?.hashCode() ?: 0)
        result = 31 * result + (metricsStatusDetails?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (resourceConfig?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusDetails?.hashCode() ?: 0)
        result = 31 * result + (stoppingCondition?.hashCode() ?: 0)
        result = 31 * result + (trainedModelArn.hashCode())
        result = 31 * result + (trainingContainerImageDigest?.hashCode() ?: 0)
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetCollaborationTrainedModelResponse

        if (collaborationIdentifier != other.collaborationIdentifier) return false
        if (configuredModelAlgorithmAssociationArn != other.configuredModelAlgorithmAssociationArn) return false
        if (createTime != other.createTime) return false
        if (creatorAccountId != other.creatorAccountId) return false
        if (description != other.description) return false
        if (logsStatus != other.logsStatus) return false
        if (logsStatusDetails != other.logsStatusDetails) return false
        if (membershipIdentifier != other.membershipIdentifier) return false
        if (metricsStatus != other.metricsStatus) return false
        if (metricsStatusDetails != other.metricsStatusDetails) return false
        if (name != other.name) return false
        if (resourceConfig != other.resourceConfig) return false
        if (status != other.status) return false
        if (statusDetails != other.statusDetails) return false
        if (stoppingCondition != other.stoppingCondition) return false
        if (trainedModelArn != other.trainedModelArn) return false
        if (trainingContainerImageDigest != other.trainingContainerImageDigest) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.GetCollaborationTrainedModelResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The collaboration ID of the collaboration that contains the trained model.
         */
        public var collaborationIdentifier: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the configured model algorithm association that was used to create this trained model.
         */
        public var configuredModelAlgorithmAssociationArn: kotlin.String? = null
        /**
         * The time at which the trained model was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The account ID of the member that created the trained model.
         */
        public var creatorAccountId: kotlin.String? = null
        /**
         * The description of the trained model.
         */
        public var description: kotlin.String? = null
        /**
         * Status information for the logs.
         */
        public var logsStatus: aws.sdk.kotlin.services.cleanroomsml.model.LogsStatus? = null
        /**
         * Details about the status information for the logs.
         */
        public var logsStatusDetails: kotlin.String? = null
        /**
         * The membership ID of the member that created the trained model.
         */
        public var membershipIdentifier: kotlin.String? = null
        /**
         * The status of the model metrics.
         */
        public var metricsStatus: aws.sdk.kotlin.services.cleanroomsml.model.MetricsStatus? = null
        /**
         * Details about the status information for the model metrics.
         */
        public var metricsStatusDetails: kotlin.String? = null
        /**
         * The name of the trained model.
         */
        public var name: kotlin.String? = null
        /**
         * The EC2 resource configuration that was used to train this model.
         */
        public var resourceConfig: aws.sdk.kotlin.services.cleanroomsml.model.ResourceConfig? = null
        /**
         * The status of the trained model.
         */
        public var status: aws.sdk.kotlin.services.cleanroomsml.model.TrainedModelStatus? = null
        /**
         * Details about the status of a resource.
         */
        public var statusDetails: aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails? = null
        /**
         * The stopping condition that determined when model training ended.
         */
        public var stoppingCondition: aws.sdk.kotlin.services.cleanroomsml.model.StoppingCondition? = null
        /**
         * The Amazon Resource Name (ARN) of the trained model.
         */
        public var trainedModelArn: kotlin.String? = null
        /**
         * Information about the training container image.
         */
        public var trainingContainerImageDigest: kotlin.String? = null
        /**
         * The most recent time at which the trained model was updated.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.GetCollaborationTrainedModelResponse) : this() {
            this.collaborationIdentifier = x.collaborationIdentifier
            this.configuredModelAlgorithmAssociationArn = x.configuredModelAlgorithmAssociationArn
            this.createTime = x.createTime
            this.creatorAccountId = x.creatorAccountId
            this.description = x.description
            this.logsStatus = x.logsStatus
            this.logsStatusDetails = x.logsStatusDetails
            this.membershipIdentifier = x.membershipIdentifier
            this.metricsStatus = x.metricsStatus
            this.metricsStatusDetails = x.metricsStatusDetails
            this.name = x.name
            this.resourceConfig = x.resourceConfig
            this.status = x.status
            this.statusDetails = x.statusDetails
            this.stoppingCondition = x.stoppingCondition
            this.trainedModelArn = x.trainedModelArn
            this.trainingContainerImageDigest = x.trainingContainerImageDigest
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.GetCollaborationTrainedModelResponse = GetCollaborationTrainedModelResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.ResourceConfig] inside the given [block]
         */
        public fun resourceConfig(block: aws.sdk.kotlin.services.cleanroomsml.model.ResourceConfig.Builder.() -> kotlin.Unit) {
            this.resourceConfig = aws.sdk.kotlin.services.cleanroomsml.model.ResourceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails] inside the given [block]
         */
        public fun statusDetails(block: aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails.Builder.() -> kotlin.Unit) {
            this.statusDetails = aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.StoppingCondition] inside the given [block]
         */
        public fun stoppingCondition(block: aws.sdk.kotlin.services.cleanroomsml.model.StoppingCondition.Builder.() -> kotlin.Unit) {
            this.stoppingCondition = aws.sdk.kotlin.services.cleanroomsml.model.StoppingCondition.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (collaborationIdentifier == null) collaborationIdentifier = ""
            if (configuredModelAlgorithmAssociationArn == null) configuredModelAlgorithmAssociationArn = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (creatorAccountId == null) creatorAccountId = ""
            if (membershipIdentifier == null) membershipIdentifier = ""
            if (name == null) name = ""
            if (status == null) status = TrainedModelStatus.SdkUnknown("no value provided")
            if (trainedModelArn == null) trainedModelArn = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
