// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateConfiguredModelAlgorithmRequest private constructor(builder: Builder) {
    /**
     * The description of the configured model algorithm.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Configuration information for the inference container that is used when you run an inference job on a configured model algorithm.
     */
    public val inferenceContainerConfig: aws.sdk.kotlin.services.cleanroomsml.model.InferenceContainerConfig? = builder.inferenceContainerConfig
    /**
     * The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned data in the configured ML model algorithm and associated data.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The name of the configured model algorithm.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the role that is used to access the repository.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The optional metadata that you apply to the resource to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
     *
     * The following basic restrictions apply to tags:
     * + Maximum number of tags per resource - 50.
     * + For each resource, each tag key must be unique, and each tag key can have only one value.
     * + Maximum key length - 128 Unicode characters in UTF-8.
     * + Maximum value length - 256 Unicode characters in UTF-8.
     * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
     * + Tag keys and values are case sensitive.
     * + Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Configuration information for the training container, including entrypoints and arguments.
     */
    public val trainingContainerConfig: aws.sdk.kotlin.services.cleanroomsml.model.ContainerConfig? = builder.trainingContainerConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.CreateConfiguredModelAlgorithmRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateConfiguredModelAlgorithmRequest(")
        append("description=$description,")
        append("inferenceContainerConfig=$inferenceContainerConfig,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("tags=$tags,")
        append("trainingContainerConfig=$trainingContainerConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (inferenceContainerConfig?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (trainingContainerConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateConfiguredModelAlgorithmRequest

        if (description != other.description) return false
        if (inferenceContainerConfig != other.inferenceContainerConfig) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false
        if (trainingContainerConfig != other.trainingContainerConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.CreateConfiguredModelAlgorithmRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The description of the configured model algorithm.
         */
        public var description: kotlin.String? = null
        /**
         * Configuration information for the inference container that is used when you run an inference job on a configured model algorithm.
         */
        public var inferenceContainerConfig: aws.sdk.kotlin.services.cleanroomsml.model.InferenceContainerConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned data in the configured ML model algorithm and associated data.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The name of the configured model algorithm.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the role that is used to access the repository.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The optional metadata that you apply to the resource to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
         *
         * The following basic restrictions apply to tags:
         * + Maximum number of tags per resource - 50.
         * + For each resource, each tag key must be unique, and each tag key can have only one value.
         * + Maximum key length - 128 Unicode characters in UTF-8.
         * + Maximum value length - 256 Unicode characters in UTF-8.
         * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         * + Tag keys and values are case sensitive.
         * + Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.
         */
        public var tags: Map<String, String>? = null
        /**
         * Configuration information for the training container, including entrypoints and arguments.
         */
        public var trainingContainerConfig: aws.sdk.kotlin.services.cleanroomsml.model.ContainerConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.CreateConfiguredModelAlgorithmRequest) : this() {
            this.description = x.description
            this.inferenceContainerConfig = x.inferenceContainerConfig
            this.kmsKeyArn = x.kmsKeyArn
            this.name = x.name
            this.roleArn = x.roleArn
            this.tags = x.tags
            this.trainingContainerConfig = x.trainingContainerConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.CreateConfiguredModelAlgorithmRequest = CreateConfiguredModelAlgorithmRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.InferenceContainerConfig] inside the given [block]
         */
        public fun inferenceContainerConfig(block: aws.sdk.kotlin.services.cleanroomsml.model.InferenceContainerConfig.Builder.() -> kotlin.Unit) {
            this.inferenceContainerConfig = aws.sdk.kotlin.services.cleanroomsml.model.InferenceContainerConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.ContainerConfig] inside the given [block]
         */
        public fun trainingContainerConfig(block: aws.sdk.kotlin.services.cleanroomsml.model.ContainerConfig.Builder.() -> kotlin.Unit) {
            this.trainingContainerConfig = aws.sdk.kotlin.services.cleanroomsml.model.ContainerConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
