// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides configuration information for the dockerized container where the model algorithm is stored.
 */
public class ContainerConfig private constructor(builder: Builder) {
    /**
     * The arguments for a container used to run a training job. See How Amazon SageMaker Runs Your Training Image for additional information. For more information, see [How Sagemaker runs your training image](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-training-algo-dockerfile.html).
     */
    public val arguments: List<String>? = builder.arguments
    /**
     * The entrypoint script for a Docker container used to run a training job. This script takes precedence over the default train processing instructions. See How Amazon SageMaker Runs Your Training Image for additional information. For more information, see [How Sagemaker runs your training image](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-training-algo-dockerfile.html).
     */
    public val entrypoint: List<String>? = builder.entrypoint
    /**
     * The registry path of the docker image that contains the algorithm. Clean Rooms ML supports both `registry/repository[:tag]` and `registry/repositry[@digest]` image path formats. For more information about using images in Clean Rooms ML, see the [Sagemaker API reference](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AlgorithmSpecification.html#sagemaker-Type-AlgorithmSpecification-TrainingImage).
     */
    public val imageUri: kotlin.String = requireNotNull(builder.imageUri) { "A non-null value must be provided for imageUri" }
    /**
     * A list of metric definition objects. Each object specifies the metric name and regular expressions used to parse algorithm logs. Amazon Web Services Clean Rooms ML publishes each metric to all members' Amazon CloudWatch using IAM role configured in PutMLConfiguration.
     */
    public val metricDefinitions: List<MetricDefinition>? = builder.metricDefinitions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.ContainerConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerConfig(")
        append("arguments=$arguments,")
        append("entrypoint=$entrypoint,")
        append("imageUri=$imageUri,")
        append("metricDefinitions=$metricDefinitions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arguments?.hashCode() ?: 0
        result = 31 * result + (entrypoint?.hashCode() ?: 0)
        result = 31 * result + (imageUri.hashCode())
        result = 31 * result + (metricDefinitions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerConfig

        if (arguments != other.arguments) return false
        if (entrypoint != other.entrypoint) return false
        if (imageUri != other.imageUri) return false
        if (metricDefinitions != other.metricDefinitions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.ContainerConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The arguments for a container used to run a training job. See How Amazon SageMaker Runs Your Training Image for additional information. For more information, see [How Sagemaker runs your training image](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-training-algo-dockerfile.html).
         */
        public var arguments: List<String>? = null
        /**
         * The entrypoint script for a Docker container used to run a training job. This script takes precedence over the default train processing instructions. See How Amazon SageMaker Runs Your Training Image for additional information. For more information, see [How Sagemaker runs your training image](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-training-algo-dockerfile.html).
         */
        public var entrypoint: List<String>? = null
        /**
         * The registry path of the docker image that contains the algorithm. Clean Rooms ML supports both `registry/repository[:tag]` and `registry/repositry[@digest]` image path formats. For more information about using images in Clean Rooms ML, see the [Sagemaker API reference](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AlgorithmSpecification.html#sagemaker-Type-AlgorithmSpecification-TrainingImage).
         */
        public var imageUri: kotlin.String? = null
        /**
         * A list of metric definition objects. Each object specifies the metric name and regular expressions used to parse algorithm logs. Amazon Web Services Clean Rooms ML publishes each metric to all members' Amazon CloudWatch using IAM role configured in PutMLConfiguration.
         */
        public var metricDefinitions: List<MetricDefinition>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.ContainerConfig) : this() {
            this.arguments = x.arguments
            this.entrypoint = x.entrypoint
            this.imageUri = x.imageUri
            this.metricDefinitions = x.metricDefinitions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.ContainerConfig = ContainerConfig(this)

        internal fun correctErrors(): Builder {
            if (imageUri == null) imageUri = ""
            return this
        }
    }
}
