// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides summary information about a configured model algorithm.
 */
public class ConfiguredModelAlgorithmSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the configured model algorithm.
     */
    public val configuredModelAlgorithmArn: kotlin.String = requireNotNull(builder.configuredModelAlgorithmArn) { "A non-null value must be provided for configuredModelAlgorithmArn" }
    /**
     * The time at which the configured model algorithm was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The description of the configured model algorithm.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the configured model algorithm.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The most recent time at which the configured model algorithm was updated.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredModelAlgorithmSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConfiguredModelAlgorithmSummary(")
        append("configuredModelAlgorithmArn=$configuredModelAlgorithmArn,")
        append("createTime=$createTime,")
        append("description=$description,")
        append("name=$name,")
        append("updateTime=$updateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configuredModelAlgorithmArn.hashCode()
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConfiguredModelAlgorithmSummary

        if (configuredModelAlgorithmArn != other.configuredModelAlgorithmArn) return false
        if (createTime != other.createTime) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredModelAlgorithmSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the configured model algorithm.
         */
        public var configuredModelAlgorithmArn: kotlin.String? = null
        /**
         * The time at which the configured model algorithm was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the configured model algorithm.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the configured model algorithm.
         */
        public var name: kotlin.String? = null
        /**
         * The most recent time at which the configured model algorithm was updated.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredModelAlgorithmSummary) : this() {
            this.configuredModelAlgorithmArn = x.configuredModelAlgorithmArn
            this.createTime = x.createTime
            this.description = x.description
            this.name = x.name
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredModelAlgorithmSummary = ConfiguredModelAlgorithmSummary(this)

        internal fun correctErrors(): Builder {
            if (configuredModelAlgorithmArn == null) configuredModelAlgorithmArn = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
