// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides summary information about an ML input channel in a collaboration.
 */
public class CollaborationMlInputChannelSummary private constructor(builder: Builder) {
    /**
     * The collaboration ID of the collaboration that contains the ML input channel.
     */
    public val collaborationIdentifier: kotlin.String = requireNotNull(builder.collaborationIdentifier) { "A non-null value must be provided for collaborationIdentifier" }
    /**
     * The associated configured model algorithms used to create the ML input channel.
     */
    public val configuredModelAlgorithmAssociations: List<String> = requireNotNull(builder.configuredModelAlgorithmAssociations) { "A non-null value must be provided for configuredModelAlgorithmAssociations" }
    /**
     * The time at which the ML input channel was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The account ID of the member who created the ML input channel.
     */
    public val creatorAccountId: kotlin.String = requireNotNull(builder.creatorAccountId) { "A non-null value must be provided for creatorAccountId" }
    /**
     * The description of the ML input channel.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The membership ID of the membership that contains the ML input channel.
     */
    public val membershipIdentifier: kotlin.String = requireNotNull(builder.membershipIdentifier) { "A non-null value must be provided for membershipIdentifier" }
    /**
     * The Amazon Resource Name (ARN) of the ML input channel.
     */
    public val mlInputChannelArn: kotlin.String = requireNotNull(builder.mlInputChannelArn) { "A non-null value must be provided for mlInputChannelArn" }
    /**
     * The name of the ML input channel.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The status of the ML input channel.
     */
    public val status: aws.sdk.kotlin.services.cleanroomsml.model.MlInputChannelStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The most recent time at which the ML input channel was updated.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.CollaborationMlInputChannelSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CollaborationMlInputChannelSummary(")
        append("collaborationIdentifier=$collaborationIdentifier,")
        append("configuredModelAlgorithmAssociations=$configuredModelAlgorithmAssociations,")
        append("createTime=$createTime,")
        append("creatorAccountId=$creatorAccountId,")
        append("description=$description,")
        append("membershipIdentifier=$membershipIdentifier,")
        append("mlInputChannelArn=$mlInputChannelArn,")
        append("name=$name,")
        append("status=$status,")
        append("updateTime=$updateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = collaborationIdentifier.hashCode()
        result = 31 * result + (configuredModelAlgorithmAssociations.hashCode())
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (creatorAccountId.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (membershipIdentifier.hashCode())
        result = 31 * result + (mlInputChannelArn.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CollaborationMlInputChannelSummary

        if (collaborationIdentifier != other.collaborationIdentifier) return false
        if (configuredModelAlgorithmAssociations != other.configuredModelAlgorithmAssociations) return false
        if (createTime != other.createTime) return false
        if (creatorAccountId != other.creatorAccountId) return false
        if (description != other.description) return false
        if (membershipIdentifier != other.membershipIdentifier) return false
        if (mlInputChannelArn != other.mlInputChannelArn) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.CollaborationMlInputChannelSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The collaboration ID of the collaboration that contains the ML input channel.
         */
        public var collaborationIdentifier: kotlin.String? = null
        /**
         * The associated configured model algorithms used to create the ML input channel.
         */
        public var configuredModelAlgorithmAssociations: List<String>? = null
        /**
         * The time at which the ML input channel was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The account ID of the member who created the ML input channel.
         */
        public var creatorAccountId: kotlin.String? = null
        /**
         * The description of the ML input channel.
         */
        public var description: kotlin.String? = null
        /**
         * The membership ID of the membership that contains the ML input channel.
         */
        public var membershipIdentifier: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the ML input channel.
         */
        public var mlInputChannelArn: kotlin.String? = null
        /**
         * The name of the ML input channel.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the ML input channel.
         */
        public var status: aws.sdk.kotlin.services.cleanroomsml.model.MlInputChannelStatus? = null
        /**
         * The most recent time at which the ML input channel was updated.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.CollaborationMlInputChannelSummary) : this() {
            this.collaborationIdentifier = x.collaborationIdentifier
            this.configuredModelAlgorithmAssociations = x.configuredModelAlgorithmAssociations
            this.createTime = x.createTime
            this.creatorAccountId = x.creatorAccountId
            this.description = x.description
            this.membershipIdentifier = x.membershipIdentifier
            this.mlInputChannelArn = x.mlInputChannelArn
            this.name = x.name
            this.status = x.status
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.CollaborationMlInputChannelSummary = CollaborationMlInputChannelSummary(this)

        internal fun correctErrors(): Builder {
            if (collaborationIdentifier == null) collaborationIdentifier = ""
            if (configuredModelAlgorithmAssociations == null) configuredModelAlgorithmAssociations = emptyList()
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (creatorAccountId == null) creatorAccountId = ""
            if (membershipIdentifier == null) membershipIdentifier = ""
            if (mlInputChannelArn == null) mlInputChannelArn = ""
            if (name == null) name = ""
            if (status == null) status = MlInputChannelStatus.SdkUnknown("no value provided")
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
