// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.serde

import aws.sdk.kotlin.services.cleanroomsml.model.CleanRoomsMlException
import aws.sdk.kotlin.services.cleanroomsml.model.GetTrainedModelResponse
import aws.sdk.kotlin.services.cleanroomsml.model.LogsStatus
import aws.sdk.kotlin.services.cleanroomsml.model.MetricsStatus
import aws.sdk.kotlin.services.cleanroomsml.model.ModelTrainingDataChannel
import aws.sdk.kotlin.services.cleanroomsml.model.ResourceConfig
import aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails
import aws.sdk.kotlin.services.cleanroomsml.model.StoppingCondition
import aws.sdk.kotlin.services.cleanroomsml.model.TrainedModelStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetTrainedModelOperationDeserializer: HttpDeserializer.NonStreaming<GetTrainedModelResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetTrainedModelResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetTrainedModelError(context, call, payload)
        }
        val builder = GetTrainedModelResponse.Builder()

        if (payload != null) {
            deserializeGetTrainedModelOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetTrainedModelError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CleanRoomsMlException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CleanRoomsMlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetTrainedModelOperationBody(builder: GetTrainedModelResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COLLABORATIONIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("collaborationIdentifier"))
    val CONFIGUREDMODELALGORITHMASSOCIATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("configuredModelAlgorithmAssociationArn"))
    val CREATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createTime"))
    val DATACHANNELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("dataChannels"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val ENVIRONMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("environment"))
    val HYPERPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("hyperparameters"))
    val KMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("kmsKeyArn"))
    val LOGSSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("logsStatus"))
    val LOGSSTATUSDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("logsStatusDetails"))
    val MEMBERSHIPIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("membershipIdentifier"))
    val METRICSSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("metricsStatus"))
    val METRICSSTATUSDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("metricsStatusDetails"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val RESOURCECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("resourceConfig"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val STATUSDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("statusDetails"))
    val STOPPINGCONDITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("stoppingCondition"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TRAINEDMODELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("trainedModelArn"))
    val TRAININGCONTAINERIMAGEDIGEST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("trainingContainerImageDigest"))
    val UPDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updateTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COLLABORATIONIDENTIFIER_DESCRIPTOR)
        field(CONFIGUREDMODELALGORITHMASSOCIATIONARN_DESCRIPTOR)
        field(CREATETIME_DESCRIPTOR)
        field(DATACHANNELS_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENVIRONMENT_DESCRIPTOR)
        field(HYPERPARAMETERS_DESCRIPTOR)
        field(KMSKEYARN_DESCRIPTOR)
        field(LOGSSTATUS_DESCRIPTOR)
        field(LOGSSTATUSDETAILS_DESCRIPTOR)
        field(MEMBERSHIPIDENTIFIER_DESCRIPTOR)
        field(METRICSSTATUS_DESCRIPTOR)
        field(METRICSSTATUSDETAILS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(RESOURCECONFIG_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSDETAILS_DESCRIPTOR)
        field(STOPPINGCONDITION_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TRAINEDMODELARN_DESCRIPTOR)
        field(TRAININGCONTAINERIMAGEDIGEST_DESCRIPTOR)
        field(UPDATETIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COLLABORATIONIDENTIFIER_DESCRIPTOR.index -> builder.collaborationIdentifier = deserializeString()
                CONFIGUREDMODELALGORITHMASSOCIATIONARN_DESCRIPTOR.index -> builder.configuredModelAlgorithmAssociationArn = deserializeString()
                CREATETIME_DESCRIPTOR.index -> builder.createTime = deserializeInstant(TimestampFormat.ISO_8601)
                DATACHANNELS_DESCRIPTOR.index -> builder.dataChannels =
                    deserializer.deserializeList(DATACHANNELS_DESCRIPTOR) {
                        val col0 = mutableListOf<ModelTrainingDataChannel>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeModelTrainingDataChannelDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ENVIRONMENT_DESCRIPTOR.index -> builder.environment =
                    deserializer.deserializeMap(ENVIRONMENT_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                HYPERPARAMETERS_DESCRIPTOR.index -> builder.hyperparameters =
                    deserializer.deserializeMap(HYPERPARAMETERS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                KMSKEYARN_DESCRIPTOR.index -> builder.kmsKeyArn = deserializeString()
                LOGSSTATUS_DESCRIPTOR.index -> builder.logsStatus = deserializeString().let { LogsStatus.fromValue(it) }
                LOGSSTATUSDETAILS_DESCRIPTOR.index -> builder.logsStatusDetails = deserializeString()
                MEMBERSHIPIDENTIFIER_DESCRIPTOR.index -> builder.membershipIdentifier = deserializeString()
                METRICSSTATUS_DESCRIPTOR.index -> builder.metricsStatus = deserializeString().let { MetricsStatus.fromValue(it) }
                METRICSSTATUSDETAILS_DESCRIPTOR.index -> builder.metricsStatusDetails = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                RESOURCECONFIG_DESCRIPTOR.index -> builder.resourceConfig = deserializeResourceConfigDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { TrainedModelStatus.fromValue(it) }
                STATUSDETAILS_DESCRIPTOR.index -> builder.statusDetails = deserializeStatusDetailsDocument(deserializer)
                STOPPINGCONDITION_DESCRIPTOR.index -> builder.stoppingCondition = deserializeStoppingConditionDocument(deserializer)
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TRAINEDMODELARN_DESCRIPTOR.index -> builder.trainedModelArn = deserializeString()
                TRAININGCONTAINERIMAGEDIGEST_DESCRIPTOR.index -> builder.trainingContainerImageDigest = deserializeString()
                UPDATETIME_DESCRIPTOR.index -> builder.updateTime = deserializeInstant(TimestampFormat.ISO_8601)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
