// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.serde

import aws.sdk.kotlin.services.cleanroomsml.model.CleanRoomsMlException
import aws.sdk.kotlin.services.cleanroomsml.model.GetTrainedModelInferenceJobResponse
import aws.sdk.kotlin.services.cleanroomsml.model.InferenceContainerExecutionParameters
import aws.sdk.kotlin.services.cleanroomsml.model.InferenceOutputConfiguration
import aws.sdk.kotlin.services.cleanroomsml.model.InferenceResourceConfig
import aws.sdk.kotlin.services.cleanroomsml.model.LogsStatus
import aws.sdk.kotlin.services.cleanroomsml.model.MetricsStatus
import aws.sdk.kotlin.services.cleanroomsml.model.ModelInferenceDataSource
import aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails
import aws.sdk.kotlin.services.cleanroomsml.model.TrainedModelInferenceJobStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableMapOf


internal class GetTrainedModelInferenceJobOperationDeserializer: HttpDeserializer.NonStreaming<GetTrainedModelInferenceJobResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetTrainedModelInferenceJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetTrainedModelInferenceJobError(context, call, payload)
        }
        val builder = GetTrainedModelInferenceJobResponse.Builder()

        if (payload != null) {
            deserializeGetTrainedModelInferenceJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetTrainedModelInferenceJobError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CleanRoomsMlException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CleanRoomsMlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetTrainedModelInferenceJobOperationBody(builder: GetTrainedModelInferenceJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONFIGUREDMODELALGORITHMASSOCIATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("configuredModelAlgorithmAssociationArn"))
    val CONTAINEREXECUTIONPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("containerExecutionParameters"))
    val CREATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createTime"))
    val DATASOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("dataSource"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val ENVIRONMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("environment"))
    val INFERENCECONTAINERIMAGEDIGEST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("inferenceContainerImageDigest"))
    val KMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("kmsKeyArn"))
    val LOGSSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("logsStatus"))
    val LOGSSTATUSDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("logsStatusDetails"))
    val MEMBERSHIPIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("membershipIdentifier"))
    val METRICSSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("metricsStatus"))
    val METRICSSTATUSDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("metricsStatusDetails"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val OUTPUTCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("outputConfiguration"))
    val RESOURCECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("resourceConfig"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val STATUSDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("statusDetails"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TRAINEDMODELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("trainedModelArn"))
    val TRAINEDMODELINFERENCEJOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("trainedModelInferenceJobArn"))
    val UPDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updateTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONFIGUREDMODELALGORITHMASSOCIATIONARN_DESCRIPTOR)
        field(CONTAINEREXECUTIONPARAMETERS_DESCRIPTOR)
        field(CREATETIME_DESCRIPTOR)
        field(DATASOURCE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENVIRONMENT_DESCRIPTOR)
        field(INFERENCECONTAINERIMAGEDIGEST_DESCRIPTOR)
        field(KMSKEYARN_DESCRIPTOR)
        field(LOGSSTATUS_DESCRIPTOR)
        field(LOGSSTATUSDETAILS_DESCRIPTOR)
        field(MEMBERSHIPIDENTIFIER_DESCRIPTOR)
        field(METRICSSTATUS_DESCRIPTOR)
        field(METRICSSTATUSDETAILS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OUTPUTCONFIGURATION_DESCRIPTOR)
        field(RESOURCECONFIG_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSDETAILS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TRAINEDMODELARN_DESCRIPTOR)
        field(TRAINEDMODELINFERENCEJOBARN_DESCRIPTOR)
        field(UPDATETIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONFIGUREDMODELALGORITHMASSOCIATIONARN_DESCRIPTOR.index -> builder.configuredModelAlgorithmAssociationArn = deserializeString()
                CONTAINEREXECUTIONPARAMETERS_DESCRIPTOR.index -> builder.containerExecutionParameters = deserializeInferenceContainerExecutionParametersDocument(deserializer)
                CREATETIME_DESCRIPTOR.index -> builder.createTime = deserializeInstant(TimestampFormat.ISO_8601)
                DATASOURCE_DESCRIPTOR.index -> builder.dataSource = deserializeModelInferenceDataSourceDocument(deserializer)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ENVIRONMENT_DESCRIPTOR.index -> builder.environment =
                    deserializer.deserializeMap(ENVIRONMENT_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                INFERENCECONTAINERIMAGEDIGEST_DESCRIPTOR.index -> builder.inferenceContainerImageDigest = deserializeString()
                KMSKEYARN_DESCRIPTOR.index -> builder.kmsKeyArn = deserializeString()
                LOGSSTATUS_DESCRIPTOR.index -> builder.logsStatus = deserializeString().let { LogsStatus.fromValue(it) }
                LOGSSTATUSDETAILS_DESCRIPTOR.index -> builder.logsStatusDetails = deserializeString()
                MEMBERSHIPIDENTIFIER_DESCRIPTOR.index -> builder.membershipIdentifier = deserializeString()
                METRICSSTATUS_DESCRIPTOR.index -> builder.metricsStatus = deserializeString().let { MetricsStatus.fromValue(it) }
                METRICSSTATUSDETAILS_DESCRIPTOR.index -> builder.metricsStatusDetails = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                OUTPUTCONFIGURATION_DESCRIPTOR.index -> builder.outputConfiguration = deserializeInferenceOutputConfigurationDocument(deserializer)
                RESOURCECONFIG_DESCRIPTOR.index -> builder.resourceConfig = deserializeInferenceResourceConfigDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { TrainedModelInferenceJobStatus.fromValue(it) }
                STATUSDETAILS_DESCRIPTOR.index -> builder.statusDetails = deserializeStatusDetailsDocument(deserializer)
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TRAINEDMODELARN_DESCRIPTOR.index -> builder.trainedModelArn = deserializeString()
                TRAINEDMODELINFERENCEJOBARN_DESCRIPTOR.index -> builder.trainedModelInferenceJobArn = deserializeString()
                UPDATETIME_DESCRIPTOR.index -> builder.updateTime = deserializeInstant(TimestampFormat.ISO_8601)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
