// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information about the data source that is used to create an ML input channel.
 */
public class InputChannel private constructor(builder: Builder) {
    /**
     * The data source that is used to create the ML input channel.
     */
    public val dataSource: aws.sdk.kotlin.services.cleanroomsml.model.InputChannelDataSource? = builder.dataSource
    /**
     * The ARN of the IAM role that Clean Rooms ML can assume to read the data referred to in the `dataSource` field the input channel.
     *
     * Passing a role across AWS accounts is not allowed. If you pass a role that isn't in your account, you get an `AccessDeniedException` error.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.InputChannel = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InputChannel(")
        append("dataSource=$dataSource,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSource?.hashCode() ?: 0
        result = 31 * result + (roleArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InputChannel

        if (dataSource != other.dataSource) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.InputChannel = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The data source that is used to create the ML input channel.
         */
        public var dataSource: aws.sdk.kotlin.services.cleanroomsml.model.InputChannelDataSource? = null
        /**
         * The ARN of the IAM role that Clean Rooms ML can assume to read the data referred to in the `dataSource` field the input channel.
         *
         * Passing a role across AWS accounts is not allowed. If you pass a role that isn't in your account, you get an `AccessDeniedException` error.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.InputChannel) : this() {
            this.dataSource = x.dataSource
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.InputChannel = InputChannel(this)

        internal fun correctErrors(): Builder {
            if (roleArn == null) roleArn = ""
            return this
        }
    }
}
