// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetMlInputChannelResponse private constructor(builder: Builder) {
    /**
     * The collaboration ID of the collaboration that contains the ML input channel.
     */
    public val collaborationIdentifier: kotlin.String = requireNotNull(builder.collaborationIdentifier) { "A non-null value must be provided for collaborationIdentifier" }
    /**
     * The configured model algorithm associations that were used to create the ML input channel.
     */
    public val configuredModelAlgorithmAssociations: List<String> = requireNotNull(builder.configuredModelAlgorithmAssociations) { "A non-null value must be provided for configuredModelAlgorithmAssociations" }
    /**
     * The time at which the ML input channel was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The description of the ML input channel.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The input channel that was used to create the ML input channel.
     */
    public val inputChannel: aws.sdk.kotlin.services.cleanroomsml.model.InputChannel? = builder.inputChannel
    /**
     * The Amazon Resource Name (ARN) of the KMS key that was used to create the ML input channel.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The membership ID of the membership that contains the ML input channel.
     */
    public val membershipIdentifier: kotlin.String = requireNotNull(builder.membershipIdentifier) { "A non-null value must be provided for membershipIdentifier" }
    /**
     * The Amazon Resource Name (ARN) of the ML input channel.
     */
    public val mlInputChannelArn: kotlin.String = requireNotNull(builder.mlInputChannelArn) { "A non-null value must be provided for mlInputChannelArn" }
    /**
     * The name of the ML input channel.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The number of files in the ML input channel.
     */
    public val numberOfFiles: kotlin.Double? = builder.numberOfFiles
    /**
     * The number of records in the ML input channel.
     */
    public val numberOfRecords: kotlin.Long? = builder.numberOfRecords
    /**
     * The ID of the protected query that was used to create the ML input channel.
     */
    public val protectedQueryIdentifier: kotlin.String? = builder.protectedQueryIdentifier
    /**
     * The number of days to keep the data in the ML input channel.
     */
    public val retentionInDays: kotlin.Int = requireNotNull(builder.retentionInDays) { "A non-null value must be provided for retentionInDays" }
    /**
     * The size, in GB, of the ML input channel.
     */
    public val sizeInGb: kotlin.Double? = builder.sizeInGb
    /**
     * The status of the ML input channel.
     */
    public val status: aws.sdk.kotlin.services.cleanroomsml.model.MlInputChannelStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * Details about the status of a resource.
     */
    public val statusDetails: aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails? = builder.statusDetails
    /**
     * The optional metadata that you applied to the resource to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
     *
     * The following basic restrictions apply to tags:
     * + Maximum number of tags per resource - 50.
     * + For each resource, each tag key must be unique, and each tag key can have only one value.
     * + Maximum key length - 128 Unicode characters in UTF-8.
     * + Maximum value length - 256 Unicode characters in UTF-8.
     * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
     * + Tag keys and values are case sensitive.
     * + Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The most recent time at which the ML input channel was updated.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.GetMlInputChannelResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetMlInputChannelResponse(")
        append("collaborationIdentifier=$collaborationIdentifier,")
        append("configuredModelAlgorithmAssociations=$configuredModelAlgorithmAssociations,")
        append("createTime=$createTime,")
        append("description=$description,")
        append("inputChannel=$inputChannel,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("membershipIdentifier=$membershipIdentifier,")
        append("mlInputChannelArn=$mlInputChannelArn,")
        append("name=$name,")
        append("numberOfFiles=$numberOfFiles,")
        append("numberOfRecords=$numberOfRecords,")
        append("protectedQueryIdentifier=$protectedQueryIdentifier,")
        append("retentionInDays=$retentionInDays,")
        append("sizeInGb=$sizeInGb,")
        append("status=$status,")
        append("statusDetails=$statusDetails,")
        append("tags=$tags,")
        append("updateTime=$updateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = collaborationIdentifier.hashCode()
        result = 31 * result + (configuredModelAlgorithmAssociations.hashCode())
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (inputChannel?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (membershipIdentifier.hashCode())
        result = 31 * result + (mlInputChannelArn.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (numberOfFiles?.hashCode() ?: 0)
        result = 31 * result + (numberOfRecords?.hashCode() ?: 0)
        result = 31 * result + (protectedQueryIdentifier?.hashCode() ?: 0)
        result = 31 * result + (retentionInDays)
        result = 31 * result + (sizeInGb?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusDetails?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetMlInputChannelResponse

        if (collaborationIdentifier != other.collaborationIdentifier) return false
        if (configuredModelAlgorithmAssociations != other.configuredModelAlgorithmAssociations) return false
        if (createTime != other.createTime) return false
        if (description != other.description) return false
        if (inputChannel != other.inputChannel) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (membershipIdentifier != other.membershipIdentifier) return false
        if (mlInputChannelArn != other.mlInputChannelArn) return false
        if (name != other.name) return false
        if (!(numberOfFiles?.equals(other.numberOfFiles) ?: (other.numberOfFiles == null))) return false
        if (numberOfRecords != other.numberOfRecords) return false
        if (protectedQueryIdentifier != other.protectedQueryIdentifier) return false
        if (retentionInDays != other.retentionInDays) return false
        if (!(sizeInGb?.equals(other.sizeInGb) ?: (other.sizeInGb == null))) return false
        if (status != other.status) return false
        if (statusDetails != other.statusDetails) return false
        if (tags != other.tags) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.GetMlInputChannelResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The collaboration ID of the collaboration that contains the ML input channel.
         */
        public var collaborationIdentifier: kotlin.String? = null
        /**
         * The configured model algorithm associations that were used to create the ML input channel.
         */
        public var configuredModelAlgorithmAssociations: List<String>? = null
        /**
         * The time at which the ML input channel was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the ML input channel.
         */
        public var description: kotlin.String? = null
        /**
         * The input channel that was used to create the ML input channel.
         */
        public var inputChannel: aws.sdk.kotlin.services.cleanroomsml.model.InputChannel? = null
        /**
         * The Amazon Resource Name (ARN) of the KMS key that was used to create the ML input channel.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The membership ID of the membership that contains the ML input channel.
         */
        public var membershipIdentifier: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the ML input channel.
         */
        public var mlInputChannelArn: kotlin.String? = null
        /**
         * The name of the ML input channel.
         */
        public var name: kotlin.String? = null
        /**
         * The number of files in the ML input channel.
         */
        public var numberOfFiles: kotlin.Double? = null
        /**
         * The number of records in the ML input channel.
         */
        public var numberOfRecords: kotlin.Long? = null
        /**
         * The ID of the protected query that was used to create the ML input channel.
         */
        public var protectedQueryIdentifier: kotlin.String? = null
        /**
         * The number of days to keep the data in the ML input channel.
         */
        public var retentionInDays: kotlin.Int? = null
        /**
         * The size, in GB, of the ML input channel.
         */
        public var sizeInGb: kotlin.Double? = null
        /**
         * The status of the ML input channel.
         */
        public var status: aws.sdk.kotlin.services.cleanroomsml.model.MlInputChannelStatus? = null
        /**
         * Details about the status of a resource.
         */
        public var statusDetails: aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails? = null
        /**
         * The optional metadata that you applied to the resource to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
         *
         * The following basic restrictions apply to tags:
         * + Maximum number of tags per resource - 50.
         * + For each resource, each tag key must be unique, and each tag key can have only one value.
         * + Maximum key length - 128 Unicode characters in UTF-8.
         * + Maximum value length - 256 Unicode characters in UTF-8.
         * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         * + Tag keys and values are case sensitive.
         * + Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.
         */
        public var tags: Map<String, String>? = null
        /**
         * The most recent time at which the ML input channel was updated.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.GetMlInputChannelResponse) : this() {
            this.collaborationIdentifier = x.collaborationIdentifier
            this.configuredModelAlgorithmAssociations = x.configuredModelAlgorithmAssociations
            this.createTime = x.createTime
            this.description = x.description
            this.inputChannel = x.inputChannel
            this.kmsKeyArn = x.kmsKeyArn
            this.membershipIdentifier = x.membershipIdentifier
            this.mlInputChannelArn = x.mlInputChannelArn
            this.name = x.name
            this.numberOfFiles = x.numberOfFiles
            this.numberOfRecords = x.numberOfRecords
            this.protectedQueryIdentifier = x.protectedQueryIdentifier
            this.retentionInDays = x.retentionInDays
            this.sizeInGb = x.sizeInGb
            this.status = x.status
            this.statusDetails = x.statusDetails
            this.tags = x.tags
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.GetMlInputChannelResponse = GetMlInputChannelResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.InputChannel] inside the given [block]
         */
        public fun inputChannel(block: aws.sdk.kotlin.services.cleanroomsml.model.InputChannel.Builder.() -> kotlin.Unit) {
            this.inputChannel = aws.sdk.kotlin.services.cleanroomsml.model.InputChannel.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails] inside the given [block]
         */
        public fun statusDetails(block: aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails.Builder.() -> kotlin.Unit) {
            this.statusDetails = aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (collaborationIdentifier == null) collaborationIdentifier = ""
            if (configuredModelAlgorithmAssociations == null) configuredModelAlgorithmAssociations = emptyList()
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (membershipIdentifier == null) membershipIdentifier = ""
            if (mlInputChannelArn == null) mlInputChannelArn = ""
            if (name == null) name = ""
            if (retentionInDays == null) retentionInDays = 0
            if (status == null) status = MlInputChannelStatus.SdkUnknown("no value provided")
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
