// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetMlConfigurationResponse private constructor(builder: Builder) {
    /**
     * The time at which the ML configuration was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The Amazon S3 location where ML model output is stored.
     */
    public val defaultOutputLocation: aws.sdk.kotlin.services.cleanroomsml.model.MlOutputConfiguration? = builder.defaultOutputLocation
    /**
     * The membership ID of the member that owns the ML configuration you requested.
     */
    public val membershipIdentifier: kotlin.String = requireNotNull(builder.membershipIdentifier) { "A non-null value must be provided for membershipIdentifier" }
    /**
     * The most recent time at which the ML configuration was updated.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.GetMlConfigurationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetMlConfigurationResponse(")
        append("createTime=$createTime,")
        append("defaultOutputLocation=$defaultOutputLocation,")
        append("membershipIdentifier=$membershipIdentifier,")
        append("updateTime=$updateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createTime.hashCode()
        result = 31 * result + (defaultOutputLocation?.hashCode() ?: 0)
        result = 31 * result + (membershipIdentifier.hashCode())
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetMlConfigurationResponse

        if (createTime != other.createTime) return false
        if (defaultOutputLocation != other.defaultOutputLocation) return false
        if (membershipIdentifier != other.membershipIdentifier) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.GetMlConfigurationResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time at which the ML configuration was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon S3 location where ML model output is stored.
         */
        public var defaultOutputLocation: aws.sdk.kotlin.services.cleanroomsml.model.MlOutputConfiguration? = null
        /**
         * The membership ID of the member that owns the ML configuration you requested.
         */
        public var membershipIdentifier: kotlin.String? = null
        /**
         * The most recent time at which the ML configuration was updated.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.GetMlConfigurationResponse) : this() {
            this.createTime = x.createTime
            this.defaultOutputLocation = x.defaultOutputLocation
            this.membershipIdentifier = x.membershipIdentifier
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.GetMlConfigurationResponse = GetMlConfigurationResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.MlOutputConfiguration] inside the given [block]
         */
        public fun defaultOutputLocation(block: aws.sdk.kotlin.services.cleanroomsml.model.MlOutputConfiguration.Builder.() -> kotlin.Unit) {
            this.defaultOutputLocation = aws.sdk.kotlin.services.cleanroomsml.model.MlOutputConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (membershipIdentifier == null) membershipIdentifier = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
