// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetConfiguredModelAlgorithmResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the configured model algorithm.
     */
    public val configuredModelAlgorithmArn: kotlin.String = requireNotNull(builder.configuredModelAlgorithmArn) { "A non-null value must be provided for configuredModelAlgorithmArn" }
    /**
     * The time at which the configured model algorithm was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The description of the configured model algorithm.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Configuration information for the inference container.
     */
    public val inferenceContainerConfig: aws.sdk.kotlin.services.cleanroomsml.model.InferenceContainerConfig? = builder.inferenceContainerConfig
    /**
     * The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned data in the configured ML model and associated data.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The name of the configured model algorithm.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The Amazon Resource Name (ARN) of the service role that was used to create the configured model algorithm.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The optional metadata that you applied to the resource to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
     *
     * The following basic restrictions apply to tags:
     * + Maximum number of tags per resource - 50.
     * + For each resource, each tag key must be unique, and each tag key can have only one value.
     * + Maximum key length - 128 Unicode characters in UTF-8.
     * + Maximum value length - 256 Unicode characters in UTF-8.
     * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
     * + Tag keys and values are case sensitive.
     * + Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The configuration information of the training container for the configured model algorithm.
     */
    public val trainingContainerConfig: aws.sdk.kotlin.services.cleanroomsml.model.ContainerConfig? = builder.trainingContainerConfig
    /**
     * The most recent time at which the configured model algorithm was updated.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.GetConfiguredModelAlgorithmResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetConfiguredModelAlgorithmResponse(")
        append("configuredModelAlgorithmArn=$configuredModelAlgorithmArn,")
        append("createTime=$createTime,")
        append("description=$description,")
        append("inferenceContainerConfig=$inferenceContainerConfig,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("tags=$tags,")
        append("trainingContainerConfig=$trainingContainerConfig,")
        append("updateTime=$updateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configuredModelAlgorithmArn.hashCode()
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (inferenceContainerConfig?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (trainingContainerConfig?.hashCode() ?: 0)
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetConfiguredModelAlgorithmResponse

        if (configuredModelAlgorithmArn != other.configuredModelAlgorithmArn) return false
        if (createTime != other.createTime) return false
        if (description != other.description) return false
        if (inferenceContainerConfig != other.inferenceContainerConfig) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false
        if (trainingContainerConfig != other.trainingContainerConfig) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.GetConfiguredModelAlgorithmResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the configured model algorithm.
         */
        public var configuredModelAlgorithmArn: kotlin.String? = null
        /**
         * The time at which the configured model algorithm was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the configured model algorithm.
         */
        public var description: kotlin.String? = null
        /**
         * Configuration information for the inference container.
         */
        public var inferenceContainerConfig: aws.sdk.kotlin.services.cleanroomsml.model.InferenceContainerConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned data in the configured ML model and associated data.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The name of the configured model algorithm.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the service role that was used to create the configured model algorithm.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The optional metadata that you applied to the resource to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
         *
         * The following basic restrictions apply to tags:
         * + Maximum number of tags per resource - 50.
         * + For each resource, each tag key must be unique, and each tag key can have only one value.
         * + Maximum key length - 128 Unicode characters in UTF-8.
         * + Maximum value length - 256 Unicode characters in UTF-8.
         * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         * + Tag keys and values are case sensitive.
         * + Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.
         */
        public var tags: Map<String, String>? = null
        /**
         * The configuration information of the training container for the configured model algorithm.
         */
        public var trainingContainerConfig: aws.sdk.kotlin.services.cleanroomsml.model.ContainerConfig? = null
        /**
         * The most recent time at which the configured model algorithm was updated.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.GetConfiguredModelAlgorithmResponse) : this() {
            this.configuredModelAlgorithmArn = x.configuredModelAlgorithmArn
            this.createTime = x.createTime
            this.description = x.description
            this.inferenceContainerConfig = x.inferenceContainerConfig
            this.kmsKeyArn = x.kmsKeyArn
            this.name = x.name
            this.roleArn = x.roleArn
            this.tags = x.tags
            this.trainingContainerConfig = x.trainingContainerConfig
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.GetConfiguredModelAlgorithmResponse = GetConfiguredModelAlgorithmResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.InferenceContainerConfig] inside the given [block]
         */
        public fun inferenceContainerConfig(block: aws.sdk.kotlin.services.cleanroomsml.model.InferenceContainerConfig.Builder.() -> kotlin.Unit) {
            this.inferenceContainerConfig = aws.sdk.kotlin.services.cleanroomsml.model.InferenceContainerConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.ContainerConfig] inside the given [block]
         */
        public fun trainingContainerConfig(block: aws.sdk.kotlin.services.cleanroomsml.model.ContainerConfig.Builder.() -> kotlin.Unit) {
            this.trainingContainerConfig = aws.sdk.kotlin.services.cleanroomsml.model.ContainerConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (configuredModelAlgorithmArn == null) configuredModelAlgorithmArn = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            if (roleArn == null) roleArn = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
