// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetConfiguredModelAlgorithmAssociationResponse private constructor(builder: Builder) {
    /**
     * The collaboration ID of the collaboration that contains the configured model algorithm association.
     */
    public val collaborationIdentifier: kotlin.String = requireNotNull(builder.collaborationIdentifier) { "A non-null value must be provided for collaborationIdentifier" }
    /**
     * The Amazon Resource Name (ARN) of the configured model algorithm that was associated to the collaboration.
     */
    public val configuredModelAlgorithmArn: kotlin.String = requireNotNull(builder.configuredModelAlgorithmArn) { "A non-null value must be provided for configuredModelAlgorithmArn" }
    /**
     * The Amazon Resource Name (ARN) of the configured model algorithm association.
     */
    public val configuredModelAlgorithmAssociationArn: kotlin.String = requireNotNull(builder.configuredModelAlgorithmAssociationArn) { "A non-null value must be provided for configuredModelAlgorithmAssociationArn" }
    /**
     * The time at which the configured model algorithm association was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The description of the configured model algorithm association.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The membership ID of the member that created the configured model algorithm association.
     */
    public val membershipIdentifier: kotlin.String = requireNotNull(builder.membershipIdentifier) { "A non-null value must be provided for membershipIdentifier" }
    /**
     * The name of the configured model algorithm association.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The privacy configuration information for the configured model algorithm association.
     */
    public val privacyConfiguration: aws.sdk.kotlin.services.cleanroomsml.model.PrivacyConfiguration? = builder.privacyConfiguration
    /**
     * The optional metadata that you applied to the resource to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
     *
     * The following basic restrictions apply to tags:
     * + Maximum number of tags per resource - 50.
     * + For each resource, each tag key must be unique, and each tag key can have only one value.
     * + Maximum key length - 128 Unicode characters in UTF-8.
     * + Maximum value length - 256 Unicode characters in UTF-8.
     * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
     * + Tag keys and values are case sensitive.
     * + Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The most recent time at which the configured model algorithm association was updated.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.GetConfiguredModelAlgorithmAssociationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetConfiguredModelAlgorithmAssociationResponse(")
        append("collaborationIdentifier=$collaborationIdentifier,")
        append("configuredModelAlgorithmArn=$configuredModelAlgorithmArn,")
        append("configuredModelAlgorithmAssociationArn=$configuredModelAlgorithmAssociationArn,")
        append("createTime=$createTime,")
        append("description=$description,")
        append("membershipIdentifier=$membershipIdentifier,")
        append("name=$name,")
        append("privacyConfiguration=$privacyConfiguration,")
        append("tags=$tags,")
        append("updateTime=$updateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = collaborationIdentifier.hashCode()
        result = 31 * result + (configuredModelAlgorithmArn.hashCode())
        result = 31 * result + (configuredModelAlgorithmAssociationArn.hashCode())
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (membershipIdentifier.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (privacyConfiguration?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetConfiguredModelAlgorithmAssociationResponse

        if (collaborationIdentifier != other.collaborationIdentifier) return false
        if (configuredModelAlgorithmArn != other.configuredModelAlgorithmArn) return false
        if (configuredModelAlgorithmAssociationArn != other.configuredModelAlgorithmAssociationArn) return false
        if (createTime != other.createTime) return false
        if (description != other.description) return false
        if (membershipIdentifier != other.membershipIdentifier) return false
        if (name != other.name) return false
        if (privacyConfiguration != other.privacyConfiguration) return false
        if (tags != other.tags) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.GetConfiguredModelAlgorithmAssociationResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The collaboration ID of the collaboration that contains the configured model algorithm association.
         */
        public var collaborationIdentifier: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the configured model algorithm that was associated to the collaboration.
         */
        public var configuredModelAlgorithmArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the configured model algorithm association.
         */
        public var configuredModelAlgorithmAssociationArn: kotlin.String? = null
        /**
         * The time at which the configured model algorithm association was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the configured model algorithm association.
         */
        public var description: kotlin.String? = null
        /**
         * The membership ID of the member that created the configured model algorithm association.
         */
        public var membershipIdentifier: kotlin.String? = null
        /**
         * The name of the configured model algorithm association.
         */
        public var name: kotlin.String? = null
        /**
         * The privacy configuration information for the configured model algorithm association.
         */
        public var privacyConfiguration: aws.sdk.kotlin.services.cleanroomsml.model.PrivacyConfiguration? = null
        /**
         * The optional metadata that you applied to the resource to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
         *
         * The following basic restrictions apply to tags:
         * + Maximum number of tags per resource - 50.
         * + For each resource, each tag key must be unique, and each tag key can have only one value.
         * + Maximum key length - 128 Unicode characters in UTF-8.
         * + Maximum value length - 256 Unicode characters in UTF-8.
         * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         * + Tag keys and values are case sensitive.
         * + Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.
         */
        public var tags: Map<String, String>? = null
        /**
         * The most recent time at which the configured model algorithm association was updated.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.GetConfiguredModelAlgorithmAssociationResponse) : this() {
            this.collaborationIdentifier = x.collaborationIdentifier
            this.configuredModelAlgorithmArn = x.configuredModelAlgorithmArn
            this.configuredModelAlgorithmAssociationArn = x.configuredModelAlgorithmAssociationArn
            this.createTime = x.createTime
            this.description = x.description
            this.membershipIdentifier = x.membershipIdentifier
            this.name = x.name
            this.privacyConfiguration = x.privacyConfiguration
            this.tags = x.tags
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.GetConfiguredModelAlgorithmAssociationResponse = GetConfiguredModelAlgorithmAssociationResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.PrivacyConfiguration] inside the given [block]
         */
        public fun privacyConfiguration(block: aws.sdk.kotlin.services.cleanroomsml.model.PrivacyConfiguration.Builder.() -> kotlin.Unit) {
            this.privacyConfiguration = aws.sdk.kotlin.services.cleanroomsml.model.PrivacyConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (collaborationIdentifier == null) collaborationIdentifier = ""
            if (configuredModelAlgorithmArn == null) configuredModelAlgorithmArn = ""
            if (configuredModelAlgorithmAssociationArn == null) configuredModelAlgorithmAssociationArn = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (membershipIdentifier == null) membershipIdentifier = ""
            if (name == null) name = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
