// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetCollaborationConfiguredModelAlgorithmAssociationResponse private constructor(builder: Builder) {
    /**
     * The collaboration ID of the collaboration that contains the configured model algorithm association.
     */
    public val collaborationIdentifier: kotlin.String = requireNotNull(builder.collaborationIdentifier) { "A non-null value must be provided for collaborationIdentifier" }
    /**
     * The Amazon Resource Name (ARN) of the configured model algorithm association.
     */
    public val configuredModelAlgorithmArn: kotlin.String = requireNotNull(builder.configuredModelAlgorithmArn) { "A non-null value must be provided for configuredModelAlgorithmArn" }
    /**
     * The Amazon Resource Name (ARN) of the configured model algorithm association.
     */
    public val configuredModelAlgorithmAssociationArn: kotlin.String = requireNotNull(builder.configuredModelAlgorithmAssociationArn) { "A non-null value must be provided for configuredModelAlgorithmAssociationArn" }
    /**
     * The time at which the configured model algorithm association was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The account ID of the member that created the configured model algorithm association.
     */
    public val creatorAccountId: kotlin.String = requireNotNull(builder.creatorAccountId) { "A non-null value must be provided for creatorAccountId" }
    /**
     * The description of the configured model algorithm association.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The membership ID of the member that created the configured model algorithm association.
     */
    public val membershipIdentifier: kotlin.String = requireNotNull(builder.membershipIdentifier) { "A non-null value must be provided for membershipIdentifier" }
    /**
     * The name of the configured model algorithm association.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Information about the privacy configuration for a configured model algorithm association.
     */
    public val privacyConfiguration: aws.sdk.kotlin.services.cleanroomsml.model.PrivacyConfiguration? = builder.privacyConfiguration
    /**
     * The most recent time at which the configured model algorithm association was updated.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.GetCollaborationConfiguredModelAlgorithmAssociationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetCollaborationConfiguredModelAlgorithmAssociationResponse(")
        append("collaborationIdentifier=$collaborationIdentifier,")
        append("configuredModelAlgorithmArn=$configuredModelAlgorithmArn,")
        append("configuredModelAlgorithmAssociationArn=$configuredModelAlgorithmAssociationArn,")
        append("createTime=$createTime,")
        append("creatorAccountId=$creatorAccountId,")
        append("description=$description,")
        append("membershipIdentifier=$membershipIdentifier,")
        append("name=$name,")
        append("privacyConfiguration=$privacyConfiguration,")
        append("updateTime=$updateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = collaborationIdentifier.hashCode()
        result = 31 * result + (configuredModelAlgorithmArn.hashCode())
        result = 31 * result + (configuredModelAlgorithmAssociationArn.hashCode())
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (creatorAccountId.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (membershipIdentifier.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (privacyConfiguration?.hashCode() ?: 0)
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetCollaborationConfiguredModelAlgorithmAssociationResponse

        if (collaborationIdentifier != other.collaborationIdentifier) return false
        if (configuredModelAlgorithmArn != other.configuredModelAlgorithmArn) return false
        if (configuredModelAlgorithmAssociationArn != other.configuredModelAlgorithmAssociationArn) return false
        if (createTime != other.createTime) return false
        if (creatorAccountId != other.creatorAccountId) return false
        if (description != other.description) return false
        if (membershipIdentifier != other.membershipIdentifier) return false
        if (name != other.name) return false
        if (privacyConfiguration != other.privacyConfiguration) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.GetCollaborationConfiguredModelAlgorithmAssociationResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The collaboration ID of the collaboration that contains the configured model algorithm association.
         */
        public var collaborationIdentifier: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the configured model algorithm association.
         */
        public var configuredModelAlgorithmArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the configured model algorithm association.
         */
        public var configuredModelAlgorithmAssociationArn: kotlin.String? = null
        /**
         * The time at which the configured model algorithm association was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The account ID of the member that created the configured model algorithm association.
         */
        public var creatorAccountId: kotlin.String? = null
        /**
         * The description of the configured model algorithm association.
         */
        public var description: kotlin.String? = null
        /**
         * The membership ID of the member that created the configured model algorithm association.
         */
        public var membershipIdentifier: kotlin.String? = null
        /**
         * The name of the configured model algorithm association.
         */
        public var name: kotlin.String? = null
        /**
         * Information about the privacy configuration for a configured model algorithm association.
         */
        public var privacyConfiguration: aws.sdk.kotlin.services.cleanroomsml.model.PrivacyConfiguration? = null
        /**
         * The most recent time at which the configured model algorithm association was updated.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.GetCollaborationConfiguredModelAlgorithmAssociationResponse) : this() {
            this.collaborationIdentifier = x.collaborationIdentifier
            this.configuredModelAlgorithmArn = x.configuredModelAlgorithmArn
            this.configuredModelAlgorithmAssociationArn = x.configuredModelAlgorithmAssociationArn
            this.createTime = x.createTime
            this.creatorAccountId = x.creatorAccountId
            this.description = x.description
            this.membershipIdentifier = x.membershipIdentifier
            this.name = x.name
            this.privacyConfiguration = x.privacyConfiguration
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.GetCollaborationConfiguredModelAlgorithmAssociationResponse = GetCollaborationConfiguredModelAlgorithmAssociationResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.PrivacyConfiguration] inside the given [block]
         */
        public fun privacyConfiguration(block: aws.sdk.kotlin.services.cleanroomsml.model.PrivacyConfiguration.Builder.() -> kotlin.Unit) {
            this.privacyConfiguration = aws.sdk.kotlin.services.cleanroomsml.model.PrivacyConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (collaborationIdentifier == null) collaborationIdentifier = ""
            if (configuredModelAlgorithmArn == null) configuredModelAlgorithmArn = ""
            if (configuredModelAlgorithmAssociationArn == null) configuredModelAlgorithmAssociationArn = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (creatorAccountId == null) creatorAccountId = ""
            if (membershipIdentifier == null) membershipIdentifier = ""
            if (name == null) name = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
