// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateTrainedModelRequest private constructor(builder: Builder) {
    /**
     * The associated configured model algorithm used to train this model.
     */
    public val configuredModelAlgorithmAssociationArn: kotlin.String? = builder.configuredModelAlgorithmAssociationArn
    /**
     * Defines the data channels that are used as input for the trained model request.
     */
    public val dataChannels: List<ModelTrainingDataChannel>? = builder.dataChannels
    /**
     * The description of the trained model.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The environment variables to set in the Docker container.
     */
    public val environment: Map<String, String>? = builder.environment
    /**
     * Algorithm-specific parameters that influence the quality of the model. You set hyperparameters before you start the learning process.
     */
    public val hyperparameters: Map<String, String>? = builder.hyperparameters
    /**
     * The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned data in the trained ML model and the associated data.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The membership ID of the member that is creating the trained model.
     */
    public val membershipIdentifier: kotlin.String? = builder.membershipIdentifier
    /**
     * The name of the trained model.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Information about the EC2 resources that are used to train this model.
     */
    public val resourceConfig: aws.sdk.kotlin.services.cleanroomsml.model.ResourceConfig? = builder.resourceConfig
    /**
     * The criteria that is used to stop model training.
     */
    public val stoppingCondition: aws.sdk.kotlin.services.cleanroomsml.model.StoppingCondition? = builder.stoppingCondition
    /**
     * The optional metadata that you apply to the resource to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
     *
     * The following basic restrictions apply to tags:
     * + Maximum number of tags per resource - 50.
     * + For each resource, each tag key must be unique, and each tag key can have only one value.
     * + Maximum key length - 128 Unicode characters in UTF-8.
     * + Maximum value length - 256 Unicode characters in UTF-8.
     * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
     * + Tag keys and values are case sensitive.
     * + Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.CreateTrainedModelRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTrainedModelRequest(")
        append("configuredModelAlgorithmAssociationArn=$configuredModelAlgorithmAssociationArn,")
        append("dataChannels=$dataChannels,")
        append("description=$description,")
        append("environment=$environment,")
        append("hyperparameters=$hyperparameters,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("membershipIdentifier=$membershipIdentifier,")
        append("name=$name,")
        append("resourceConfig=$resourceConfig,")
        append("stoppingCondition=$stoppingCondition,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configuredModelAlgorithmAssociationArn?.hashCode() ?: 0
        result = 31 * result + (dataChannels?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (hyperparameters?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (membershipIdentifier?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceConfig?.hashCode() ?: 0)
        result = 31 * result + (stoppingCondition?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTrainedModelRequest

        if (configuredModelAlgorithmAssociationArn != other.configuredModelAlgorithmAssociationArn) return false
        if (dataChannels != other.dataChannels) return false
        if (description != other.description) return false
        if (environment != other.environment) return false
        if (hyperparameters != other.hyperparameters) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (membershipIdentifier != other.membershipIdentifier) return false
        if (name != other.name) return false
        if (resourceConfig != other.resourceConfig) return false
        if (stoppingCondition != other.stoppingCondition) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.CreateTrainedModelRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The associated configured model algorithm used to train this model.
         */
        public var configuredModelAlgorithmAssociationArn: kotlin.String? = null
        /**
         * Defines the data channels that are used as input for the trained model request.
         */
        public var dataChannels: List<ModelTrainingDataChannel>? = null
        /**
         * The description of the trained model.
         */
        public var description: kotlin.String? = null
        /**
         * The environment variables to set in the Docker container.
         */
        public var environment: Map<String, String>? = null
        /**
         * Algorithm-specific parameters that influence the quality of the model. You set hyperparameters before you start the learning process.
         */
        public var hyperparameters: Map<String, String>? = null
        /**
         * The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned data in the trained ML model and the associated data.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The membership ID of the member that is creating the trained model.
         */
        public var membershipIdentifier: kotlin.String? = null
        /**
         * The name of the trained model.
         */
        public var name: kotlin.String? = null
        /**
         * Information about the EC2 resources that are used to train this model.
         */
        public var resourceConfig: aws.sdk.kotlin.services.cleanroomsml.model.ResourceConfig? = null
        /**
         * The criteria that is used to stop model training.
         */
        public var stoppingCondition: aws.sdk.kotlin.services.cleanroomsml.model.StoppingCondition? = null
        /**
         * The optional metadata that you apply to the resource to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
         *
         * The following basic restrictions apply to tags:
         * + Maximum number of tags per resource - 50.
         * + For each resource, each tag key must be unique, and each tag key can have only one value.
         * + Maximum key length - 128 Unicode characters in UTF-8.
         * + Maximum value length - 256 Unicode characters in UTF-8.
         * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         * + Tag keys and values are case sensitive.
         * + Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.CreateTrainedModelRequest) : this() {
            this.configuredModelAlgorithmAssociationArn = x.configuredModelAlgorithmAssociationArn
            this.dataChannels = x.dataChannels
            this.description = x.description
            this.environment = x.environment
            this.hyperparameters = x.hyperparameters
            this.kmsKeyArn = x.kmsKeyArn
            this.membershipIdentifier = x.membershipIdentifier
            this.name = x.name
            this.resourceConfig = x.resourceConfig
            this.stoppingCondition = x.stoppingCondition
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.CreateTrainedModelRequest = CreateTrainedModelRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.ResourceConfig] inside the given [block]
         */
        public fun resourceConfig(block: aws.sdk.kotlin.services.cleanroomsml.model.ResourceConfig.Builder.() -> kotlin.Unit) {
            this.resourceConfig = aws.sdk.kotlin.services.cleanroomsml.model.ResourceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.StoppingCondition] inside the given [block]
         */
        public fun stoppingCondition(block: aws.sdk.kotlin.services.cleanroomsml.model.StoppingCondition.Builder.() -> kotlin.Unit) {
            this.stoppingCondition = aws.sdk.kotlin.services.cleanroomsml.model.StoppingCondition.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
