// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides summary information about a trained model in a collaboration.
 */
public class CollaborationTrainedModelSummary private constructor(builder: Builder) {
    /**
     * The collaboration ID of the collaboration that contains the trained model.
     */
    public val collaborationIdentifier: kotlin.String = requireNotNull(builder.collaborationIdentifier) { "A non-null value must be provided for collaborationIdentifier" }
    /**
     * The Amazon Resource Name (ARN) of the configured model algorithm association that is used for this trained model.
     */
    public val configuredModelAlgorithmAssociationArn: kotlin.String = requireNotNull(builder.configuredModelAlgorithmAssociationArn) { "A non-null value must be provided for configuredModelAlgorithmAssociationArn" }
    /**
     * The time at which the trained model was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The account ID of the member that created the trained model.
     */
    public val creatorAccountId: kotlin.String = requireNotNull(builder.creatorAccountId) { "A non-null value must be provided for creatorAccountId" }
    /**
     * The description of the trained model.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The membership ID of the member that created the trained model.
     */
    public val membershipIdentifier: kotlin.String = requireNotNull(builder.membershipIdentifier) { "A non-null value must be provided for membershipIdentifier" }
    /**
     * The name of the trained model.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The status of the trained model.
     */
    public val status: aws.sdk.kotlin.services.cleanroomsml.model.TrainedModelStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The Amazon Resource Name (ARN) of the trained model.
     */
    public val trainedModelArn: kotlin.String = requireNotNull(builder.trainedModelArn) { "A non-null value must be provided for trainedModelArn" }
    /**
     * The most recent time at which the trained model was updated.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.CollaborationTrainedModelSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CollaborationTrainedModelSummary(")
        append("collaborationIdentifier=$collaborationIdentifier,")
        append("configuredModelAlgorithmAssociationArn=$configuredModelAlgorithmAssociationArn,")
        append("createTime=$createTime,")
        append("creatorAccountId=$creatorAccountId,")
        append("description=$description,")
        append("membershipIdentifier=$membershipIdentifier,")
        append("name=$name,")
        append("status=$status,")
        append("trainedModelArn=$trainedModelArn,")
        append("updateTime=$updateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = collaborationIdentifier.hashCode()
        result = 31 * result + (configuredModelAlgorithmAssociationArn.hashCode())
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (creatorAccountId.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (membershipIdentifier.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (trainedModelArn.hashCode())
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CollaborationTrainedModelSummary

        if (collaborationIdentifier != other.collaborationIdentifier) return false
        if (configuredModelAlgorithmAssociationArn != other.configuredModelAlgorithmAssociationArn) return false
        if (createTime != other.createTime) return false
        if (creatorAccountId != other.creatorAccountId) return false
        if (description != other.description) return false
        if (membershipIdentifier != other.membershipIdentifier) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (trainedModelArn != other.trainedModelArn) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.CollaborationTrainedModelSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The collaboration ID of the collaboration that contains the trained model.
         */
        public var collaborationIdentifier: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the configured model algorithm association that is used for this trained model.
         */
        public var configuredModelAlgorithmAssociationArn: kotlin.String? = null
        /**
         * The time at which the trained model was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The account ID of the member that created the trained model.
         */
        public var creatorAccountId: kotlin.String? = null
        /**
         * The description of the trained model.
         */
        public var description: kotlin.String? = null
        /**
         * The membership ID of the member that created the trained model.
         */
        public var membershipIdentifier: kotlin.String? = null
        /**
         * The name of the trained model.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the trained model.
         */
        public var status: aws.sdk.kotlin.services.cleanroomsml.model.TrainedModelStatus? = null
        /**
         * The Amazon Resource Name (ARN) of the trained model.
         */
        public var trainedModelArn: kotlin.String? = null
        /**
         * The most recent time at which the trained model was updated.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.CollaborationTrainedModelSummary) : this() {
            this.collaborationIdentifier = x.collaborationIdentifier
            this.configuredModelAlgorithmAssociationArn = x.configuredModelAlgorithmAssociationArn
            this.createTime = x.createTime
            this.creatorAccountId = x.creatorAccountId
            this.description = x.description
            this.membershipIdentifier = x.membershipIdentifier
            this.name = x.name
            this.status = x.status
            this.trainedModelArn = x.trainedModelArn
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.CollaborationTrainedModelSummary = CollaborationTrainedModelSummary(this)

        internal fun correctErrors(): Builder {
            if (collaborationIdentifier == null) collaborationIdentifier = ""
            if (configuredModelAlgorithmAssociationArn == null) configuredModelAlgorithmAssociationArn = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (creatorAccountId == null) creatorAccountId = ""
            if (membershipIdentifier == null) membershipIdentifier = ""
            if (name == null) name = ""
            if (status == null) status = TrainedModelStatus.SdkUnknown("no value provided")
            if (trainedModelArn == null) trainedModelArn = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
