// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides summary information about a trained model inference job in a collaboration.
 */
public class CollaborationTrainedModelInferenceJobSummary private constructor(builder: Builder) {
    /**
     * The collaboration ID of the collaboration that contains the trained model inference job.
     */
    public val collaborationIdentifier: kotlin.String = requireNotNull(builder.collaborationIdentifier) { "A non-null value must be provided for collaborationIdentifier" }
    /**
     * The Amazon Resource Name (ARN) of the configured model algorithm association that is used for the trained model inference job.
     */
    public val configuredModelAlgorithmAssociationArn: kotlin.String? = builder.configuredModelAlgorithmAssociationArn
    /**
     * The time at which the trained model inference job was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The account ID that created the trained model inference job.
     */
    public val creatorAccountId: kotlin.String = requireNotNull(builder.creatorAccountId) { "A non-null value must be provided for creatorAccountId" }
    /**
     * The description of the trained model inference job.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The trained model inference job logs status.
     */
    public val logsStatus: aws.sdk.kotlin.services.cleanroomsml.model.LogsStatus? = builder.logsStatus
    /**
     * Details about the logs status for the trained model inference job.
     */
    public val logsStatusDetails: kotlin.String? = builder.logsStatusDetails
    /**
     * The membership ID of the membership that contains the trained model inference job.
     */
    public val membershipIdentifier: kotlin.String = requireNotNull(builder.membershipIdentifier) { "A non-null value must be provided for membershipIdentifier" }
    /**
     * the trained model inference job metrics status.
     */
    public val metricsStatus: aws.sdk.kotlin.services.cleanroomsml.model.MetricsStatus? = builder.metricsStatus
    /**
     * Details about the metrics status for trained model inference job.
     */
    public val metricsStatusDetails: kotlin.String? = builder.metricsStatusDetails
    /**
     * The name of the trained model inference job.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Returns output configuration information for the trained model inference job.
     */
    public val outputConfiguration: aws.sdk.kotlin.services.cleanroomsml.model.InferenceOutputConfiguration? = builder.outputConfiguration
    /**
     * The status of the trained model inference job.
     */
    public val status: aws.sdk.kotlin.services.cleanroomsml.model.TrainedModelInferenceJobStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The Amazon Resource Name (ARN) of the trained model that is used for the trained model inference job.
     */
    public val trainedModelArn: kotlin.String = requireNotNull(builder.trainedModelArn) { "A non-null value must be provided for trainedModelArn" }
    /**
     * The Amazon Resource Name (ARN) of the trained model inference job.
     */
    public val trainedModelInferenceJobArn: kotlin.String = requireNotNull(builder.trainedModelInferenceJobArn) { "A non-null value must be provided for trainedModelInferenceJobArn" }
    /**
     * The most recent time at which the trained model inference job was updated.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.CollaborationTrainedModelInferenceJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CollaborationTrainedModelInferenceJobSummary(")
        append("collaborationIdentifier=$collaborationIdentifier,")
        append("configuredModelAlgorithmAssociationArn=$configuredModelAlgorithmAssociationArn,")
        append("createTime=$createTime,")
        append("creatorAccountId=$creatorAccountId,")
        append("description=$description,")
        append("logsStatus=$logsStatus,")
        append("logsStatusDetails=$logsStatusDetails,")
        append("membershipIdentifier=$membershipIdentifier,")
        append("metricsStatus=$metricsStatus,")
        append("metricsStatusDetails=$metricsStatusDetails,")
        append("name=$name,")
        append("outputConfiguration=$outputConfiguration,")
        append("status=$status,")
        append("trainedModelArn=$trainedModelArn,")
        append("trainedModelInferenceJobArn=$trainedModelInferenceJobArn,")
        append("updateTime=$updateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = collaborationIdentifier.hashCode()
        result = 31 * result + (configuredModelAlgorithmAssociationArn?.hashCode() ?: 0)
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (creatorAccountId.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (logsStatus?.hashCode() ?: 0)
        result = 31 * result + (logsStatusDetails?.hashCode() ?: 0)
        result = 31 * result + (membershipIdentifier.hashCode())
        result = 31 * result + (metricsStatus?.hashCode() ?: 0)
        result = 31 * result + (metricsStatusDetails?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (outputConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (trainedModelArn.hashCode())
        result = 31 * result + (trainedModelInferenceJobArn.hashCode())
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CollaborationTrainedModelInferenceJobSummary

        if (collaborationIdentifier != other.collaborationIdentifier) return false
        if (configuredModelAlgorithmAssociationArn != other.configuredModelAlgorithmAssociationArn) return false
        if (createTime != other.createTime) return false
        if (creatorAccountId != other.creatorAccountId) return false
        if (description != other.description) return false
        if (logsStatus != other.logsStatus) return false
        if (logsStatusDetails != other.logsStatusDetails) return false
        if (membershipIdentifier != other.membershipIdentifier) return false
        if (metricsStatus != other.metricsStatus) return false
        if (metricsStatusDetails != other.metricsStatusDetails) return false
        if (name != other.name) return false
        if (outputConfiguration != other.outputConfiguration) return false
        if (status != other.status) return false
        if (trainedModelArn != other.trainedModelArn) return false
        if (trainedModelInferenceJobArn != other.trainedModelInferenceJobArn) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.CollaborationTrainedModelInferenceJobSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The collaboration ID of the collaboration that contains the trained model inference job.
         */
        public var collaborationIdentifier: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the configured model algorithm association that is used for the trained model inference job.
         */
        public var configuredModelAlgorithmAssociationArn: kotlin.String? = null
        /**
         * The time at which the trained model inference job was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The account ID that created the trained model inference job.
         */
        public var creatorAccountId: kotlin.String? = null
        /**
         * The description of the trained model inference job.
         */
        public var description: kotlin.String? = null
        /**
         * The trained model inference job logs status.
         */
        public var logsStatus: aws.sdk.kotlin.services.cleanroomsml.model.LogsStatus? = null
        /**
         * Details about the logs status for the trained model inference job.
         */
        public var logsStatusDetails: kotlin.String? = null
        /**
         * The membership ID of the membership that contains the trained model inference job.
         */
        public var membershipIdentifier: kotlin.String? = null
        /**
         * the trained model inference job metrics status.
         */
        public var metricsStatus: aws.sdk.kotlin.services.cleanroomsml.model.MetricsStatus? = null
        /**
         * Details about the metrics status for trained model inference job.
         */
        public var metricsStatusDetails: kotlin.String? = null
        /**
         * The name of the trained model inference job.
         */
        public var name: kotlin.String? = null
        /**
         * Returns output configuration information for the trained model inference job.
         */
        public var outputConfiguration: aws.sdk.kotlin.services.cleanroomsml.model.InferenceOutputConfiguration? = null
        /**
         * The status of the trained model inference job.
         */
        public var status: aws.sdk.kotlin.services.cleanroomsml.model.TrainedModelInferenceJobStatus? = null
        /**
         * The Amazon Resource Name (ARN) of the trained model that is used for the trained model inference job.
         */
        public var trainedModelArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the trained model inference job.
         */
        public var trainedModelInferenceJobArn: kotlin.String? = null
        /**
         * The most recent time at which the trained model inference job was updated.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.CollaborationTrainedModelInferenceJobSummary) : this() {
            this.collaborationIdentifier = x.collaborationIdentifier
            this.configuredModelAlgorithmAssociationArn = x.configuredModelAlgorithmAssociationArn
            this.createTime = x.createTime
            this.creatorAccountId = x.creatorAccountId
            this.description = x.description
            this.logsStatus = x.logsStatus
            this.logsStatusDetails = x.logsStatusDetails
            this.membershipIdentifier = x.membershipIdentifier
            this.metricsStatus = x.metricsStatus
            this.metricsStatusDetails = x.metricsStatusDetails
            this.name = x.name
            this.outputConfiguration = x.outputConfiguration
            this.status = x.status
            this.trainedModelArn = x.trainedModelArn
            this.trainedModelInferenceJobArn = x.trainedModelInferenceJobArn
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.CollaborationTrainedModelInferenceJobSummary = CollaborationTrainedModelInferenceJobSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.InferenceOutputConfiguration] inside the given [block]
         */
        public fun outputConfiguration(block: aws.sdk.kotlin.services.cleanroomsml.model.InferenceOutputConfiguration.Builder.() -> kotlin.Unit) {
            this.outputConfiguration = aws.sdk.kotlin.services.cleanroomsml.model.InferenceOutputConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (collaborationIdentifier == null) collaborationIdentifier = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (creatorAccountId == null) creatorAccountId = ""
            if (membershipIdentifier == null) membershipIdentifier = ""
            if (name == null) name = ""
            if (status == null) status = TrainedModelInferenceJobStatus.SdkUnknown("no value provided")
            if (trainedModelArn == null) trainedModelArn = ""
            if (trainedModelInferenceJobArn == null) trainedModelInferenceJobArn = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
