// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides summary information about a trained model export job in a collaboration.
 */
public class CollaborationTrainedModelExportJobSummary private constructor(builder: Builder) {
    /**
     * The collaboration ID of the collaboration that contains the trained model export job.
     */
    public val collaborationIdentifier: kotlin.String = requireNotNull(builder.collaborationIdentifier) { "A non-null value must be provided for collaborationIdentifier" }
    /**
     * The time at which the trained model export job was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The account ID of the member that created the trained model.
     */
    public val creatorAccountId: kotlin.String = requireNotNull(builder.creatorAccountId) { "A non-null value must be provided for creatorAccountId" }
    /**
     * The description of the trained model.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The membership ID of the member that created the trained model export job.
     */
    public val membershipIdentifier: kotlin.String = requireNotNull(builder.membershipIdentifier) { "A non-null value must be provided for membershipIdentifier" }
    /**
     * The name of the trained model export job.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Information about the output of the trained model export job.
     */
    public val outputConfiguration: aws.sdk.kotlin.services.cleanroomsml.model.TrainedModelExportOutputConfiguration? = builder.outputConfiguration
    /**
     * The status of the trained model.
     */
    public val status: aws.sdk.kotlin.services.cleanroomsml.model.TrainedModelExportJobStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * Details about the status of a resource.
     */
    public val statusDetails: aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails? = builder.statusDetails
    /**
     * The Amazon Resource Name (ARN) of the trained model that is being exported.
     */
    public val trainedModelArn: kotlin.String = requireNotNull(builder.trainedModelArn) { "A non-null value must be provided for trainedModelArn" }
    /**
     * The most recent time at which the trained model export job was updated.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.CollaborationTrainedModelExportJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CollaborationTrainedModelExportJobSummary(")
        append("collaborationIdentifier=$collaborationIdentifier,")
        append("createTime=$createTime,")
        append("creatorAccountId=$creatorAccountId,")
        append("description=$description,")
        append("membershipIdentifier=$membershipIdentifier,")
        append("name=$name,")
        append("outputConfiguration=$outputConfiguration,")
        append("status=$status,")
        append("statusDetails=$statusDetails,")
        append("trainedModelArn=$trainedModelArn,")
        append("updateTime=$updateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = collaborationIdentifier.hashCode()
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (creatorAccountId.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (membershipIdentifier.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (outputConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusDetails?.hashCode() ?: 0)
        result = 31 * result + (trainedModelArn.hashCode())
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CollaborationTrainedModelExportJobSummary

        if (collaborationIdentifier != other.collaborationIdentifier) return false
        if (createTime != other.createTime) return false
        if (creatorAccountId != other.creatorAccountId) return false
        if (description != other.description) return false
        if (membershipIdentifier != other.membershipIdentifier) return false
        if (name != other.name) return false
        if (outputConfiguration != other.outputConfiguration) return false
        if (status != other.status) return false
        if (statusDetails != other.statusDetails) return false
        if (trainedModelArn != other.trainedModelArn) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.CollaborationTrainedModelExportJobSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The collaboration ID of the collaboration that contains the trained model export job.
         */
        public var collaborationIdentifier: kotlin.String? = null
        /**
         * The time at which the trained model export job was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The account ID of the member that created the trained model.
         */
        public var creatorAccountId: kotlin.String? = null
        /**
         * The description of the trained model.
         */
        public var description: kotlin.String? = null
        /**
         * The membership ID of the member that created the trained model export job.
         */
        public var membershipIdentifier: kotlin.String? = null
        /**
         * The name of the trained model export job.
         */
        public var name: kotlin.String? = null
        /**
         * Information about the output of the trained model export job.
         */
        public var outputConfiguration: aws.sdk.kotlin.services.cleanroomsml.model.TrainedModelExportOutputConfiguration? = null
        /**
         * The status of the trained model.
         */
        public var status: aws.sdk.kotlin.services.cleanroomsml.model.TrainedModelExportJobStatus? = null
        /**
         * Details about the status of a resource.
         */
        public var statusDetails: aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails? = null
        /**
         * The Amazon Resource Name (ARN) of the trained model that is being exported.
         */
        public var trainedModelArn: kotlin.String? = null
        /**
         * The most recent time at which the trained model export job was updated.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.CollaborationTrainedModelExportJobSummary) : this() {
            this.collaborationIdentifier = x.collaborationIdentifier
            this.createTime = x.createTime
            this.creatorAccountId = x.creatorAccountId
            this.description = x.description
            this.membershipIdentifier = x.membershipIdentifier
            this.name = x.name
            this.outputConfiguration = x.outputConfiguration
            this.status = x.status
            this.statusDetails = x.statusDetails
            this.trainedModelArn = x.trainedModelArn
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.CollaborationTrainedModelExportJobSummary = CollaborationTrainedModelExportJobSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.TrainedModelExportOutputConfiguration] inside the given [block]
         */
        public fun outputConfiguration(block: aws.sdk.kotlin.services.cleanroomsml.model.TrainedModelExportOutputConfiguration.Builder.() -> kotlin.Unit) {
            this.outputConfiguration = aws.sdk.kotlin.services.cleanroomsml.model.TrainedModelExportOutputConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails] inside the given [block]
         */
        public fun statusDetails(block: aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails.Builder.() -> kotlin.Unit) {
            this.statusDetails = aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (collaborationIdentifier == null) collaborationIdentifier = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (creatorAccountId == null) creatorAccountId = ""
            if (membershipIdentifier == null) membershipIdentifier = ""
            if (name == null) name = ""
            if (status == null) status = TrainedModelExportJobStatus.SdkUnknown("no value provided")
            if (trainedModelArn == null) trainedModelArn = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
