// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides summary information about a configured model algorithm in a collaboration.
 */
public class CollaborationConfiguredModelAlgorithmAssociationSummary private constructor(builder: Builder) {
    /**
     * The collaboration ID of the collaboration that contains the configured model algorithm association.
     */
    public val collaborationIdentifier: kotlin.String = requireNotNull(builder.collaborationIdentifier) { "A non-null value must be provided for collaborationIdentifier" }
    /**
     * The Amazon Resource Name (ARN) of the configured model algorithm that is associated to the collaboration.
     */
    public val configuredModelAlgorithmArn: kotlin.String = requireNotNull(builder.configuredModelAlgorithmArn) { "A non-null value must be provided for configuredModelAlgorithmArn" }
    /**
     * The Amazon Resource Name (ARN) of the configured model algorithm association.
     */
    public val configuredModelAlgorithmAssociationArn: kotlin.String = requireNotNull(builder.configuredModelAlgorithmAssociationArn) { "A non-null value must be provided for configuredModelAlgorithmAssociationArn" }
    /**
     * The time at which the configured model algorithm association was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The account ID of the member that created the configured model algorithm association.
     */
    public val creatorAccountId: kotlin.String = requireNotNull(builder.creatorAccountId) { "A non-null value must be provided for creatorAccountId" }
    /**
     * The description of the configured model algorithm association.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The membership ID of the member that created the configured model algorithm association.
     */
    public val membershipIdentifier: kotlin.String = requireNotNull(builder.membershipIdentifier) { "A non-null value must be provided for membershipIdentifier" }
    /**
     * The name of the configured model algorithm association.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The most recent time at which the configured model algorithm association was updated.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.CollaborationConfiguredModelAlgorithmAssociationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CollaborationConfiguredModelAlgorithmAssociationSummary(")
        append("collaborationIdentifier=$collaborationIdentifier,")
        append("configuredModelAlgorithmArn=$configuredModelAlgorithmArn,")
        append("configuredModelAlgorithmAssociationArn=$configuredModelAlgorithmAssociationArn,")
        append("createTime=$createTime,")
        append("creatorAccountId=$creatorAccountId,")
        append("description=$description,")
        append("membershipIdentifier=$membershipIdentifier,")
        append("name=$name,")
        append("updateTime=$updateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = collaborationIdentifier.hashCode()
        result = 31 * result + (configuredModelAlgorithmArn.hashCode())
        result = 31 * result + (configuredModelAlgorithmAssociationArn.hashCode())
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (creatorAccountId.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (membershipIdentifier.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CollaborationConfiguredModelAlgorithmAssociationSummary

        if (collaborationIdentifier != other.collaborationIdentifier) return false
        if (configuredModelAlgorithmArn != other.configuredModelAlgorithmArn) return false
        if (configuredModelAlgorithmAssociationArn != other.configuredModelAlgorithmAssociationArn) return false
        if (createTime != other.createTime) return false
        if (creatorAccountId != other.creatorAccountId) return false
        if (description != other.description) return false
        if (membershipIdentifier != other.membershipIdentifier) return false
        if (name != other.name) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.CollaborationConfiguredModelAlgorithmAssociationSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The collaboration ID of the collaboration that contains the configured model algorithm association.
         */
        public var collaborationIdentifier: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the configured model algorithm that is associated to the collaboration.
         */
        public var configuredModelAlgorithmArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the configured model algorithm association.
         */
        public var configuredModelAlgorithmAssociationArn: kotlin.String? = null
        /**
         * The time at which the configured model algorithm association was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The account ID of the member that created the configured model algorithm association.
         */
        public var creatorAccountId: kotlin.String? = null
        /**
         * The description of the configured model algorithm association.
         */
        public var description: kotlin.String? = null
        /**
         * The membership ID of the member that created the configured model algorithm association.
         */
        public var membershipIdentifier: kotlin.String? = null
        /**
         * The name of the configured model algorithm association.
         */
        public var name: kotlin.String? = null
        /**
         * The most recent time at which the configured model algorithm association was updated.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.CollaborationConfiguredModelAlgorithmAssociationSummary) : this() {
            this.collaborationIdentifier = x.collaborationIdentifier
            this.configuredModelAlgorithmArn = x.configuredModelAlgorithmArn
            this.configuredModelAlgorithmAssociationArn = x.configuredModelAlgorithmAssociationArn
            this.createTime = x.createTime
            this.creatorAccountId = x.creatorAccountId
            this.description = x.description
            this.membershipIdentifier = x.membershipIdentifier
            this.name = x.name
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.CollaborationConfiguredModelAlgorithmAssociationSummary = CollaborationConfiguredModelAlgorithmAssociationSummary(this)

        internal fun correctErrors(): Builder {
            if (collaborationIdentifier == null) collaborationIdentifier = ""
            if (configuredModelAlgorithmArn == null) configuredModelAlgorithmArn = ""
            if (configuredModelAlgorithmAssociationArn == null) configuredModelAlgorithmAssociationArn = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (creatorAccountId == null) creatorAccountId = ""
            if (membershipIdentifier == null) membershipIdentifier = ""
            if (name == null) name = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
