// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines the Amazon S3 bucket where the seed audience for the generating audience is stored.
 */
public class AudienceGenerationJobDataSource private constructor(builder: Builder) {
    /**
     * Defines the Amazon S3 bucket where the seed audience for the generating audience is stored. A valid data source is a JSON line file in the following format:
     *
     * `{"user_id": "111111"}`
     *
     * `{"user_id": "222222"}`
     *
     * `...`
     */
    public val dataSource: aws.sdk.kotlin.services.cleanroomsml.model.S3ConfigMap? = builder.dataSource
    /**
     * The ARN of the IAM role that can read the Amazon S3 bucket where the seed audience is stored.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * Provides configuration information for the instances that will perform the compute work.
     */
    public val sqlComputeConfiguration: aws.sdk.kotlin.services.cleanroomsml.model.ComputeConfiguration? = builder.sqlComputeConfiguration
    /**
     * The protected SQL query parameters.
     */
    public val sqlParameters: aws.sdk.kotlin.services.cleanroomsml.model.ProtectedQuerySqlParameters? = builder.sqlParameters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.AudienceGenerationJobDataSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AudienceGenerationJobDataSource(")
        append("dataSource=$dataSource,")
        append("roleArn=$roleArn,")
        append("sqlComputeConfiguration=$sqlComputeConfiguration,")
        append("sqlParameters=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSource?.hashCode() ?: 0
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (sqlComputeConfiguration?.hashCode() ?: 0)
        result = 31 * result + (sqlParameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AudienceGenerationJobDataSource

        if (dataSource != other.dataSource) return false
        if (roleArn != other.roleArn) return false
        if (sqlComputeConfiguration != other.sqlComputeConfiguration) return false
        if (sqlParameters != other.sqlParameters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.AudienceGenerationJobDataSource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Defines the Amazon S3 bucket where the seed audience for the generating audience is stored. A valid data source is a JSON line file in the following format:
         *
         * `{"user_id": "111111"}`
         *
         * `{"user_id": "222222"}`
         *
         * `...`
         */
        public var dataSource: aws.sdk.kotlin.services.cleanroomsml.model.S3ConfigMap? = null
        /**
         * The ARN of the IAM role that can read the Amazon S3 bucket where the seed audience is stored.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Provides configuration information for the instances that will perform the compute work.
         */
        public var sqlComputeConfiguration: aws.sdk.kotlin.services.cleanroomsml.model.ComputeConfiguration? = null
        /**
         * The protected SQL query parameters.
         */
        public var sqlParameters: aws.sdk.kotlin.services.cleanroomsml.model.ProtectedQuerySqlParameters? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.AudienceGenerationJobDataSource) : this() {
            this.dataSource = x.dataSource
            this.roleArn = x.roleArn
            this.sqlComputeConfiguration = x.sqlComputeConfiguration
            this.sqlParameters = x.sqlParameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.AudienceGenerationJobDataSource = AudienceGenerationJobDataSource(this)

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.S3ConfigMap] inside the given [block]
         */
        public fun dataSource(block: aws.sdk.kotlin.services.cleanroomsml.model.S3ConfigMap.Builder.() -> kotlin.Unit) {
            this.dataSource = aws.sdk.kotlin.services.cleanroomsml.model.S3ConfigMap.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.ProtectedQuerySqlParameters] inside the given [block]
         */
        public fun sqlParameters(block: aws.sdk.kotlin.services.cleanroomsml.model.ProtectedQuerySqlParameters.Builder.() -> kotlin.Unit) {
            this.sqlParameters = aws.sdk.kotlin.services.cleanroomsml.model.ProtectedQuerySqlParameters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (roleArn == null) roleArn = ""
            return this
        }
    }
}
