// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.serde

import aws.sdk.kotlin.services.cleanroomsml.model.AudienceModelStatus
import aws.sdk.kotlin.services.cleanroomsml.model.CleanRoomsMlException
import aws.sdk.kotlin.services.cleanroomsml.model.GetAudienceModelResponse
import aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableMapOf


internal class GetAudienceModelOperationDeserializer: HttpDeserializer.NonStreaming<GetAudienceModelResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetAudienceModelResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetAudienceModelError(context, call, payload)
        }
        val builder = GetAudienceModelResponse.Builder()

        if (payload != null) {
            deserializeGetAudienceModelOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetAudienceModelError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CleanRoomsMlException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CleanRoomsMlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAudienceModelOperationBody(builder: GetAudienceModelResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUDIENCEMODELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("audienceModelArn"))
    val CREATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val KMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("kmsKeyArn"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val STATUSDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("statusDetails"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TRAININGDATAENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("trainingDataEndTime"))
    val TRAININGDATASTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("trainingDataStartTime"))
    val TRAININGDATASETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("trainingDatasetArn"))
    val UPDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updateTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUDIENCEMODELARN_DESCRIPTOR)
        field(CREATETIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(KMSKEYARN_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSDETAILS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TRAININGDATAENDTIME_DESCRIPTOR)
        field(TRAININGDATASTARTTIME_DESCRIPTOR)
        field(TRAININGDATASETARN_DESCRIPTOR)
        field(UPDATETIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUDIENCEMODELARN_DESCRIPTOR.index -> builder.audienceModelArn = deserializeString()
                CREATETIME_DESCRIPTOR.index -> builder.createTime = deserializeInstant(TimestampFormat.ISO_8601)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                KMSKEYARN_DESCRIPTOR.index -> builder.kmsKeyArn = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { AudienceModelStatus.fromValue(it) }
                STATUSDETAILS_DESCRIPTOR.index -> builder.statusDetails = deserializeStatusDetailsDocument(deserializer)
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TRAININGDATAENDTIME_DESCRIPTOR.index -> builder.trainingDataEndTime = deserializeInstant(TimestampFormat.ISO_8601)
                TRAININGDATASTARTTIME_DESCRIPTOR.index -> builder.trainingDataStartTime = deserializeInstant(TimestampFormat.ISO_8601)
                TRAININGDATASETARN_DESCRIPTOR.index -> builder.trainingDatasetArn = deserializeString()
                UPDATETIME_DESCRIPTOR.index -> builder.updateTime = deserializeInstant(TimestampFormat.ISO_8601)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
