// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetAudienceGenerationJobResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the audience generation job.
     */
    public val audienceGenerationJobArn: kotlin.String = requireNotNull(builder.audienceGenerationJobArn) { "A non-null value must be provided for audienceGenerationJobArn" }
    /**
     * The identifier of the collaboration that this audience generation job is associated with.
     */
    public val collaborationId: kotlin.String? = builder.collaborationId
    /**
     * The Amazon Resource Name (ARN) of the configured audience model used for this audience generation job.
     */
    public val configuredAudienceModelArn: kotlin.String = requireNotNull(builder.configuredAudienceModelArn) { "A non-null value must be provided for configuredAudienceModelArn" }
    /**
     * The time at which the audience generation job was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The description of the audience generation job.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Configure whether the seed users are included in the output audience. By default, Clean Rooms ML removes seed users from the output audience. If you specify `TRUE`, the seed users will appear first in the output. Clean Rooms ML does not explicitly reveal whether a user was in the seed, but the recipient of the audience will know that the first `minimumSeedSize` count of users are from the seed.
     */
    public val includeSeedInOutput: kotlin.Boolean? = builder.includeSeedInOutput
    /**
     * The relevance scores for different audience sizes and the recall score of the generated audience.
     */
    public val metrics: aws.sdk.kotlin.services.cleanroomsml.model.AudienceQualityMetrics? = builder.metrics
    /**
     * The name of the audience generation job.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The unique identifier of the protected query for this audience generation job.
     */
    public val protectedQueryIdentifier: kotlin.String? = builder.protectedQueryIdentifier
    /**
     * The seed audience that was used for this audience generation job. This field will be null if the account calling the API is the account that started this audience generation job.
     */
    public val seedAudience: aws.sdk.kotlin.services.cleanroomsml.model.AudienceGenerationJobDataSource? = builder.seedAudience
    /**
     * The AWS account that started this audience generation job.
     */
    public val startedBy: kotlin.String? = builder.startedBy
    /**
     * The status of the audience generation job.
     */
    public val status: aws.sdk.kotlin.services.cleanroomsml.model.AudienceGenerationJobStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * Details about the status of the audience generation job.
     */
    public val statusDetails: aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails? = builder.statusDetails
    /**
     * The tags that are associated to this audience generation job.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The most recent time at which the audience generation job was updated.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.GetAudienceGenerationJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetAudienceGenerationJobResponse(")
        append("audienceGenerationJobArn=$audienceGenerationJobArn,")
        append("collaborationId=$collaborationId,")
        append("configuredAudienceModelArn=$configuredAudienceModelArn,")
        append("createTime=$createTime,")
        append("description=$description,")
        append("includeSeedInOutput=$includeSeedInOutput,")
        append("metrics=$metrics,")
        append("name=$name,")
        append("protectedQueryIdentifier=$protectedQueryIdentifier,")
        append("seedAudience=$seedAudience,")
        append("startedBy=$startedBy,")
        append("status=$status,")
        append("statusDetails=$statusDetails,")
        append("tags=$tags,")
        append("updateTime=$updateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = audienceGenerationJobArn.hashCode()
        result = 31 * result + (collaborationId?.hashCode() ?: 0)
        result = 31 * result + (configuredAudienceModelArn.hashCode())
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (includeSeedInOutput?.hashCode() ?: 0)
        result = 31 * result + (metrics?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (protectedQueryIdentifier?.hashCode() ?: 0)
        result = 31 * result + (seedAudience?.hashCode() ?: 0)
        result = 31 * result + (startedBy?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusDetails?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetAudienceGenerationJobResponse

        if (audienceGenerationJobArn != other.audienceGenerationJobArn) return false
        if (collaborationId != other.collaborationId) return false
        if (configuredAudienceModelArn != other.configuredAudienceModelArn) return false
        if (createTime != other.createTime) return false
        if (description != other.description) return false
        if (includeSeedInOutput != other.includeSeedInOutput) return false
        if (metrics != other.metrics) return false
        if (name != other.name) return false
        if (protectedQueryIdentifier != other.protectedQueryIdentifier) return false
        if (seedAudience != other.seedAudience) return false
        if (startedBy != other.startedBy) return false
        if (status != other.status) return false
        if (statusDetails != other.statusDetails) return false
        if (tags != other.tags) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.GetAudienceGenerationJobResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the audience generation job.
         */
        public var audienceGenerationJobArn: kotlin.String? = null
        /**
         * The identifier of the collaboration that this audience generation job is associated with.
         */
        public var collaborationId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the configured audience model used for this audience generation job.
         */
        public var configuredAudienceModelArn: kotlin.String? = null
        /**
         * The time at which the audience generation job was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the audience generation job.
         */
        public var description: kotlin.String? = null
        /**
         * Configure whether the seed users are included in the output audience. By default, Clean Rooms ML removes seed users from the output audience. If you specify `TRUE`, the seed users will appear first in the output. Clean Rooms ML does not explicitly reveal whether a user was in the seed, but the recipient of the audience will know that the first `minimumSeedSize` count of users are from the seed.
         */
        public var includeSeedInOutput: kotlin.Boolean? = null
        /**
         * The relevance scores for different audience sizes and the recall score of the generated audience.
         */
        public var metrics: aws.sdk.kotlin.services.cleanroomsml.model.AudienceQualityMetrics? = null
        /**
         * The name of the audience generation job.
         */
        public var name: kotlin.String? = null
        /**
         * The unique identifier of the protected query for this audience generation job.
         */
        public var protectedQueryIdentifier: kotlin.String? = null
        /**
         * The seed audience that was used for this audience generation job. This field will be null if the account calling the API is the account that started this audience generation job.
         */
        public var seedAudience: aws.sdk.kotlin.services.cleanroomsml.model.AudienceGenerationJobDataSource? = null
        /**
         * The AWS account that started this audience generation job.
         */
        public var startedBy: kotlin.String? = null
        /**
         * The status of the audience generation job.
         */
        public var status: aws.sdk.kotlin.services.cleanroomsml.model.AudienceGenerationJobStatus? = null
        /**
         * Details about the status of the audience generation job.
         */
        public var statusDetails: aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails? = null
        /**
         * The tags that are associated to this audience generation job.
         */
        public var tags: Map<String, String>? = null
        /**
         * The most recent time at which the audience generation job was updated.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.GetAudienceGenerationJobResponse) : this() {
            this.audienceGenerationJobArn = x.audienceGenerationJobArn
            this.collaborationId = x.collaborationId
            this.configuredAudienceModelArn = x.configuredAudienceModelArn
            this.createTime = x.createTime
            this.description = x.description
            this.includeSeedInOutput = x.includeSeedInOutput
            this.metrics = x.metrics
            this.name = x.name
            this.protectedQueryIdentifier = x.protectedQueryIdentifier
            this.seedAudience = x.seedAudience
            this.startedBy = x.startedBy
            this.status = x.status
            this.statusDetails = x.statusDetails
            this.tags = x.tags
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.GetAudienceGenerationJobResponse = GetAudienceGenerationJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.AudienceQualityMetrics] inside the given [block]
         */
        public fun metrics(block: aws.sdk.kotlin.services.cleanroomsml.model.AudienceQualityMetrics.Builder.() -> kotlin.Unit) {
            this.metrics = aws.sdk.kotlin.services.cleanroomsml.model.AudienceQualityMetrics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.AudienceGenerationJobDataSource] inside the given [block]
         */
        public fun seedAudience(block: aws.sdk.kotlin.services.cleanroomsml.model.AudienceGenerationJobDataSource.Builder.() -> kotlin.Unit) {
            this.seedAudience = aws.sdk.kotlin.services.cleanroomsml.model.AudienceGenerationJobDataSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails] inside the given [block]
         */
        public fun statusDetails(block: aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails.Builder.() -> kotlin.Unit) {
            this.statusDetails = aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (audienceGenerationJobArn == null) audienceGenerationJobArn = ""
            if (configuredAudienceModelArn == null) configuredAudienceModelArn = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            if (status == null) status = AudienceGenerationJobStatus.SdkUnknown("no value provided")
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
