// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateConfiguredAudienceModelRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the audience model to use for the configured audience model.
     */
    public val audienceModelArn: kotlin.String? = builder.audienceModelArn
    /**
     * Configure the list of output sizes of audiences that can be created using this configured audience model. A request to StartAudienceGenerationJob that uses this configured audience model must have an `audienceSize` selected from this list. You can use the `ABSOLUTE`AudienceSize to configure out audience sizes using the count of identifiers in the output. You can use the `Percentage`AudienceSize to configure sizes in the range 1-100 percent.
     */
    public val audienceSizeConfig: aws.sdk.kotlin.services.cleanroomsml.model.AudienceSizeConfig? = builder.audienceSizeConfig
    /**
     * Configure how the service tags audience generation jobs created using this configured audience model. If you specify `NONE`, the tags from the StartAudienceGenerationJob request determine the tags of the audience generation job. If you specify `FROM_PARENT_RESOURCE`, the audience generation job inherits the tags from the configured audience model, by default. Tags in the StartAudienceGenerationJob will override the default.
     *
     * When the client is in a different account than the configured audience model, the tags from the client are never applied to a resource in the caller's account.
     */
    public val childResourceTagOnCreatePolicy: aws.sdk.kotlin.services.cleanroomsml.model.TagOnCreatePolicy? = builder.childResourceTagOnCreatePolicy
    /**
     * The description of the configured audience model.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The minimum number of users from the seed audience that must match with users in the training data of the audience model. The default value is 500.
     */
    public val minMatchingSeedSize: kotlin.Int? = builder.minMatchingSeedSize
    /**
     * The name of the configured audience model.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Configure the Amazon S3 location and IAM Role for audiences created using this configured audience model. Each audience will have a unique location. The IAM Role must have `s3:PutObject` permission on the destination Amazon S3 location. If the destination is protected with Amazon S3 KMS-SSE, then the Role must also have the required KMS permissions.
     */
    public val outputConfig: aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredAudienceModelOutputConfig? = builder.outputConfig
    /**
     * Whether audience metrics are shared.
     */
    public val sharedAudienceMetrics: List<SharedAudienceMetrics>? = builder.sharedAudienceMetrics
    /**
     * The optional metadata that you apply to the resource to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
     *
     * The following basic restrictions apply to tags:
     * + Maximum number of tags per resource - 50.
     * + For each resource, each tag key must be unique, and each tag key can have only one value.
     * + Maximum key length - 128 Unicode characters in UTF-8.
     * + Maximum value length - 256 Unicode characters in UTF-8.
     * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
     * + Tag keys and values are case sensitive.
     * + Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.CreateConfiguredAudienceModelRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateConfiguredAudienceModelRequest(")
        append("audienceModelArn=$audienceModelArn,")
        append("audienceSizeConfig=$audienceSizeConfig,")
        append("childResourceTagOnCreatePolicy=$childResourceTagOnCreatePolicy,")
        append("description=$description,")
        append("minMatchingSeedSize=$minMatchingSeedSize,")
        append("name=$name,")
        append("outputConfig=$outputConfig,")
        append("sharedAudienceMetrics=$sharedAudienceMetrics,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = audienceModelArn?.hashCode() ?: 0
        result = 31 * result + (audienceSizeConfig?.hashCode() ?: 0)
        result = 31 * result + (childResourceTagOnCreatePolicy?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (minMatchingSeedSize ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outputConfig?.hashCode() ?: 0)
        result = 31 * result + (sharedAudienceMetrics?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateConfiguredAudienceModelRequest

        if (audienceModelArn != other.audienceModelArn) return false
        if (audienceSizeConfig != other.audienceSizeConfig) return false
        if (childResourceTagOnCreatePolicy != other.childResourceTagOnCreatePolicy) return false
        if (description != other.description) return false
        if (minMatchingSeedSize != other.minMatchingSeedSize) return false
        if (name != other.name) return false
        if (outputConfig != other.outputConfig) return false
        if (sharedAudienceMetrics != other.sharedAudienceMetrics) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.CreateConfiguredAudienceModelRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the audience model to use for the configured audience model.
         */
        public var audienceModelArn: kotlin.String? = null
        /**
         * Configure the list of output sizes of audiences that can be created using this configured audience model. A request to StartAudienceGenerationJob that uses this configured audience model must have an `audienceSize` selected from this list. You can use the `ABSOLUTE`AudienceSize to configure out audience sizes using the count of identifiers in the output. You can use the `Percentage`AudienceSize to configure sizes in the range 1-100 percent.
         */
        public var audienceSizeConfig: aws.sdk.kotlin.services.cleanroomsml.model.AudienceSizeConfig? = null
        /**
         * Configure how the service tags audience generation jobs created using this configured audience model. If you specify `NONE`, the tags from the StartAudienceGenerationJob request determine the tags of the audience generation job. If you specify `FROM_PARENT_RESOURCE`, the audience generation job inherits the tags from the configured audience model, by default. Tags in the StartAudienceGenerationJob will override the default.
         *
         * When the client is in a different account than the configured audience model, the tags from the client are never applied to a resource in the caller's account.
         */
        public var childResourceTagOnCreatePolicy: aws.sdk.kotlin.services.cleanroomsml.model.TagOnCreatePolicy? = null
        /**
         * The description of the configured audience model.
         */
        public var description: kotlin.String? = null
        /**
         * The minimum number of users from the seed audience that must match with users in the training data of the audience model. The default value is 500.
         */
        public var minMatchingSeedSize: kotlin.Int? = null
        /**
         * The name of the configured audience model.
         */
        public var name: kotlin.String? = null
        /**
         * Configure the Amazon S3 location and IAM Role for audiences created using this configured audience model. Each audience will have a unique location. The IAM Role must have `s3:PutObject` permission on the destination Amazon S3 location. If the destination is protected with Amazon S3 KMS-SSE, then the Role must also have the required KMS permissions.
         */
        public var outputConfig: aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredAudienceModelOutputConfig? = null
        /**
         * Whether audience metrics are shared.
         */
        public var sharedAudienceMetrics: List<SharedAudienceMetrics>? = null
        /**
         * The optional metadata that you apply to the resource to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
         *
         * The following basic restrictions apply to tags:
         * + Maximum number of tags per resource - 50.
         * + For each resource, each tag key must be unique, and each tag key can have only one value.
         * + Maximum key length - 128 Unicode characters in UTF-8.
         * + Maximum value length - 256 Unicode characters in UTF-8.
         * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         * + Tag keys and values are case sensitive.
         * + Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.CreateConfiguredAudienceModelRequest) : this() {
            this.audienceModelArn = x.audienceModelArn
            this.audienceSizeConfig = x.audienceSizeConfig
            this.childResourceTagOnCreatePolicy = x.childResourceTagOnCreatePolicy
            this.description = x.description
            this.minMatchingSeedSize = x.minMatchingSeedSize
            this.name = x.name
            this.outputConfig = x.outputConfig
            this.sharedAudienceMetrics = x.sharedAudienceMetrics
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.CreateConfiguredAudienceModelRequest = CreateConfiguredAudienceModelRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.AudienceSizeConfig] inside the given [block]
         */
        public fun audienceSizeConfig(block: aws.sdk.kotlin.services.cleanroomsml.model.AudienceSizeConfig.Builder.() -> kotlin.Unit) {
            this.audienceSizeConfig = aws.sdk.kotlin.services.cleanroomsml.model.AudienceSizeConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredAudienceModelOutputConfig] inside the given [block]
         */
        public fun outputConfig(block: aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredAudienceModelOutputConfig.Builder.() -> kotlin.Unit) {
            this.outputConfig = aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredAudienceModelOutputConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
