// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.serde

import aws.sdk.kotlin.services.cleanroomsml.model.AudienceGenerationJobDataSource
import aws.sdk.kotlin.services.cleanroomsml.model.AudienceGenerationJobStatus
import aws.sdk.kotlin.services.cleanroomsml.model.AudienceQualityMetrics
import aws.sdk.kotlin.services.cleanroomsml.model.CleanRoomsMlException
import aws.sdk.kotlin.services.cleanroomsml.model.GetAudienceGenerationJobResponse
import aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableMapOf


internal class GetAudienceGenerationJobOperationDeserializer: HttpDeserializer.NonStreaming<GetAudienceGenerationJobResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetAudienceGenerationJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetAudienceGenerationJobError(context, call, payload)
        }
        val builder = GetAudienceGenerationJobResponse.Builder()

        if (payload != null) {
            deserializeGetAudienceGenerationJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetAudienceGenerationJobError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CleanRoomsMlException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CleanRoomsMlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAudienceGenerationJobOperationBody(builder: GetAudienceGenerationJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUDIENCEGENERATIONJOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("audienceGenerationJobArn"))
    val COLLABORATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("collaborationId"))
    val CONFIGUREDAUDIENCEMODELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("configuredAudienceModelArn"))
    val CREATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val INCLUDESEEDINOUTPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("includeSeedInOutput"))
    val METRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("metrics"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val SEEDAUDIENCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("seedAudience"))
    val STARTEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("startedBy"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val STATUSDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("statusDetails"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val UPDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updateTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUDIENCEGENERATIONJOBARN_DESCRIPTOR)
        field(COLLABORATIONID_DESCRIPTOR)
        field(CONFIGUREDAUDIENCEMODELARN_DESCRIPTOR)
        field(CREATETIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(INCLUDESEEDINOUTPUT_DESCRIPTOR)
        field(METRICS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(SEEDAUDIENCE_DESCRIPTOR)
        field(STARTEDBY_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSDETAILS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(UPDATETIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUDIENCEGENERATIONJOBARN_DESCRIPTOR.index -> builder.audienceGenerationJobArn = deserializeString()
                COLLABORATIONID_DESCRIPTOR.index -> builder.collaborationId = deserializeString()
                CONFIGUREDAUDIENCEMODELARN_DESCRIPTOR.index -> builder.configuredAudienceModelArn = deserializeString()
                CREATETIME_DESCRIPTOR.index -> builder.createTime = deserializeString().let { Instant.fromIso8601(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                INCLUDESEEDINOUTPUT_DESCRIPTOR.index -> builder.includeSeedInOutput = deserializeBoolean()
                METRICS_DESCRIPTOR.index -> builder.metrics = deserializeAudienceQualityMetricsDocument(deserializer)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                SEEDAUDIENCE_DESCRIPTOR.index -> builder.seedAudience = deserializeAudienceGenerationJobDataSourceDocument(deserializer)
                STARTEDBY_DESCRIPTOR.index -> builder.startedBy = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { AudienceGenerationJobStatus.fromValue(it) }
                STATUSDETAILS_DESCRIPTOR.index -> builder.statusDetails = deserializeStatusDetailsDocument(deserializer)
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                UPDATETIME_DESCRIPTOR.index -> builder.updateTime = deserializeString().let { Instant.fromIso8601(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
