// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetAudienceModelResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the audience model.
     */
    public val audienceModelArn: kotlin.String = requireNotNull(builder.audienceModelArn) { "A non-null value must be provided for audienceModelArn" }
    /**
     * The time at which the audience model was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The description of the audience model.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The KMS key ARN used for the audience model.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The name of the audience model.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The status of the audience model.
     */
    public val status: aws.sdk.kotlin.services.cleanroomsml.model.AudienceModelStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * Details about the status of the audience model.
     */
    public val statusDetails: aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails? = builder.statusDetails
    /**
     * The tags that are assigned to the audience model.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The end date specified for the training window.
     */
    public val trainingDataEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.trainingDataEndTime
    /**
     * The start date specified for the training window.
     */
    public val trainingDataStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.trainingDataStartTime
    /**
     * The Amazon Resource Name (ARN) of the training dataset that was used for this audience model.
     */
    public val trainingDatasetArn: kotlin.String = requireNotNull(builder.trainingDatasetArn) { "A non-null value must be provided for trainingDatasetArn" }
    /**
     * The most recent time at which the audience model was updated.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.GetAudienceModelResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetAudienceModelResponse(")
        append("audienceModelArn=$audienceModelArn,")
        append("createTime=$createTime,")
        append("description=$description,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("name=$name,")
        append("status=$status,")
        append("statusDetails=$statusDetails,")
        append("tags=$tags,")
        append("trainingDataEndTime=$trainingDataEndTime,")
        append("trainingDataStartTime=$trainingDataStartTime,")
        append("trainingDatasetArn=$trainingDatasetArn,")
        append("updateTime=$updateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = audienceModelArn.hashCode()
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusDetails?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (trainingDataEndTime?.hashCode() ?: 0)
        result = 31 * result + (trainingDataStartTime?.hashCode() ?: 0)
        result = 31 * result + (trainingDatasetArn.hashCode())
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetAudienceModelResponse

        if (audienceModelArn != other.audienceModelArn) return false
        if (createTime != other.createTime) return false
        if (description != other.description) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (statusDetails != other.statusDetails) return false
        if (tags != other.tags) return false
        if (trainingDataEndTime != other.trainingDataEndTime) return false
        if (trainingDataStartTime != other.trainingDataStartTime) return false
        if (trainingDatasetArn != other.trainingDatasetArn) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.GetAudienceModelResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the audience model.
         */
        public var audienceModelArn: kotlin.String? = null
        /**
         * The time at which the audience model was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the audience model.
         */
        public var description: kotlin.String? = null
        /**
         * The KMS key ARN used for the audience model.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The name of the audience model.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the audience model.
         */
        public var status: aws.sdk.kotlin.services.cleanroomsml.model.AudienceModelStatus? = null
        /**
         * Details about the status of the audience model.
         */
        public var statusDetails: aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails? = null
        /**
         * The tags that are assigned to the audience model.
         */
        public var tags: Map<String, String>? = null
        /**
         * The end date specified for the training window.
         */
        public var trainingDataEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The start date specified for the training window.
         */
        public var trainingDataStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the training dataset that was used for this audience model.
         */
        public var trainingDatasetArn: kotlin.String? = null
        /**
         * The most recent time at which the audience model was updated.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.GetAudienceModelResponse) : this() {
            this.audienceModelArn = x.audienceModelArn
            this.createTime = x.createTime
            this.description = x.description
            this.kmsKeyArn = x.kmsKeyArn
            this.name = x.name
            this.status = x.status
            this.statusDetails = x.statusDetails
            this.tags = x.tags
            this.trainingDataEndTime = x.trainingDataEndTime
            this.trainingDataStartTime = x.trainingDataStartTime
            this.trainingDatasetArn = x.trainingDatasetArn
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.GetAudienceModelResponse = GetAudienceModelResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails] inside the given [block]
         */
        public fun statusDetails(block: aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails.Builder.() -> kotlin.Unit) {
            this.statusDetails = aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (audienceModelArn == null) audienceModelArn = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            if (status == null) status = AudienceModelStatus.SdkUnknown("no value provided")
            if (trainingDatasetArn == null) trainingDatasetArn = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
