// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.serde

import aws.sdk.kotlin.services.cleanroomsml.model.AudienceSizeConfig
import aws.sdk.kotlin.services.cleanroomsml.model.CleanRoomsMlException
import aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredAudienceModelOutputConfig
import aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredAudienceModelStatus
import aws.sdk.kotlin.services.cleanroomsml.model.GetConfiguredAudienceModelResponse
import aws.sdk.kotlin.services.cleanroomsml.model.SharedAudienceMetrics
import aws.sdk.kotlin.services.cleanroomsml.model.TagOnCreatePolicy
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetConfiguredAudienceModelOperationDeserializer: HttpDeserializer.NonStreaming<GetConfiguredAudienceModelResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetConfiguredAudienceModelResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetConfiguredAudienceModelError(context, call, payload)
        }
        val builder = GetConfiguredAudienceModelResponse.Builder()

        if (payload != null) {
            deserializeGetConfiguredAudienceModelOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetConfiguredAudienceModelError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CleanRoomsMlException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CleanRoomsMlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetConfiguredAudienceModelOperationBody(builder: GetConfiguredAudienceModelResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUDIENCEMODELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("audienceModelArn"))
    val AUDIENCESIZECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("audienceSizeConfig"))
    val CHILDRESOURCETAGONCREATEPOLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("childResourceTagOnCreatePolicy"))
    val CONFIGUREDAUDIENCEMODELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("configuredAudienceModelArn"))
    val CREATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val MINMATCHINGSEEDSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("minMatchingSeedSize"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val OUTPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("outputConfig"))
    val SHAREDAUDIENCEMETRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("sharedAudienceMetrics"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val UPDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updateTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUDIENCEMODELARN_DESCRIPTOR)
        field(AUDIENCESIZECONFIG_DESCRIPTOR)
        field(CHILDRESOURCETAGONCREATEPOLICY_DESCRIPTOR)
        field(CONFIGUREDAUDIENCEMODELARN_DESCRIPTOR)
        field(CREATETIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(MINMATCHINGSEEDSIZE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OUTPUTCONFIG_DESCRIPTOR)
        field(SHAREDAUDIENCEMETRICS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(UPDATETIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUDIENCEMODELARN_DESCRIPTOR.index -> builder.audienceModelArn = deserializeString()
                AUDIENCESIZECONFIG_DESCRIPTOR.index -> builder.audienceSizeConfig = deserializeAudienceSizeConfigDocument(deserializer)
                CHILDRESOURCETAGONCREATEPOLICY_DESCRIPTOR.index -> builder.childResourceTagOnCreatePolicy = deserializeString().let { TagOnCreatePolicy.fromValue(it) }
                CONFIGUREDAUDIENCEMODELARN_DESCRIPTOR.index -> builder.configuredAudienceModelArn = deserializeString()
                CREATETIME_DESCRIPTOR.index -> builder.createTime = deserializeString().let { Instant.fromIso8601(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                MINMATCHINGSEEDSIZE_DESCRIPTOR.index -> builder.minMatchingSeedSize = deserializeInt()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                OUTPUTCONFIG_DESCRIPTOR.index -> builder.outputConfig = deserializeConfiguredAudienceModelOutputConfigDocument(deserializer)
                SHAREDAUDIENCEMETRICS_DESCRIPTOR.index -> builder.sharedAudienceMetrics =
                    deserializer.deserializeList(SHAREDAUDIENCEMETRICS_DESCRIPTOR) {
                        val col0 = mutableListOf<SharedAudienceMetrics>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { SharedAudienceMetrics.fromValue(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ConfiguredAudienceModelStatus.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                UPDATETIME_DESCRIPTOR.index -> builder.updateTime = deserializeString().let { Instant.fromIso8601(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
