// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.paginators

import aws.sdk.kotlin.services.cleanroomsml.CleanRoomsMlClient
import aws.sdk.kotlin.services.cleanroomsml.model.AudienceExportJobSummary
import aws.sdk.kotlin.services.cleanroomsml.model.AudienceGenerationJobSummary
import aws.sdk.kotlin.services.cleanroomsml.model.AudienceModelSummary
import aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredAudienceModelSummary
import aws.sdk.kotlin.services.cleanroomsml.model.ListAudienceExportJobsRequest
import aws.sdk.kotlin.services.cleanroomsml.model.ListAudienceExportJobsResponse
import aws.sdk.kotlin.services.cleanroomsml.model.ListAudienceGenerationJobsRequest
import aws.sdk.kotlin.services.cleanroomsml.model.ListAudienceGenerationJobsResponse
import aws.sdk.kotlin.services.cleanroomsml.model.ListAudienceModelsRequest
import aws.sdk.kotlin.services.cleanroomsml.model.ListAudienceModelsResponse
import aws.sdk.kotlin.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest
import aws.sdk.kotlin.services.cleanroomsml.model.ListConfiguredAudienceModelsResponse
import aws.sdk.kotlin.services.cleanroomsml.model.ListTrainingDatasetsRequest
import aws.sdk.kotlin.services.cleanroomsml.model.ListTrainingDatasetsResponse
import aws.sdk.kotlin.services.cleanroomsml.model.TrainingDatasetSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAudienceExportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAudienceExportJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAudienceExportJobsResponse]
 */
public fun CleanRoomsMlClient.listAudienceExportJobsPaginated(initialRequest: ListAudienceExportJobsRequest = ListAudienceExportJobsRequest { }): Flow<ListAudienceExportJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAudienceExportJobsPaginated.listAudienceExportJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAudienceExportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAudienceExportJobsResponse]
 */
public fun CleanRoomsMlClient.listAudienceExportJobsPaginated(block: ListAudienceExportJobsRequest.Builder.() -> Unit): Flow<ListAudienceExportJobsResponse> =
    listAudienceExportJobsPaginated(ListAudienceExportJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAudienceExportJobsPaginated]
 * to access the nested member [AudienceExportJobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AudienceExportJobSummary]
 */
@JvmName("listAudienceExportJobsResponseAudienceExportJobSummary")
public fun Flow<ListAudienceExportJobsResponse>.audienceExportJobs(): Flow<AudienceExportJobSummary> =
    transform() { response ->
        response.audienceExportJobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAudienceGenerationJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAudienceGenerationJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAudienceGenerationJobsResponse]
 */
public fun CleanRoomsMlClient.listAudienceGenerationJobsPaginated(initialRequest: ListAudienceGenerationJobsRequest = ListAudienceGenerationJobsRequest { }): Flow<ListAudienceGenerationJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAudienceGenerationJobsPaginated.listAudienceGenerationJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAudienceGenerationJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAudienceGenerationJobsResponse]
 */
public fun CleanRoomsMlClient.listAudienceGenerationJobsPaginated(block: ListAudienceGenerationJobsRequest.Builder.() -> Unit): Flow<ListAudienceGenerationJobsResponse> =
    listAudienceGenerationJobsPaginated(ListAudienceGenerationJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAudienceGenerationJobsPaginated]
 * to access the nested member [AudienceGenerationJobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AudienceGenerationJobSummary]
 */
@JvmName("listAudienceGenerationJobsResponseAudienceGenerationJobSummary")
public fun Flow<ListAudienceGenerationJobsResponse>.audienceGenerationJobs(): Flow<AudienceGenerationJobSummary> =
    transform() { response ->
        response.audienceGenerationJobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAudienceModelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAudienceModelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAudienceModelsResponse]
 */
public fun CleanRoomsMlClient.listAudienceModelsPaginated(initialRequest: ListAudienceModelsRequest = ListAudienceModelsRequest { }): Flow<ListAudienceModelsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAudienceModelsPaginated.listAudienceModels(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAudienceModelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAudienceModelsResponse]
 */
public fun CleanRoomsMlClient.listAudienceModelsPaginated(block: ListAudienceModelsRequest.Builder.() -> Unit): Flow<ListAudienceModelsResponse> =
    listAudienceModelsPaginated(ListAudienceModelsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAudienceModelsPaginated]
 * to access the nested member [AudienceModelSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AudienceModelSummary]
 */
@JvmName("listAudienceModelsResponseAudienceModelSummary")
public fun Flow<ListAudienceModelsResponse>.audienceModels(): Flow<AudienceModelSummary> =
    transform() { response ->
        response.audienceModels?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListConfiguredAudienceModelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListConfiguredAudienceModelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConfiguredAudienceModelsResponse]
 */
public fun CleanRoomsMlClient.listConfiguredAudienceModelsPaginated(initialRequest: ListConfiguredAudienceModelsRequest = ListConfiguredAudienceModelsRequest { }): Flow<ListConfiguredAudienceModelsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listConfiguredAudienceModelsPaginated.listConfiguredAudienceModels(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListConfiguredAudienceModelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConfiguredAudienceModelsResponse]
 */
public fun CleanRoomsMlClient.listConfiguredAudienceModelsPaginated(block: ListConfiguredAudienceModelsRequest.Builder.() -> Unit): Flow<ListConfiguredAudienceModelsResponse> =
    listConfiguredAudienceModelsPaginated(ListConfiguredAudienceModelsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listConfiguredAudienceModelsPaginated]
 * to access the nested member [ConfiguredAudienceModelSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ConfiguredAudienceModelSummary]
 */
@JvmName("listConfiguredAudienceModelsResponseConfiguredAudienceModelSummary")
public fun Flow<ListConfiguredAudienceModelsResponse>.configuredAudienceModels(): Flow<ConfiguredAudienceModelSummary> =
    transform() { response ->
        response.configuredAudienceModels?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTrainingDatasetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTrainingDatasetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTrainingDatasetsResponse]
 */
public fun CleanRoomsMlClient.listTrainingDatasetsPaginated(initialRequest: ListTrainingDatasetsRequest = ListTrainingDatasetsRequest { }): Flow<ListTrainingDatasetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTrainingDatasetsPaginated.listTrainingDatasets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTrainingDatasetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTrainingDatasetsResponse]
 */
public fun CleanRoomsMlClient.listTrainingDatasetsPaginated(block: ListTrainingDatasetsRequest.Builder.() -> Unit): Flow<ListTrainingDatasetsResponse> =
    listTrainingDatasetsPaginated(ListTrainingDatasetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTrainingDatasetsPaginated]
 * to access the nested member [TrainingDatasetSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TrainingDatasetSummary]
 */
@JvmName("listTrainingDatasetsResponseTrainingDatasetSummary")
public fun Flow<ListTrainingDatasetsResponse>.trainingDatasets(): Flow<TrainingDatasetSummary> =
    transform() { response ->
        response.trainingDatasets?.forEach {
            emit(it)
        }
    }
