// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetConfiguredAudienceModelResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the audience model used for this configured audience model.
     */
    public val audienceModelArn: kotlin.String = requireNotNull(builder.audienceModelArn) { "A non-null value must be provided for audienceModelArn" }
    /**
     * The list of output sizes of audiences that can be created using this configured audience model. A request to StartAudienceGenerationJob that uses this configured audience model must have an `audienceSize` selected from this list. You can use the `ABSOLUTE`AudienceSize to configure out audience sizes using the count of identifiers in the output. You can use the `Percentage`AudienceSize to configure sizes in the range 1-100 percent.
     */
    public val audienceSizeConfig: aws.sdk.kotlin.services.cleanroomsml.model.AudienceSizeConfig? = builder.audienceSizeConfig
    /**
     * Provides the `childResourceTagOnCreatePolicy` that was used for this configured audience model.
     */
    public val childResourceTagOnCreatePolicy: aws.sdk.kotlin.services.cleanroomsml.model.TagOnCreatePolicy? = builder.childResourceTagOnCreatePolicy
    /**
     * The Amazon Resource Name (ARN) of the configured audience model.
     */
    public val configuredAudienceModelArn: kotlin.String = requireNotNull(builder.configuredAudienceModelArn) { "A non-null value must be provided for configuredAudienceModelArn" }
    /**
     * The time at which the configured audience model was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The description of the configured audience model.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The minimum number of users from the seed audience that must match with users in the training data of the audience model.
     */
    public val minMatchingSeedSize: kotlin.Int? = builder.minMatchingSeedSize
    /**
     * The name of the configured audience model.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The output configuration of the configured audience model
     */
    public val outputConfig: aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredAudienceModelOutputConfig? = builder.outputConfig
    /**
     * Whether audience metrics are shared.
     */
    public val sharedAudienceMetrics: List<SharedAudienceMetrics> = requireNotNull(builder.sharedAudienceMetrics) { "A non-null value must be provided for sharedAudienceMetrics" }
    /**
     * The status of the configured audience model.
     */
    public val status: aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredAudienceModelStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The tags that are associated to this configured audience model.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The most recent time at which the configured audience model was updated.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.GetConfiguredAudienceModelResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetConfiguredAudienceModelResponse(")
        append("audienceModelArn=$audienceModelArn,")
        append("audienceSizeConfig=$audienceSizeConfig,")
        append("childResourceTagOnCreatePolicy=$childResourceTagOnCreatePolicy,")
        append("configuredAudienceModelArn=$configuredAudienceModelArn,")
        append("createTime=$createTime,")
        append("description=$description,")
        append("minMatchingSeedSize=$minMatchingSeedSize,")
        append("name=$name,")
        append("outputConfig=$outputConfig,")
        append("sharedAudienceMetrics=$sharedAudienceMetrics,")
        append("status=$status,")
        append("tags=$tags,")
        append("updateTime=$updateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = audienceModelArn.hashCode()
        result = 31 * result + (audienceSizeConfig?.hashCode() ?: 0)
        result = 31 * result + (childResourceTagOnCreatePolicy?.hashCode() ?: 0)
        result = 31 * result + (configuredAudienceModelArn.hashCode())
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (minMatchingSeedSize ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (outputConfig?.hashCode() ?: 0)
        result = 31 * result + (sharedAudienceMetrics.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetConfiguredAudienceModelResponse

        if (audienceModelArn != other.audienceModelArn) return false
        if (audienceSizeConfig != other.audienceSizeConfig) return false
        if (childResourceTagOnCreatePolicy != other.childResourceTagOnCreatePolicy) return false
        if (configuredAudienceModelArn != other.configuredAudienceModelArn) return false
        if (createTime != other.createTime) return false
        if (description != other.description) return false
        if (minMatchingSeedSize != other.minMatchingSeedSize) return false
        if (name != other.name) return false
        if (outputConfig != other.outputConfig) return false
        if (sharedAudienceMetrics != other.sharedAudienceMetrics) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.GetConfiguredAudienceModelResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the audience model used for this configured audience model.
         */
        public var audienceModelArn: kotlin.String? = null
        /**
         * The list of output sizes of audiences that can be created using this configured audience model. A request to StartAudienceGenerationJob that uses this configured audience model must have an `audienceSize` selected from this list. You can use the `ABSOLUTE`AudienceSize to configure out audience sizes using the count of identifiers in the output. You can use the `Percentage`AudienceSize to configure sizes in the range 1-100 percent.
         */
        public var audienceSizeConfig: aws.sdk.kotlin.services.cleanroomsml.model.AudienceSizeConfig? = null
        /**
         * Provides the `childResourceTagOnCreatePolicy` that was used for this configured audience model.
         */
        public var childResourceTagOnCreatePolicy: aws.sdk.kotlin.services.cleanroomsml.model.TagOnCreatePolicy? = null
        /**
         * The Amazon Resource Name (ARN) of the configured audience model.
         */
        public var configuredAudienceModelArn: kotlin.String? = null
        /**
         * The time at which the configured audience model was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the configured audience model.
         */
        public var description: kotlin.String? = null
        /**
         * The minimum number of users from the seed audience that must match with users in the training data of the audience model.
         */
        public var minMatchingSeedSize: kotlin.Int? = null
        /**
         * The name of the configured audience model.
         */
        public var name: kotlin.String? = null
        /**
         * The output configuration of the configured audience model
         */
        public var outputConfig: aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredAudienceModelOutputConfig? = null
        /**
         * Whether audience metrics are shared.
         */
        public var sharedAudienceMetrics: List<SharedAudienceMetrics>? = null
        /**
         * The status of the configured audience model.
         */
        public var status: aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredAudienceModelStatus? = null
        /**
         * The tags that are associated to this configured audience model.
         */
        public var tags: Map<String, String>? = null
        /**
         * The most recent time at which the configured audience model was updated.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.GetConfiguredAudienceModelResponse) : this() {
            this.audienceModelArn = x.audienceModelArn
            this.audienceSizeConfig = x.audienceSizeConfig
            this.childResourceTagOnCreatePolicy = x.childResourceTagOnCreatePolicy
            this.configuredAudienceModelArn = x.configuredAudienceModelArn
            this.createTime = x.createTime
            this.description = x.description
            this.minMatchingSeedSize = x.minMatchingSeedSize
            this.name = x.name
            this.outputConfig = x.outputConfig
            this.sharedAudienceMetrics = x.sharedAudienceMetrics
            this.status = x.status
            this.tags = x.tags
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.GetConfiguredAudienceModelResponse = GetConfiguredAudienceModelResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.AudienceSizeConfig] inside the given [block]
         */
        public fun audienceSizeConfig(block: aws.sdk.kotlin.services.cleanroomsml.model.AudienceSizeConfig.Builder.() -> kotlin.Unit) {
            this.audienceSizeConfig = aws.sdk.kotlin.services.cleanroomsml.model.AudienceSizeConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredAudienceModelOutputConfig] inside the given [block]
         */
        public fun outputConfig(block: aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredAudienceModelOutputConfig.Builder.() -> kotlin.Unit) {
            this.outputConfig = aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredAudienceModelOutputConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (audienceModelArn == null) audienceModelArn = ""
            if (configuredAudienceModelArn == null) configuredAudienceModelArn = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            if (sharedAudienceMetrics == null) sharedAudienceMetrics = emptyList()
            if (status == null) status = ConfiguredAudienceModelStatus.SdkUnknown("no value provided")
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
