// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about the configured audience generation job.
 */
public class AudienceGenerationJobSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the audience generation job.
     */
    public val audienceGenerationJobArn: kotlin.String = requireNotNull(builder.audienceGenerationJobArn) { "A non-null value must be provided for audienceGenerationJobArn" }
    /**
     * The identifier of the collaboration that contains this audience generation job.
     */
    public val collaborationId: kotlin.String? = builder.collaborationId
    /**
     * The Amazon Resource Name (ARN) of the configured audience model that was used for this audience generation job.
     */
    public val configuredAudienceModelArn: kotlin.String = requireNotNull(builder.configuredAudienceModelArn) { "A non-null value must be provided for configuredAudienceModelArn" }
    /**
     * The time at which the audience generation job was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The description of the audience generation job.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the audience generation job.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The AWS Account that submitted the job.
     */
    public val startedBy: kotlin.String? = builder.startedBy
    /**
     * The status of the audience generation job.
     */
    public val status: aws.sdk.kotlin.services.cleanroomsml.model.AudienceGenerationJobStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The most recent time at which the audience generation job was updated.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.AudienceGenerationJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AudienceGenerationJobSummary(")
        append("audienceGenerationJobArn=$audienceGenerationJobArn,")
        append("collaborationId=$collaborationId,")
        append("configuredAudienceModelArn=$configuredAudienceModelArn,")
        append("createTime=$createTime,")
        append("description=$description,")
        append("name=$name,")
        append("startedBy=$startedBy,")
        append("status=$status,")
        append("updateTime=$updateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = audienceGenerationJobArn.hashCode()
        result = 31 * result + (collaborationId?.hashCode() ?: 0)
        result = 31 * result + (configuredAudienceModelArn.hashCode())
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (startedBy?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AudienceGenerationJobSummary

        if (audienceGenerationJobArn != other.audienceGenerationJobArn) return false
        if (collaborationId != other.collaborationId) return false
        if (configuredAudienceModelArn != other.configuredAudienceModelArn) return false
        if (createTime != other.createTime) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (startedBy != other.startedBy) return false
        if (status != other.status) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.AudienceGenerationJobSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the audience generation job.
         */
        public var audienceGenerationJobArn: kotlin.String? = null
        /**
         * The identifier of the collaboration that contains this audience generation job.
         */
        public var collaborationId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the configured audience model that was used for this audience generation job.
         */
        public var configuredAudienceModelArn: kotlin.String? = null
        /**
         * The time at which the audience generation job was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the audience generation job.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the audience generation job.
         */
        public var name: kotlin.String? = null
        /**
         * The AWS Account that submitted the job.
         */
        public var startedBy: kotlin.String? = null
        /**
         * The status of the audience generation job.
         */
        public var status: aws.sdk.kotlin.services.cleanroomsml.model.AudienceGenerationJobStatus? = null
        /**
         * The most recent time at which the audience generation job was updated.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.AudienceGenerationJobSummary) : this() {
            this.audienceGenerationJobArn = x.audienceGenerationJobArn
            this.collaborationId = x.collaborationId
            this.configuredAudienceModelArn = x.configuredAudienceModelArn
            this.createTime = x.createTime
            this.description = x.description
            this.name = x.name
            this.startedBy = x.startedBy
            this.status = x.status
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.AudienceGenerationJobSummary = AudienceGenerationJobSummary(this)

        internal fun correctErrors(): Builder {
            if (audienceGenerationJobArn == null) audienceGenerationJobArn = ""
            if (configuredAudienceModelArn == null) configuredAudienceModelArn = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            if (status == null) status = AudienceGenerationJobStatus.SdkUnknown("no value provided")
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
