// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about the audience export job.
 */
public class AudienceExportJobSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the audience generation job that was exported.
     */
    public val audienceGenerationJobArn: kotlin.String = requireNotNull(builder.audienceGenerationJobArn) { "A non-null value must be provided for audienceGenerationJobArn" }
    /**
     * The size of the generated audience. Must match one of the sizes in the configured audience model.
     */
    public val audienceSize: aws.sdk.kotlin.services.cleanroomsml.model.AudienceSize? = builder.audienceSize
    /**
     * The time at which the audience export job was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The description of the audience export job.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the audience export job.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The Amazon S3 bucket where the audience export is stored.
     */
    public val outputLocation: kotlin.String? = builder.outputLocation
    /**
     * The status of the audience export job.
     */
    public val status: aws.sdk.kotlin.services.cleanroomsml.model.AudienceExportJobStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * Details about the status of a resource.
     */
    public val statusDetails: aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails? = builder.statusDetails
    /**
     * The most recent time at which the audience export job was updated.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.AudienceExportJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AudienceExportJobSummary(")
        append("audienceGenerationJobArn=$audienceGenerationJobArn,")
        append("audienceSize=$audienceSize,")
        append("createTime=$createTime,")
        append("description=$description,")
        append("name=$name,")
        append("outputLocation=$outputLocation,")
        append("status=$status,")
        append("statusDetails=$statusDetails,")
        append("updateTime=$updateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = audienceGenerationJobArn.hashCode()
        result = 31 * result + (audienceSize?.hashCode() ?: 0)
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (outputLocation?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusDetails?.hashCode() ?: 0)
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AudienceExportJobSummary

        if (audienceGenerationJobArn != other.audienceGenerationJobArn) return false
        if (audienceSize != other.audienceSize) return false
        if (createTime != other.createTime) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (outputLocation != other.outputLocation) return false
        if (status != other.status) return false
        if (statusDetails != other.statusDetails) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.AudienceExportJobSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the audience generation job that was exported.
         */
        public var audienceGenerationJobArn: kotlin.String? = null
        /**
         * The size of the generated audience. Must match one of the sizes in the configured audience model.
         */
        public var audienceSize: aws.sdk.kotlin.services.cleanroomsml.model.AudienceSize? = null
        /**
         * The time at which the audience export job was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the audience export job.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the audience export job.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon S3 bucket where the audience export is stored.
         */
        public var outputLocation: kotlin.String? = null
        /**
         * The status of the audience export job.
         */
        public var status: aws.sdk.kotlin.services.cleanroomsml.model.AudienceExportJobStatus? = null
        /**
         * Details about the status of a resource.
         */
        public var statusDetails: aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails? = null
        /**
         * The most recent time at which the audience export job was updated.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.AudienceExportJobSummary) : this() {
            this.audienceGenerationJobArn = x.audienceGenerationJobArn
            this.audienceSize = x.audienceSize
            this.createTime = x.createTime
            this.description = x.description
            this.name = x.name
            this.outputLocation = x.outputLocation
            this.status = x.status
            this.statusDetails = x.statusDetails
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.AudienceExportJobSummary = AudienceExportJobSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.AudienceSize] inside the given [block]
         */
        public fun audienceSize(block: aws.sdk.kotlin.services.cleanroomsml.model.AudienceSize.Builder.() -> kotlin.Unit) {
            this.audienceSize = aws.sdk.kotlin.services.cleanroomsml.model.AudienceSize.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails] inside the given [block]
         */
        public fun statusDetails(block: aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails.Builder.() -> kotlin.Unit) {
            this.statusDetails = aws.sdk.kotlin.services.cleanroomsml.model.StatusDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (audienceGenerationJobArn == null) audienceGenerationJobArn = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            if (status == null) status = AudienceExportJobStatus.SdkUnknown("no value provided")
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
