// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.cleanroomsml.auth.CleanRoomsMlAuthSchemeProvider
import aws.sdk.kotlin.services.cleanroomsml.auth.DefaultCleanRoomsMlAuthSchemeProvider
import aws.sdk.kotlin.services.cleanroomsml.endpoints.CleanRoomsMlEndpointParameters
import aws.sdk.kotlin.services.cleanroomsml.endpoints.CleanRoomsMlEndpointProvider
import aws.sdk.kotlin.services.cleanroomsml.endpoints.DefaultCleanRoomsMlEndpointProvider
import aws.sdk.kotlin.services.cleanroomsml.model.CreateAudienceModelRequest
import aws.sdk.kotlin.services.cleanroomsml.model.CreateAudienceModelResponse
import aws.sdk.kotlin.services.cleanroomsml.model.CreateConfiguredAudienceModelRequest
import aws.sdk.kotlin.services.cleanroomsml.model.CreateConfiguredAudienceModelResponse
import aws.sdk.kotlin.services.cleanroomsml.model.CreateTrainingDatasetRequest
import aws.sdk.kotlin.services.cleanroomsml.model.CreateTrainingDatasetResponse
import aws.sdk.kotlin.services.cleanroomsml.model.DeleteAudienceGenerationJobRequest
import aws.sdk.kotlin.services.cleanroomsml.model.DeleteAudienceGenerationJobResponse
import aws.sdk.kotlin.services.cleanroomsml.model.DeleteAudienceModelRequest
import aws.sdk.kotlin.services.cleanroomsml.model.DeleteAudienceModelResponse
import aws.sdk.kotlin.services.cleanroomsml.model.DeleteConfiguredAudienceModelPolicyRequest
import aws.sdk.kotlin.services.cleanroomsml.model.DeleteConfiguredAudienceModelPolicyResponse
import aws.sdk.kotlin.services.cleanroomsml.model.DeleteConfiguredAudienceModelRequest
import aws.sdk.kotlin.services.cleanroomsml.model.DeleteConfiguredAudienceModelResponse
import aws.sdk.kotlin.services.cleanroomsml.model.DeleteTrainingDatasetRequest
import aws.sdk.kotlin.services.cleanroomsml.model.DeleteTrainingDatasetResponse
import aws.sdk.kotlin.services.cleanroomsml.model.GetAudienceGenerationJobRequest
import aws.sdk.kotlin.services.cleanroomsml.model.GetAudienceGenerationJobResponse
import aws.sdk.kotlin.services.cleanroomsml.model.GetAudienceModelRequest
import aws.sdk.kotlin.services.cleanroomsml.model.GetAudienceModelResponse
import aws.sdk.kotlin.services.cleanroomsml.model.GetConfiguredAudienceModelPolicyRequest
import aws.sdk.kotlin.services.cleanroomsml.model.GetConfiguredAudienceModelPolicyResponse
import aws.sdk.kotlin.services.cleanroomsml.model.GetConfiguredAudienceModelRequest
import aws.sdk.kotlin.services.cleanroomsml.model.GetConfiguredAudienceModelResponse
import aws.sdk.kotlin.services.cleanroomsml.model.GetTrainingDatasetRequest
import aws.sdk.kotlin.services.cleanroomsml.model.GetTrainingDatasetResponse
import aws.sdk.kotlin.services.cleanroomsml.model.ListAudienceExportJobsRequest
import aws.sdk.kotlin.services.cleanroomsml.model.ListAudienceExportJobsResponse
import aws.sdk.kotlin.services.cleanroomsml.model.ListAudienceGenerationJobsRequest
import aws.sdk.kotlin.services.cleanroomsml.model.ListAudienceGenerationJobsResponse
import aws.sdk.kotlin.services.cleanroomsml.model.ListAudienceModelsRequest
import aws.sdk.kotlin.services.cleanroomsml.model.ListAudienceModelsResponse
import aws.sdk.kotlin.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest
import aws.sdk.kotlin.services.cleanroomsml.model.ListConfiguredAudienceModelsResponse
import aws.sdk.kotlin.services.cleanroomsml.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.cleanroomsml.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.cleanroomsml.model.ListTrainingDatasetsRequest
import aws.sdk.kotlin.services.cleanroomsml.model.ListTrainingDatasetsResponse
import aws.sdk.kotlin.services.cleanroomsml.model.PutConfiguredAudienceModelPolicyRequest
import aws.sdk.kotlin.services.cleanroomsml.model.PutConfiguredAudienceModelPolicyResponse
import aws.sdk.kotlin.services.cleanroomsml.model.StartAudienceExportJobRequest
import aws.sdk.kotlin.services.cleanroomsml.model.StartAudienceExportJobResponse
import aws.sdk.kotlin.services.cleanroomsml.model.StartAudienceGenerationJobRequest
import aws.sdk.kotlin.services.cleanroomsml.model.StartAudienceGenerationJobResponse
import aws.sdk.kotlin.services.cleanroomsml.model.TagResourceRequest
import aws.sdk.kotlin.services.cleanroomsml.model.TagResourceResponse
import aws.sdk.kotlin.services.cleanroomsml.model.UntagResourceRequest
import aws.sdk.kotlin.services.cleanroomsml.model.UntagResourceResponse
import aws.sdk.kotlin.services.cleanroomsml.model.UpdateConfiguredAudienceModelRequest
import aws.sdk.kotlin.services.cleanroomsml.model.UpdateConfiguredAudienceModelResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "CleanRoomsML"
public const val SdkVersion: String = "1.1.1"
public const val ServiceApiVersion: String = "2023-09-06"

/**
 * Welcome to the *Amazon Web Services Clean Rooms ML API Reference*.
 *
 * Amazon Web Services Clean Rooms ML provides a privacy-enhancing method for two parties to identify similar users in their data without the need to share their data with each other. The first party brings the training data to Clean Rooms so that they can create and configure an audience model (lookalike model) and associate it with a collaboration. The second party then brings their seed data to Clean Rooms and generates an audience (lookalike segment) that resembles the training data.
 *
 * To learn more about Amazon Web Services Clean Rooms ML concepts, procedures, and best practices, see the [Clean Rooms User Guide](https://docs.aws.amazon.com/clean-rooms/latest/userguide/machine-learning.html).
 *
 * To learn more about SQL commands, functions, and conditions supported in Clean Rooms, see the [Clean Rooms SQL Reference](https://docs.aws.amazon.com/clean-rooms/latest/sql-reference/sql-reference.html).
 */
public interface CleanRoomsMlClient : SdkClient {
    /**
     * CleanRoomsMlClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, CleanRoomsMlClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "CleanRoomsMl",
                "CLEANROOMSML",
                "cleanroomsml",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, CleanRoomsMlClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): CleanRoomsMlClient = DefaultCleanRoomsMlClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: CleanRoomsMlEndpointProvider = builder.endpointProvider ?: DefaultCleanRoomsMlEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: CleanRoomsMlAuthSchemeProvider = builder.authSchemeProvider ?: DefaultCleanRoomsMlAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "CleanRoomsML"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: CleanRoomsMlEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: CleanRoomsMlAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Defines the information necessary to create an audience model. An audience model is a machine learning model that Clean Rooms ML trains to measure similarity between users. Clean Rooms ML manages training and storing the audience model. The audience model can be used in multiple calls to the StartAudienceGenerationJob API.
     */
    public suspend fun createAudienceModel(input: CreateAudienceModelRequest): CreateAudienceModelResponse

    /**
     * Defines the information necessary to create a configured audience model.
     */
    public suspend fun createConfiguredAudienceModel(input: CreateConfiguredAudienceModelRequest): CreateConfiguredAudienceModelResponse

    /**
     * Defines the information necessary to create a training dataset, or seed audience. In Clean Rooms ML, the `TrainingDataset` is metadata that points to a Glue table, which is read only during `AudienceModel` creation.
     */
    public suspend fun createTrainingDataset(input: CreateTrainingDatasetRequest): CreateTrainingDatasetResponse

    /**
     * Deletes the specified audience generation job, and removes all data associated with the job.
     */
    public suspend fun deleteAudienceGenerationJob(input: DeleteAudienceGenerationJobRequest): DeleteAudienceGenerationJobResponse

    /**
     * Specifies an audience model that you want to delete. You can't delete an audience model if there are any configured audience models that depend on the audience model.
     */
    public suspend fun deleteAudienceModel(input: DeleteAudienceModelRequest): DeleteAudienceModelResponse

    /**
     * Deletes the specified configured audience model. You can't delete a configured audience model if there are any lookalike models that use the configured audience model. If you delete a configured audience model, it will be removed from any collaborations that it is associated to.
     */
    public suspend fun deleteConfiguredAudienceModel(input: DeleteConfiguredAudienceModelRequest): DeleteConfiguredAudienceModelResponse

    /**
     * Deletes the specified configured audience model policy.
     */
    public suspend fun deleteConfiguredAudienceModelPolicy(input: DeleteConfiguredAudienceModelPolicyRequest): DeleteConfiguredAudienceModelPolicyResponse

    /**
     * Specifies a training dataset that you want to delete. You can't delete a training dataset if there are any audience models that depend on the training dataset. In Clean Rooms ML, the `TrainingDataset` is metadata that points to a Glue table, which is read only during `AudienceModel` creation. This action deletes the metadata.
     */
    public suspend fun deleteTrainingDataset(input: DeleteTrainingDatasetRequest): DeleteTrainingDatasetResponse

    /**
     * Returns information about an audience generation job.
     */
    public suspend fun getAudienceGenerationJob(input: GetAudienceGenerationJobRequest): GetAudienceGenerationJobResponse

    /**
     * Returns information about an audience model
     */
    public suspend fun getAudienceModel(input: GetAudienceModelRequest): GetAudienceModelResponse

    /**
     * Returns information about a specified configured audience model.
     */
    public suspend fun getConfiguredAudienceModel(input: GetConfiguredAudienceModelRequest): GetConfiguredAudienceModelResponse

    /**
     * Returns information about a configured audience model policy.
     */
    public suspend fun getConfiguredAudienceModelPolicy(input: GetConfiguredAudienceModelPolicyRequest): GetConfiguredAudienceModelPolicyResponse

    /**
     * Returns information about a training dataset.
     */
    public suspend fun getTrainingDataset(input: GetTrainingDatasetRequest): GetTrainingDatasetResponse

    /**
     * Returns a list of the audience export jobs.
     */
    public suspend fun listAudienceExportJobs(input: ListAudienceExportJobsRequest = ListAudienceExportJobsRequest { }): ListAudienceExportJobsResponse

    /**
     * Returns a list of audience generation jobs.
     */
    public suspend fun listAudienceGenerationJobs(input: ListAudienceGenerationJobsRequest = ListAudienceGenerationJobsRequest { }): ListAudienceGenerationJobsResponse

    /**
     * Returns a list of audience models.
     */
    public suspend fun listAudienceModels(input: ListAudienceModelsRequest = ListAudienceModelsRequest { }): ListAudienceModelsResponse

    /**
     * Returns a list of the configured audience models.
     */
    public suspend fun listConfiguredAudienceModels(input: ListConfiguredAudienceModelsRequest = ListConfiguredAudienceModelsRequest { }): ListConfiguredAudienceModelsResponse

    /**
     * Returns a list of tags for a provided resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of training datasets.
     */
    public suspend fun listTrainingDatasets(input: ListTrainingDatasetsRequest = ListTrainingDatasetsRequest { }): ListTrainingDatasetsResponse

    /**
     * Create or update the resource policy for a configured audience model.
     */
    public suspend fun putConfiguredAudienceModelPolicy(input: PutConfiguredAudienceModelPolicyRequest): PutConfiguredAudienceModelPolicyResponse

    /**
     * Export an audience of a specified size after you have generated an audience.
     */
    public suspend fun startAudienceExportJob(input: StartAudienceExportJobRequest): StartAudienceExportJobResponse

    /**
     * Information necessary to start the audience generation job.
     */
    public suspend fun startAudienceGenerationJob(input: StartAudienceGenerationJobRequest): StartAudienceGenerationJobResponse

    /**
     * Adds metadata tags to a specified resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes metadata tags from a specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Provides the information necessary to update a configured audience model. Updates that impact audience generation jobs take effect when a new job starts, but do not impact currently running jobs.
     */
    public suspend fun updateConfiguredAudienceModel(input: UpdateConfiguredAudienceModelRequest): UpdateConfiguredAudienceModelResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun CleanRoomsMlClient.withConfig(block: CleanRoomsMlClient.Config.Builder.() -> Unit): CleanRoomsMlClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultCleanRoomsMlClient(newConfig)
}

/**
 * Defines the information necessary to create an audience model. An audience model is a machine learning model that Clean Rooms ML trains to measure similarity between users. Clean Rooms ML manages training and storing the audience model. The audience model can be used in multiple calls to the StartAudienceGenerationJob API.
 */
public suspend inline fun CleanRoomsMlClient.createAudienceModel(crossinline block: CreateAudienceModelRequest.Builder.() -> Unit): CreateAudienceModelResponse = createAudienceModel(CreateAudienceModelRequest.Builder().apply(block).build())

/**
 * Defines the information necessary to create a configured audience model.
 */
public suspend inline fun CleanRoomsMlClient.createConfiguredAudienceModel(crossinline block: CreateConfiguredAudienceModelRequest.Builder.() -> Unit): CreateConfiguredAudienceModelResponse = createConfiguredAudienceModel(CreateConfiguredAudienceModelRequest.Builder().apply(block).build())

/**
 * Defines the information necessary to create a training dataset, or seed audience. In Clean Rooms ML, the `TrainingDataset` is metadata that points to a Glue table, which is read only during `AudienceModel` creation.
 */
public suspend inline fun CleanRoomsMlClient.createTrainingDataset(crossinline block: CreateTrainingDatasetRequest.Builder.() -> Unit): CreateTrainingDatasetResponse = createTrainingDataset(CreateTrainingDatasetRequest.Builder().apply(block).build())

/**
 * Deletes the specified audience generation job, and removes all data associated with the job.
 */
public suspend inline fun CleanRoomsMlClient.deleteAudienceGenerationJob(crossinline block: DeleteAudienceGenerationJobRequest.Builder.() -> Unit): DeleteAudienceGenerationJobResponse = deleteAudienceGenerationJob(DeleteAudienceGenerationJobRequest.Builder().apply(block).build())

/**
 * Specifies an audience model that you want to delete. You can't delete an audience model if there are any configured audience models that depend on the audience model.
 */
public suspend inline fun CleanRoomsMlClient.deleteAudienceModel(crossinline block: DeleteAudienceModelRequest.Builder.() -> Unit): DeleteAudienceModelResponse = deleteAudienceModel(DeleteAudienceModelRequest.Builder().apply(block).build())

/**
 * Deletes the specified configured audience model. You can't delete a configured audience model if there are any lookalike models that use the configured audience model. If you delete a configured audience model, it will be removed from any collaborations that it is associated to.
 */
public suspend inline fun CleanRoomsMlClient.deleteConfiguredAudienceModel(crossinline block: DeleteConfiguredAudienceModelRequest.Builder.() -> Unit): DeleteConfiguredAudienceModelResponse = deleteConfiguredAudienceModel(DeleteConfiguredAudienceModelRequest.Builder().apply(block).build())

/**
 * Deletes the specified configured audience model policy.
 */
public suspend inline fun CleanRoomsMlClient.deleteConfiguredAudienceModelPolicy(crossinline block: DeleteConfiguredAudienceModelPolicyRequest.Builder.() -> Unit): DeleteConfiguredAudienceModelPolicyResponse = deleteConfiguredAudienceModelPolicy(DeleteConfiguredAudienceModelPolicyRequest.Builder().apply(block).build())

/**
 * Specifies a training dataset that you want to delete. You can't delete a training dataset if there are any audience models that depend on the training dataset. In Clean Rooms ML, the `TrainingDataset` is metadata that points to a Glue table, which is read only during `AudienceModel` creation. This action deletes the metadata.
 */
public suspend inline fun CleanRoomsMlClient.deleteTrainingDataset(crossinline block: DeleteTrainingDatasetRequest.Builder.() -> Unit): DeleteTrainingDatasetResponse = deleteTrainingDataset(DeleteTrainingDatasetRequest.Builder().apply(block).build())

/**
 * Returns information about an audience generation job.
 */
public suspend inline fun CleanRoomsMlClient.getAudienceGenerationJob(crossinline block: GetAudienceGenerationJobRequest.Builder.() -> Unit): GetAudienceGenerationJobResponse = getAudienceGenerationJob(GetAudienceGenerationJobRequest.Builder().apply(block).build())

/**
 * Returns information about an audience model
 */
public suspend inline fun CleanRoomsMlClient.getAudienceModel(crossinline block: GetAudienceModelRequest.Builder.() -> Unit): GetAudienceModelResponse = getAudienceModel(GetAudienceModelRequest.Builder().apply(block).build())

/**
 * Returns information about a specified configured audience model.
 */
public suspend inline fun CleanRoomsMlClient.getConfiguredAudienceModel(crossinline block: GetConfiguredAudienceModelRequest.Builder.() -> Unit): GetConfiguredAudienceModelResponse = getConfiguredAudienceModel(GetConfiguredAudienceModelRequest.Builder().apply(block).build())

/**
 * Returns information about a configured audience model policy.
 */
public suspend inline fun CleanRoomsMlClient.getConfiguredAudienceModelPolicy(crossinline block: GetConfiguredAudienceModelPolicyRequest.Builder.() -> Unit): GetConfiguredAudienceModelPolicyResponse = getConfiguredAudienceModelPolicy(GetConfiguredAudienceModelPolicyRequest.Builder().apply(block).build())

/**
 * Returns information about a training dataset.
 */
public suspend inline fun CleanRoomsMlClient.getTrainingDataset(crossinline block: GetTrainingDatasetRequest.Builder.() -> Unit): GetTrainingDatasetResponse = getTrainingDataset(GetTrainingDatasetRequest.Builder().apply(block).build())

/**
 * Returns a list of the audience export jobs.
 */
public suspend inline fun CleanRoomsMlClient.listAudienceExportJobs(crossinline block: ListAudienceExportJobsRequest.Builder.() -> Unit): ListAudienceExportJobsResponse = listAudienceExportJobs(ListAudienceExportJobsRequest.Builder().apply(block).build())

/**
 * Returns a list of audience generation jobs.
 */
public suspend inline fun CleanRoomsMlClient.listAudienceGenerationJobs(crossinline block: ListAudienceGenerationJobsRequest.Builder.() -> Unit): ListAudienceGenerationJobsResponse = listAudienceGenerationJobs(ListAudienceGenerationJobsRequest.Builder().apply(block).build())

/**
 * Returns a list of audience models.
 */
public suspend inline fun CleanRoomsMlClient.listAudienceModels(crossinline block: ListAudienceModelsRequest.Builder.() -> Unit): ListAudienceModelsResponse = listAudienceModels(ListAudienceModelsRequest.Builder().apply(block).build())

/**
 * Returns a list of the configured audience models.
 */
public suspend inline fun CleanRoomsMlClient.listConfiguredAudienceModels(crossinline block: ListConfiguredAudienceModelsRequest.Builder.() -> Unit): ListConfiguredAudienceModelsResponse = listConfiguredAudienceModels(ListConfiguredAudienceModelsRequest.Builder().apply(block).build())

/**
 * Returns a list of tags for a provided resource.
 */
public suspend inline fun CleanRoomsMlClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Returns a list of training datasets.
 */
public suspend inline fun CleanRoomsMlClient.listTrainingDatasets(crossinline block: ListTrainingDatasetsRequest.Builder.() -> Unit): ListTrainingDatasetsResponse = listTrainingDatasets(ListTrainingDatasetsRequest.Builder().apply(block).build())

/**
 * Create or update the resource policy for a configured audience model.
 */
public suspend inline fun CleanRoomsMlClient.putConfiguredAudienceModelPolicy(crossinline block: PutConfiguredAudienceModelPolicyRequest.Builder.() -> Unit): PutConfiguredAudienceModelPolicyResponse = putConfiguredAudienceModelPolicy(PutConfiguredAudienceModelPolicyRequest.Builder().apply(block).build())

/**
 * Export an audience of a specified size after you have generated an audience.
 */
public suspend inline fun CleanRoomsMlClient.startAudienceExportJob(crossinline block: StartAudienceExportJobRequest.Builder.() -> Unit): StartAudienceExportJobResponse = startAudienceExportJob(StartAudienceExportJobRequest.Builder().apply(block).build())

/**
 * Information necessary to start the audience generation job.
 */
public suspend inline fun CleanRoomsMlClient.startAudienceGenerationJob(crossinline block: StartAudienceGenerationJobRequest.Builder.() -> Unit): StartAudienceGenerationJobResponse = startAudienceGenerationJob(StartAudienceGenerationJobRequest.Builder().apply(block).build())

/**
 * Adds metadata tags to a specified resource.
 */
public suspend inline fun CleanRoomsMlClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes metadata tags from a specified resource.
 */
public suspend inline fun CleanRoomsMlClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Provides the information necessary to update a configured audience model. Updates that impact audience generation jobs take effect when a new job starts, but do not impact currently running jobs.
 */
public suspend inline fun CleanRoomsMlClient.updateConfiguredAudienceModel(crossinline block: UpdateConfiguredAudienceModelRequest.Builder.() -> Unit): UpdateConfiguredAudienceModelResponse = updateConfiguredAudienceModel(UpdateConfiguredAudienceModelRequest.Builder().apply(block).build())
