// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about the training dataset.
 */
public class TrainingDatasetSummary private constructor(builder: Builder) {
    /**
     * The time at which the training dataset was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The description of the training dataset.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the training dataset.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The status of the training dataset.
     */
    public val status: aws.sdk.kotlin.services.cleanroomsml.model.TrainingDatasetStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The Amazon Resource Name (ARN) of the training dataset.
     */
    public val trainingDatasetArn: kotlin.String = requireNotNull(builder.trainingDatasetArn) { "A non-null value must be provided for trainingDatasetArn" }
    /**
     * The most recent time at which the training dataset was updated.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.TrainingDatasetSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrainingDatasetSummary(")
        append("createTime=$createTime,")
        append("description=$description,")
        append("name=$name,")
        append("status=$status,")
        append("trainingDatasetArn=$trainingDatasetArn,")
        append("updateTime=$updateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createTime.hashCode()
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (trainingDatasetArn.hashCode())
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrainingDatasetSummary

        if (createTime != other.createTime) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (trainingDatasetArn != other.trainingDatasetArn) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.TrainingDatasetSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time at which the training dataset was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the training dataset.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the training dataset.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the training dataset.
         */
        public var status: aws.sdk.kotlin.services.cleanroomsml.model.TrainingDatasetStatus? = null
        /**
         * The Amazon Resource Name (ARN) of the training dataset.
         */
        public var trainingDatasetArn: kotlin.String? = null
        /**
         * The most recent time at which the training dataset was updated.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.TrainingDatasetSummary) : this() {
            this.createTime = x.createTime
            this.description = x.description
            this.name = x.name
            this.status = x.status
            this.trainingDatasetArn = x.trainingDatasetArn
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.TrainingDatasetSummary = TrainingDatasetSummary(this)

        internal fun correctErrors(): Builder {
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            if (status == null) status = TrainingDatasetStatus.SdkUnknown("no value provided")
            if (trainingDatasetArn == null) trainingDatasetArn = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
