// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the configured audience model.
 */
public class ConfiguredAudienceModelSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the audience model that was used to create the configured audience model.
     */
    public val audienceModelArn: kotlin.String = requireNotNull(builder.audienceModelArn) { "A non-null value must be provided for audienceModelArn" }
    /**
     * The Amazon Resource Name (ARN) of the configured audience model that you are interested in.
     */
    public val configuredAudienceModelArn: kotlin.String = requireNotNull(builder.configuredAudienceModelArn) { "A non-null value must be provided for configuredAudienceModelArn" }
    /**
     * The time at which the configured audience model was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The description of the configured audience model.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the configured audience model.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The output configuration of the configured audience model.
     */
    public val outputConfig: aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredAudienceModelOutputConfig? = builder.outputConfig
    /**
     * The status of the configured audience model.
     */
    public val status: aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredAudienceModelStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The most recent time at which the configured audience model was updated.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredAudienceModelSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConfiguredAudienceModelSummary(")
        append("audienceModelArn=$audienceModelArn,")
        append("configuredAudienceModelArn=$configuredAudienceModelArn,")
        append("createTime=$createTime,")
        append("description=$description,")
        append("name=$name,")
        append("outputConfig=$outputConfig,")
        append("status=$status,")
        append("updateTime=$updateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = audienceModelArn.hashCode()
        result = 31 * result + (configuredAudienceModelArn.hashCode())
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (outputConfig?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConfiguredAudienceModelSummary

        if (audienceModelArn != other.audienceModelArn) return false
        if (configuredAudienceModelArn != other.configuredAudienceModelArn) return false
        if (createTime != other.createTime) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (outputConfig != other.outputConfig) return false
        if (status != other.status) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredAudienceModelSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the audience model that was used to create the configured audience model.
         */
        public var audienceModelArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the configured audience model that you are interested in.
         */
        public var configuredAudienceModelArn: kotlin.String? = null
        /**
         * The time at which the configured audience model was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the configured audience model.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the configured audience model.
         */
        public var name: kotlin.String? = null
        /**
         * The output configuration of the configured audience model.
         */
        public var outputConfig: aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredAudienceModelOutputConfig? = null
        /**
         * The status of the configured audience model.
         */
        public var status: aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredAudienceModelStatus? = null
        /**
         * The most recent time at which the configured audience model was updated.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredAudienceModelSummary) : this() {
            this.audienceModelArn = x.audienceModelArn
            this.configuredAudienceModelArn = x.configuredAudienceModelArn
            this.createTime = x.createTime
            this.description = x.description
            this.name = x.name
            this.outputConfig = x.outputConfig
            this.status = x.status
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredAudienceModelSummary = ConfiguredAudienceModelSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredAudienceModelOutputConfig] inside the given [block]
         */
        public fun outputConfig(block: aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredAudienceModelOutputConfig.Builder.() -> kotlin.Unit) {
            this.outputConfig = aws.sdk.kotlin.services.cleanroomsml.model.ConfiguredAudienceModelOutputConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (audienceModelArn == null) audienceModelArn = ""
            if (configuredAudienceModelArn == null) configuredAudienceModelArn = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            if (status == null) status = ConfiguredAudienceModelStatus.SdkUnknown("no value provided")
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
