// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cleanroomsml.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the audience model.
 */
public class AudienceModelSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the audience model.
     */
    public val audienceModelArn: kotlin.String = requireNotNull(builder.audienceModelArn) { "A non-null value must be provided for audienceModelArn" }
    /**
     * The time at which the audience model was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The description of the audience model.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the audience model.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The status of the audience model.
     */
    public val status: aws.sdk.kotlin.services.cleanroomsml.model.AudienceModelStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The Amazon Resource Name (ARN) of the training dataset that was used for the audience model.
     */
    public val trainingDatasetArn: kotlin.String = requireNotNull(builder.trainingDatasetArn) { "A non-null value must be provided for trainingDatasetArn" }
    /**
     * The most recent time at which the audience model was updated.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cleanroomsml.model.AudienceModelSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AudienceModelSummary(")
        append("audienceModelArn=$audienceModelArn,")
        append("createTime=$createTime,")
        append("description=$description,")
        append("name=$name,")
        append("status=$status,")
        append("trainingDatasetArn=$trainingDatasetArn,")
        append("updateTime=$updateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = audienceModelArn.hashCode()
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (trainingDatasetArn.hashCode())
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AudienceModelSummary

        if (audienceModelArn != other.audienceModelArn) return false
        if (createTime != other.createTime) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (trainingDatasetArn != other.trainingDatasetArn) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cleanroomsml.model.AudienceModelSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the audience model.
         */
        public var audienceModelArn: kotlin.String? = null
        /**
         * The time at which the audience model was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the audience model.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the audience model.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the audience model.
         */
        public var status: aws.sdk.kotlin.services.cleanroomsml.model.AudienceModelStatus? = null
        /**
         * The Amazon Resource Name (ARN) of the training dataset that was used for the audience model.
         */
        public var trainingDatasetArn: kotlin.String? = null
        /**
         * The most recent time at which the audience model was updated.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cleanroomsml.model.AudienceModelSummary) : this() {
            this.audienceModelArn = x.audienceModelArn
            this.createTime = x.createTime
            this.description = x.description
            this.name = x.name
            this.status = x.status
            this.trainingDatasetArn = x.trainingDatasetArn
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cleanroomsml.model.AudienceModelSummary = AudienceModelSummary(this)

        internal fun correctErrors(): Builder {
            if (audienceModelArn == null) audienceModelArn = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            if (status == null) status = AudienceModelStatus.SdkUnknown("no value provided")
            if (trainingDatasetArn == null) trainingDatasetArn = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
