// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmessaging.serde

import aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMembershipPreferences
import aws.sdk.kotlin.services.chimesdkmessaging.model.ChimeSdkMessagingException
import aws.sdk.kotlin.services.chimesdkmessaging.model.Identity
import aws.sdk.kotlin.services.chimesdkmessaging.model.PutChannelMembershipPreferencesResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutChannelMembershipPreferencesOperationDeserializer: HttpDeserializer.NonStreaming<PutChannelMembershipPreferencesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PutChannelMembershipPreferencesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutChannelMembershipPreferencesError(context, call, payload)
        }
        val builder = PutChannelMembershipPreferencesResponse.Builder()

        if (payload != null) {
            deserializePutChannelMembershipPreferencesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPutChannelMembershipPreferencesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ChimeSdkMessagingException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "UnauthorizedClientException" -> UnauthorizedClientExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottledClientException" -> ThrottledClientExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceFailureException" -> ServiceFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ChimeSdkMessagingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutChannelMembershipPreferencesOperationBody(builder: PutChannelMembershipPreferencesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CHANNELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChannelArn"))
    val MEMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Member"))
    val PREFERENCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Preferences"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHANNELARN_DESCRIPTOR)
        field(MEMBER_DESCRIPTOR)
        field(PREFERENCES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHANNELARN_DESCRIPTOR.index -> builder.channelArn = deserializeString()
                MEMBER_DESCRIPTOR.index -> builder.member = deserializeIdentityDocument(deserializer)
                PREFERENCES_DESCRIPTOR.index -> builder.preferences = deserializeChannelMembershipPreferencesDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
