// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmessaging.serde

import aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMode
import aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelPrivacy
import aws.sdk.kotlin.services.chimesdkmessaging.model.CreateChannelRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.ElasticChannelConfiguration
import aws.sdk.kotlin.services.chimesdkmessaging.model.ExpirationSettings
import aws.sdk.kotlin.services.chimesdkmessaging.model.Tag
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateChannelOperationSerializer: HttpSerializer.NonStreaming<CreateChannelRequest> {
    override fun serialize(context: ExecutionContext, input: CreateChannelRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/channels"
        }

        builder.headers {
            if (input.chimeBearer?.isNotEmpty() == true) append("x-amz-chime-bearer", input.chimeBearer)
        }

        val payload = serializeCreateChannelOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateChannelOperationBody(context: ExecutionContext, input: CreateChannelRequest): ByteArray {
    val serializer = JsonSerializer()
    val APPINSTANCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AppInstanceArn"))
    val CHANNELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChannelId"))
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientRequestToken"))
    val ELASTICCHANNELCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ElasticChannelConfiguration"))
    val EXPIRATIONSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ExpirationSettings"))
    val MEMBERARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("MemberArns"))
    val METADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Metadata"))
    val MODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Mode"))
    val MODERATORARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ModeratorArns"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PRIVACY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Privacy"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPINSTANCEARN_DESCRIPTOR)
        field(CHANNELID_DESCRIPTOR)
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(ELASTICCHANNELCONFIGURATION_DESCRIPTOR)
        field(EXPIRATIONSETTINGS_DESCRIPTOR)
        field(MEMBERARNS_DESCRIPTOR)
        field(METADATA_DESCRIPTOR)
        field(MODE_DESCRIPTOR)
        field(MODERATORARNS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PRIVACY_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.appInstanceArn?.let { field(APPINSTANCEARN_DESCRIPTOR, it) }
        input.channelId?.let { field(CHANNELID_DESCRIPTOR, it) }
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.elasticChannelConfiguration?.let { field(ELASTICCHANNELCONFIGURATION_DESCRIPTOR, it, ::serializeElasticChannelConfigurationDocument) }
        input.expirationSettings?.let { field(EXPIRATIONSETTINGS_DESCRIPTOR, it, ::serializeExpirationSettingsDocument) }
        if (input.memberArns != null) {
            listField(MEMBERARNS_DESCRIPTOR) {
                for (el0 in input.memberArns) {
                    serializeString(el0)
                }
            }
        }
        input.metadata?.let { field(METADATA_DESCRIPTOR, it) }
        input.mode?.let { field(MODE_DESCRIPTOR, it.value) }
        if (input.moderatorArns != null) {
            listField(MODERATORARNS_DESCRIPTOR) {
                for (el0 in input.moderatorArns) {
                    serializeString(el0)
                }
            }
        }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.privacy?.let { field(PRIVACY_DESCRIPTOR, it.value) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
