// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmessaging.paginators

import aws.sdk.kotlin.services.chimesdkmessaging.ChimeSdkMessagingClient
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelBansRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelBansResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelFlowsRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelFlowsResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelMembershipsRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelMembershipsResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelMessagesRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelMessagesResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelModeratorsRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelModeratorsResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelsRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelsResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListSubChannelsRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListSubChannelsResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.SearchChannelsRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.SearchChannelsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListChannelBansResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListChannelBansRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelBansResponse]
 */
public fun ChimeSdkMessagingClient.listChannelBansPaginated(initialRequest: ListChannelBansRequest): Flow<ListChannelBansResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listChannelBansPaginated.listChannelBans(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListChannelBansResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelBansResponse]
 */
public fun ChimeSdkMessagingClient.listChannelBansPaginated(block: ListChannelBansRequest.Builder.() -> Unit): Flow<ListChannelBansResponse> =
    listChannelBansPaginated(ListChannelBansRequest.Builder().apply(block).build())

/**
 * Paginate over [ListChannelFlowsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListChannelFlowsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelFlowsResponse]
 */
public fun ChimeSdkMessagingClient.listChannelFlowsPaginated(initialRequest: ListChannelFlowsRequest): Flow<ListChannelFlowsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listChannelFlowsPaginated.listChannelFlows(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListChannelFlowsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelFlowsResponse]
 */
public fun ChimeSdkMessagingClient.listChannelFlowsPaginated(block: ListChannelFlowsRequest.Builder.() -> Unit): Flow<ListChannelFlowsResponse> =
    listChannelFlowsPaginated(ListChannelFlowsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListChannelMembershipsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListChannelMembershipsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelMembershipsResponse]
 */
public fun ChimeSdkMessagingClient.listChannelMembershipsPaginated(initialRequest: ListChannelMembershipsRequest): Flow<ListChannelMembershipsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listChannelMembershipsPaginated.listChannelMemberships(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListChannelMembershipsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelMembershipsResponse]
 */
public fun ChimeSdkMessagingClient.listChannelMembershipsPaginated(block: ListChannelMembershipsRequest.Builder.() -> Unit): Flow<ListChannelMembershipsResponse> =
    listChannelMembershipsPaginated(ListChannelMembershipsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListChannelMembershipsForAppInstanceUserResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListChannelMembershipsForAppInstanceUserRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelMembershipsForAppInstanceUserResponse]
 */
public fun ChimeSdkMessagingClient.listChannelMembershipsForAppInstanceUserPaginated(initialRequest: ListChannelMembershipsForAppInstanceUserRequest): Flow<ListChannelMembershipsForAppInstanceUserResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listChannelMembershipsForAppInstanceUserPaginated.listChannelMembershipsForAppInstanceUser(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListChannelMembershipsForAppInstanceUserResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelMembershipsForAppInstanceUserResponse]
 */
public fun ChimeSdkMessagingClient.listChannelMembershipsForAppInstanceUserPaginated(block: ListChannelMembershipsForAppInstanceUserRequest.Builder.() -> Unit): Flow<ListChannelMembershipsForAppInstanceUserResponse> =
    listChannelMembershipsForAppInstanceUserPaginated(ListChannelMembershipsForAppInstanceUserRequest.Builder().apply(block).build())

/**
 * Paginate over [ListChannelMessagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListChannelMessagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelMessagesResponse]
 */
public fun ChimeSdkMessagingClient.listChannelMessagesPaginated(initialRequest: ListChannelMessagesRequest): Flow<ListChannelMessagesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listChannelMessagesPaginated.listChannelMessages(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListChannelMessagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelMessagesResponse]
 */
public fun ChimeSdkMessagingClient.listChannelMessagesPaginated(block: ListChannelMessagesRequest.Builder.() -> Unit): Flow<ListChannelMessagesResponse> =
    listChannelMessagesPaginated(ListChannelMessagesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListChannelModeratorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListChannelModeratorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelModeratorsResponse]
 */
public fun ChimeSdkMessagingClient.listChannelModeratorsPaginated(initialRequest: ListChannelModeratorsRequest): Flow<ListChannelModeratorsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listChannelModeratorsPaginated.listChannelModerators(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListChannelModeratorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelModeratorsResponse]
 */
public fun ChimeSdkMessagingClient.listChannelModeratorsPaginated(block: ListChannelModeratorsRequest.Builder.() -> Unit): Flow<ListChannelModeratorsResponse> =
    listChannelModeratorsPaginated(ListChannelModeratorsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListChannelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListChannelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelsResponse]
 */
public fun ChimeSdkMessagingClient.listChannelsPaginated(initialRequest: ListChannelsRequest): Flow<ListChannelsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listChannelsPaginated.listChannels(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListChannelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelsResponse]
 */
public fun ChimeSdkMessagingClient.listChannelsPaginated(block: ListChannelsRequest.Builder.() -> Unit): Flow<ListChannelsResponse> =
    listChannelsPaginated(ListChannelsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListChannelsAssociatedWithChannelFlowResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListChannelsAssociatedWithChannelFlowRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelsAssociatedWithChannelFlowResponse]
 */
public fun ChimeSdkMessagingClient.listChannelsAssociatedWithChannelFlowPaginated(initialRequest: ListChannelsAssociatedWithChannelFlowRequest): Flow<ListChannelsAssociatedWithChannelFlowResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listChannelsAssociatedWithChannelFlowPaginated.listChannelsAssociatedWithChannelFlow(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListChannelsAssociatedWithChannelFlowResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelsAssociatedWithChannelFlowResponse]
 */
public fun ChimeSdkMessagingClient.listChannelsAssociatedWithChannelFlowPaginated(block: ListChannelsAssociatedWithChannelFlowRequest.Builder.() -> Unit): Flow<ListChannelsAssociatedWithChannelFlowResponse> =
    listChannelsAssociatedWithChannelFlowPaginated(ListChannelsAssociatedWithChannelFlowRequest.Builder().apply(block).build())

/**
 * Paginate over [ListChannelsModeratedByAppInstanceUserResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListChannelsModeratedByAppInstanceUserRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelsModeratedByAppInstanceUserResponse]
 */
public fun ChimeSdkMessagingClient.listChannelsModeratedByAppInstanceUserPaginated(initialRequest: ListChannelsModeratedByAppInstanceUserRequest): Flow<ListChannelsModeratedByAppInstanceUserResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listChannelsModeratedByAppInstanceUserPaginated.listChannelsModeratedByAppInstanceUser(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListChannelsModeratedByAppInstanceUserResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelsModeratedByAppInstanceUserResponse]
 */
public fun ChimeSdkMessagingClient.listChannelsModeratedByAppInstanceUserPaginated(block: ListChannelsModeratedByAppInstanceUserRequest.Builder.() -> Unit): Flow<ListChannelsModeratedByAppInstanceUserResponse> =
    listChannelsModeratedByAppInstanceUserPaginated(ListChannelsModeratedByAppInstanceUserRequest.Builder().apply(block).build())

/**
 * Paginate over [ListSubChannelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSubChannelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSubChannelsResponse]
 */
public fun ChimeSdkMessagingClient.listSubChannelsPaginated(initialRequest: ListSubChannelsRequest): Flow<ListSubChannelsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSubChannelsPaginated.listSubChannels(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSubChannelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSubChannelsResponse]
 */
public fun ChimeSdkMessagingClient.listSubChannelsPaginated(block: ListSubChannelsRequest.Builder.() -> Unit): Flow<ListSubChannelsResponse> =
    listSubChannelsPaginated(ListSubChannelsRequest.Builder().apply(block).build())

/**
 * Paginate over [SearchChannelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchChannelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchChannelsResponse]
 */
public fun ChimeSdkMessagingClient.searchChannelsPaginated(initialRequest: SearchChannelsRequest): Flow<SearchChannelsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchChannelsPaginated.searchChannels(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [SearchChannelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchChannelsResponse]
 */
public fun ChimeSdkMessagingClient.searchChannelsPaginated(block: SearchChannelsRequest.Builder.() -> Unit): Flow<SearchChannelsResponse> =
    searchChannelsPaginated(SearchChannelsRequest.Builder().apply(block).build())
