// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmessaging.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The information about a processor in a channel flow.
 */
public class Processor private constructor(builder: Builder) {
    /**
     * The information about the type of processor and its identifier.
     */
    public val configuration: aws.sdk.kotlin.services.chimesdkmessaging.model.ProcessorConfiguration? = builder.configuration
    /**
     * The sequence in which processors run. If you have multiple processors in a channel flow, message processing goes through each processor in the sequence. The value determines the sequence. At this point, we support only 1 processor within a flow.
     */
    public val executionOrder: kotlin.Int = requireNotNull(builder.executionOrder) { "A non-null value must be provided for executionOrder" }
    /**
     * Determines whether to continue with message processing or stop it in cases where communication with a processor fails. If a processor has a fallback action of `ABORT` and communication with it fails, the processor sets the message status to `FAILED` and does not send the message to any recipients. Note that if the last processor in the channel flow sequence has a fallback action of `CONTINUE` and communication with the processor fails, then the message is considered processed and sent to recipients of the channel.
     */
    public val fallbackAction: aws.sdk.kotlin.services.chimesdkmessaging.model.FallbackAction = requireNotNull(builder.fallbackAction) { "A non-null value must be provided for fallbackAction" }
    /**
     * The name of the channel flow.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chimesdkmessaging.model.Processor = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Processor(")
        append("configuration=$configuration,")
        append("executionOrder=$executionOrder,")
        append("fallbackAction=$fallbackAction,")
        append("name=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configuration?.hashCode() ?: 0
        result = 31 * result + (executionOrder)
        result = 31 * result + (fallbackAction.hashCode())
        result = 31 * result + (name.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Processor

        if (configuration != other.configuration) return false
        if (executionOrder != other.executionOrder) return false
        if (fallbackAction != other.fallbackAction) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chimesdkmessaging.model.Processor = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The information about the type of processor and its identifier.
         */
        public var configuration: aws.sdk.kotlin.services.chimesdkmessaging.model.ProcessorConfiguration? = null
        /**
         * The sequence in which processors run. If you have multiple processors in a channel flow, message processing goes through each processor in the sequence. The value determines the sequence. At this point, we support only 1 processor within a flow.
         */
        public var executionOrder: kotlin.Int? = null
        /**
         * Determines whether to continue with message processing or stop it in cases where communication with a processor fails. If a processor has a fallback action of `ABORT` and communication with it fails, the processor sets the message status to `FAILED` and does not send the message to any recipients. Note that if the last processor in the channel flow sequence has a fallback action of `CONTINUE` and communication with the processor fails, then the message is considered processed and sent to recipients of the channel.
         */
        public var fallbackAction: aws.sdk.kotlin.services.chimesdkmessaging.model.FallbackAction? = null
        /**
         * The name of the channel flow.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chimesdkmessaging.model.Processor) : this() {
            this.configuration = x.configuration
            this.executionOrder = x.executionOrder
            this.fallbackAction = x.fallbackAction
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chimesdkmessaging.model.Processor = Processor(this)

        /**
         * construct an [aws.sdk.kotlin.services.chimesdkmessaging.model.ProcessorConfiguration] inside the given [block]
         */
        public fun configuration(block: aws.sdk.kotlin.services.chimesdkmessaging.model.ProcessorConfiguration.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.chimesdkmessaging.model.ProcessorConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (executionOrder == null) executionOrder = 0
            if (fallbackAction == null) fallbackAction = FallbackAction.SdkUnknown("no value provided")
            if (name == null) name = ""
            return this
        }
    }
}
