// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmessaging.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateChannelRequest private constructor(builder: Builder) {
    /**
     * The ARN of the channel request.
     */
    public val appInstanceArn: kotlin.String? = builder.appInstanceArn
    /**
     * The ID of the channel in the request.
     */
    public val channelId: kotlin.String? = builder.channelId
    /**
     * The ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call.
     */
    public val chimeBearer: kotlin.String? = builder.chimeBearer
    /**
     * The client token for the request. An `Idempotency` token.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The attributes required to configure and create an elastic channel. An elastic channel can support a maximum of 1-million users, excluding moderators.
     */
    public val elasticChannelConfiguration: aws.sdk.kotlin.services.chimesdkmessaging.model.ElasticChannelConfiguration? = builder.elasticChannelConfiguration
    /**
     * Settings that control the interval after which the channel is automatically deleted.
     */
    public val expirationSettings: aws.sdk.kotlin.services.chimesdkmessaging.model.ExpirationSettings? = builder.expirationSettings
    /**
     * The ARNs of the channel members in the request.
     */
    public val memberArns: List<String>? = builder.memberArns
    /**
     * The metadata of the creation request. Limited to 1KB and UTF-8.
     */
    public val metadata: kotlin.String? = builder.metadata
    /**
     * The channel mode: `UNRESTRICTED` or `RESTRICTED`. Administrators, moderators, and channel members can add themselves and other members to unrestricted channels. Only administrators and moderators can add members to restricted channels.
     */
    public val mode: aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMode? = builder.mode
    /**
     * The ARNs of the channel moderators in the request.
     */
    public val moderatorArns: List<String>? = builder.moderatorArns
    /**
     * The name of the channel.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The channel's privacy level: `PUBLIC` or `PRIVATE`. Private channels aren't discoverable by users outside the channel. Public channels are discoverable by anyone in the `AppInstance`.
     */
    public val privacy: aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelPrivacy? = builder.privacy
    /**
     * The tags for the creation request.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chimesdkmessaging.model.CreateChannelRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateChannelRequest(")
        append("appInstanceArn=$appInstanceArn,")
        append("channelId=*** Sensitive Data Redacted ***,")
        append("chimeBearer=$chimeBearer,")
        append("clientRequestToken=*** Sensitive Data Redacted ***,")
        append("elasticChannelConfiguration=$elasticChannelConfiguration,")
        append("expirationSettings=$expirationSettings,")
        append("memberArns=$memberArns,")
        append("metadata=*** Sensitive Data Redacted ***,")
        append("mode=$mode,")
        append("moderatorArns=$moderatorArns,")
        append("name=*** Sensitive Data Redacted ***,")
        append("privacy=$privacy,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appInstanceArn?.hashCode() ?: 0
        result = 31 * result + (channelId?.hashCode() ?: 0)
        result = 31 * result + (chimeBearer?.hashCode() ?: 0)
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (elasticChannelConfiguration?.hashCode() ?: 0)
        result = 31 * result + (expirationSettings?.hashCode() ?: 0)
        result = 31 * result + (memberArns?.hashCode() ?: 0)
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (moderatorArns?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (privacy?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateChannelRequest

        if (appInstanceArn != other.appInstanceArn) return false
        if (channelId != other.channelId) return false
        if (chimeBearer != other.chimeBearer) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (elasticChannelConfiguration != other.elasticChannelConfiguration) return false
        if (expirationSettings != other.expirationSettings) return false
        if (memberArns != other.memberArns) return false
        if (metadata != other.metadata) return false
        if (mode != other.mode) return false
        if (moderatorArns != other.moderatorArns) return false
        if (name != other.name) return false
        if (privacy != other.privacy) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chimesdkmessaging.model.CreateChannelRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the channel request.
         */
        public var appInstanceArn: kotlin.String? = null
        /**
         * The ID of the channel in the request.
         */
        public var channelId: kotlin.String? = null
        /**
         * The ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call.
         */
        public var chimeBearer: kotlin.String? = null
        /**
         * The client token for the request. An `Idempotency` token.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The attributes required to configure and create an elastic channel. An elastic channel can support a maximum of 1-million users, excluding moderators.
         */
        public var elasticChannelConfiguration: aws.sdk.kotlin.services.chimesdkmessaging.model.ElasticChannelConfiguration? = null
        /**
         * Settings that control the interval after which the channel is automatically deleted.
         */
        public var expirationSettings: aws.sdk.kotlin.services.chimesdkmessaging.model.ExpirationSettings? = null
        /**
         * The ARNs of the channel members in the request.
         */
        public var memberArns: List<String>? = null
        /**
         * The metadata of the creation request. Limited to 1KB and UTF-8.
         */
        public var metadata: kotlin.String? = null
        /**
         * The channel mode: `UNRESTRICTED` or `RESTRICTED`. Administrators, moderators, and channel members can add themselves and other members to unrestricted channels. Only administrators and moderators can add members to restricted channels.
         */
        public var mode: aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMode? = null
        /**
         * The ARNs of the channel moderators in the request.
         */
        public var moderatorArns: List<String>? = null
        /**
         * The name of the channel.
         */
        public var name: kotlin.String? = null
        /**
         * The channel's privacy level: `PUBLIC` or `PRIVATE`. Private channels aren't discoverable by users outside the channel. Public channels are discoverable by anyone in the `AppInstance`.
         */
        public var privacy: aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelPrivacy? = null
        /**
         * The tags for the creation request.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chimesdkmessaging.model.CreateChannelRequest) : this() {
            this.appInstanceArn = x.appInstanceArn
            this.channelId = x.channelId
            this.chimeBearer = x.chimeBearer
            this.clientRequestToken = x.clientRequestToken
            this.elasticChannelConfiguration = x.elasticChannelConfiguration
            this.expirationSettings = x.expirationSettings
            this.memberArns = x.memberArns
            this.metadata = x.metadata
            this.mode = x.mode
            this.moderatorArns = x.moderatorArns
            this.name = x.name
            this.privacy = x.privacy
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chimesdkmessaging.model.CreateChannelRequest = CreateChannelRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.chimesdkmessaging.model.ElasticChannelConfiguration] inside the given [block]
         */
        public fun elasticChannelConfiguration(block: aws.sdk.kotlin.services.chimesdkmessaging.model.ElasticChannelConfiguration.Builder.() -> kotlin.Unit) {
            this.elasticChannelConfiguration = aws.sdk.kotlin.services.chimesdkmessaging.model.ElasticChannelConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.chimesdkmessaging.model.ExpirationSettings] inside the given [block]
         */
        public fun expirationSettings(block: aws.sdk.kotlin.services.chimesdkmessaging.model.ExpirationSettings.Builder.() -> kotlin.Unit) {
            this.expirationSettings = aws.sdk.kotlin.services.chimesdkmessaging.model.ExpirationSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
