// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmessaging.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary of the messages in a `Channel`.
 */
public class ChannelMessageSummary private constructor(builder: Builder) {
    /**
     * The content of the channel message. For Amazon Lex V2 bot responses, this field holds a list of messages originating from the bot. For more information, refer to [Processing responses from an AppInstanceBot](https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html) in the *Amazon Chime SDK Messaging Developer Guide*.
     */
    public val content: kotlin.String? = builder.content
    /**
     * The content type of the channel message listed in the summary. For Amazon Lex V2 bot responses, the content type is `application/amz-chime-lex-msgs` for success responses and `application/amz-chime-lex-error` for failure responses. For more information, refer to [Processing responses from an AppInstanceBot](https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html) in the *Amazon Chime SDK Messaging Developer Guide*.
     */
    public val contentType: kotlin.String? = builder.contentType
    /**
     * The time at which the message summary was created.
     */
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * The time at which a message was last edited.
     */
    public val lastEditedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastEditedTimestamp
    /**
     * The time at which a message was last updated.
     */
    public val lastUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTimestamp
    /**
     * The attributes for the channel message. For Amazon Lex V2 bot responses, the attributes are mapped to specific fields from the bot. For more information, refer to [Processing responses from an AppInstanceBot](https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html) in the *Amazon Chime SDK Messaging Developer Guide*.
     */
    public val messageAttributes: Map<String, MessageAttributeValue>? = builder.messageAttributes
    /**
     * The ID of the message.
     */
    public val messageId: kotlin.String? = builder.messageId
    /**
     * The metadata of the message.
     */
    public val metadata: kotlin.String? = builder.metadata
    /**
     * Indicates whether a message was redacted.
     */
    public val redacted: kotlin.Boolean = builder.redacted
    /**
     * The message sender.
     */
    public val sender: aws.sdk.kotlin.services.chimesdkmessaging.model.Identity? = builder.sender
    /**
     * The message status. The status value is `SENT` for messages sent to a channel without a channel flow. For channels associated with channel flow, the value determines the processing stage.
     */
    public val status: aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageStatusStructure? = builder.status
    /**
     * The target of a message, a sender, a user, or a bot. Only the target and the sender can view targeted messages. Only users who can see targeted messages can take actions on them. However, administrators can delete targeted messages that they can’t see.
     */
    public val target: List<Target>? = builder.target
    /**
     * The type of message.
     */
    public val type: aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ChannelMessageSummary(")
        append("content=*** Sensitive Data Redacted ***,")
        append("contentType=*** Sensitive Data Redacted ***,")
        append("createdTimestamp=$createdTimestamp,")
        append("lastEditedTimestamp=$lastEditedTimestamp,")
        append("lastUpdatedTimestamp=$lastUpdatedTimestamp,")
        append("messageAttributes=$messageAttributes,")
        append("messageId=$messageId,")
        append("metadata=*** Sensitive Data Redacted ***,")
        append("redacted=$redacted,")
        append("sender=$sender,")
        append("status=$status,")
        append("target=$target,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = content?.hashCode() ?: 0
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lastEditedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (messageAttributes?.hashCode() ?: 0)
        result = 31 * result + (messageId?.hashCode() ?: 0)
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (redacted.hashCode())
        result = 31 * result + (sender?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ChannelMessageSummary

        if (content != other.content) return false
        if (contentType != other.contentType) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (lastEditedTimestamp != other.lastEditedTimestamp) return false
        if (lastUpdatedTimestamp != other.lastUpdatedTimestamp) return false
        if (messageAttributes != other.messageAttributes) return false
        if (messageId != other.messageId) return false
        if (metadata != other.metadata) return false
        if (redacted != other.redacted) return false
        if (sender != other.sender) return false
        if (status != other.status) return false
        if (target != other.target) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The content of the channel message. For Amazon Lex V2 bot responses, this field holds a list of messages originating from the bot. For more information, refer to [Processing responses from an AppInstanceBot](https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html) in the *Amazon Chime SDK Messaging Developer Guide*.
         */
        public var content: kotlin.String? = null
        /**
         * The content type of the channel message listed in the summary. For Amazon Lex V2 bot responses, the content type is `application/amz-chime-lex-msgs` for success responses and `application/amz-chime-lex-error` for failure responses. For more information, refer to [Processing responses from an AppInstanceBot](https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html) in the *Amazon Chime SDK Messaging Developer Guide*.
         */
        public var contentType: kotlin.String? = null
        /**
         * The time at which the message summary was created.
         */
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time at which a message was last edited.
         */
        public var lastEditedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time at which a message was last updated.
         */
        public var lastUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The attributes for the channel message. For Amazon Lex V2 bot responses, the attributes are mapped to specific fields from the bot. For more information, refer to [Processing responses from an AppInstanceBot](https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html) in the *Amazon Chime SDK Messaging Developer Guide*.
         */
        public var messageAttributes: Map<String, MessageAttributeValue>? = null
        /**
         * The ID of the message.
         */
        public var messageId: kotlin.String? = null
        /**
         * The metadata of the message.
         */
        public var metadata: kotlin.String? = null
        /**
         * Indicates whether a message was redacted.
         */
        public var redacted: kotlin.Boolean = false
        /**
         * The message sender.
         */
        public var sender: aws.sdk.kotlin.services.chimesdkmessaging.model.Identity? = null
        /**
         * The message status. The status value is `SENT` for messages sent to a channel without a channel flow. For channels associated with channel flow, the value determines the processing stage.
         */
        public var status: aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageStatusStructure? = null
        /**
         * The target of a message, a sender, a user, or a bot. Only the target and the sender can view targeted messages. Only users who can see targeted messages can take actions on them. However, administrators can delete targeted messages that they can’t see.
         */
        public var target: List<Target>? = null
        /**
         * The type of message.
         */
        public var type: aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageSummary) : this() {
            this.content = x.content
            this.contentType = x.contentType
            this.createdTimestamp = x.createdTimestamp
            this.lastEditedTimestamp = x.lastEditedTimestamp
            this.lastUpdatedTimestamp = x.lastUpdatedTimestamp
            this.messageAttributes = x.messageAttributes
            this.messageId = x.messageId
            this.metadata = x.metadata
            this.redacted = x.redacted
            this.sender = x.sender
            this.status = x.status
            this.target = x.target
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageSummary = ChannelMessageSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.chimesdkmessaging.model.Identity] inside the given [block]
         */
        public fun sender(block: aws.sdk.kotlin.services.chimesdkmessaging.model.Identity.Builder.() -> kotlin.Unit) {
            this.sender = aws.sdk.kotlin.services.chimesdkmessaging.model.Identity.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageStatusStructure] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageStatusStructure.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageStatusStructure.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
