// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmessaging.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Stores information about a callback.
 */
public class ChannelMessageCallback private constructor(builder: Builder) {
    /**
     * The message content. For Amazon Lex V2 bot responses, this field holds a list of messages originating from the bot. For more information, refer to [Processing responses from an AppInstanceBot](https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html) in the *Amazon Chime SDK Messaging Developer Guide*.
     */
    public val content: kotlin.String? = builder.content
    /**
     * The content type of the call-back message. For Amazon Lex V2 bot responses, the content type is `application/amz-chime-lex-msgs` for success responses and `application/amz-chime-lex-error` for failure responses. For more information, refer to [Processing responses from an AppInstanceBot](https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html) in the *Amazon Chime SDK Messaging Developer Guide*.
     */
    public val contentType: kotlin.String? = builder.contentType
    /**
     * The attributes for the channel message. For Amazon Lex V2 bot responses, the attributes are mapped to specific fields from the bot. For more information, refer to [Processing responses from an AppInstanceBot](https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html) in the *Amazon Chime SDK Messaging Developer Guide*.
     */
    public val messageAttributes: Map<String, MessageAttributeValue>? = builder.messageAttributes
    /**
     * The message ID.
     */
    public val messageId: kotlin.String = requireNotNull(builder.messageId) { "A non-null value must be provided for messageId" }
    /**
     * The message metadata.
     */
    public val metadata: kotlin.String? = builder.metadata
    /**
     * The push notification configuration of the message.
     */
    public val pushNotification: aws.sdk.kotlin.services.chimesdkmessaging.model.PushNotificationConfiguration? = builder.pushNotification
    /**
     * The ID of the SubChannel.
     */
    public val subChannelId: kotlin.String? = builder.subChannelId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageCallback = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ChannelMessageCallback(")
        append("content=*** Sensitive Data Redacted ***,")
        append("contentType=*** Sensitive Data Redacted ***,")
        append("messageAttributes=$messageAttributes,")
        append("messageId=$messageId,")
        append("metadata=*** Sensitive Data Redacted ***,")
        append("pushNotification=$pushNotification,")
        append("subChannelId=$subChannelId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = content?.hashCode() ?: 0
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (messageAttributes?.hashCode() ?: 0)
        result = 31 * result + (messageId.hashCode())
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (pushNotification?.hashCode() ?: 0)
        result = 31 * result + (subChannelId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ChannelMessageCallback

        if (content != other.content) return false
        if (contentType != other.contentType) return false
        if (messageAttributes != other.messageAttributes) return false
        if (messageId != other.messageId) return false
        if (metadata != other.metadata) return false
        if (pushNotification != other.pushNotification) return false
        if (subChannelId != other.subChannelId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageCallback = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The message content. For Amazon Lex V2 bot responses, this field holds a list of messages originating from the bot. For more information, refer to [Processing responses from an AppInstanceBot](https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html) in the *Amazon Chime SDK Messaging Developer Guide*.
         */
        public var content: kotlin.String? = null
        /**
         * The content type of the call-back message. For Amazon Lex V2 bot responses, the content type is `application/amz-chime-lex-msgs` for success responses and `application/amz-chime-lex-error` for failure responses. For more information, refer to [Processing responses from an AppInstanceBot](https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html) in the *Amazon Chime SDK Messaging Developer Guide*.
         */
        public var contentType: kotlin.String? = null
        /**
         * The attributes for the channel message. For Amazon Lex V2 bot responses, the attributes are mapped to specific fields from the bot. For more information, refer to [Processing responses from an AppInstanceBot](https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html) in the *Amazon Chime SDK Messaging Developer Guide*.
         */
        public var messageAttributes: Map<String, MessageAttributeValue>? = null
        /**
         * The message ID.
         */
        public var messageId: kotlin.String? = null
        /**
         * The message metadata.
         */
        public var metadata: kotlin.String? = null
        /**
         * The push notification configuration of the message.
         */
        public var pushNotification: aws.sdk.kotlin.services.chimesdkmessaging.model.PushNotificationConfiguration? = null
        /**
         * The ID of the SubChannel.
         */
        public var subChannelId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageCallback) : this() {
            this.content = x.content
            this.contentType = x.contentType
            this.messageAttributes = x.messageAttributes
            this.messageId = x.messageId
            this.metadata = x.metadata
            this.pushNotification = x.pushNotification
            this.subChannelId = x.subChannelId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageCallback = ChannelMessageCallback(this)

        /**
         * construct an [aws.sdk.kotlin.services.chimesdkmessaging.model.PushNotificationConfiguration] inside the given [block]
         */
        public fun pushNotification(block: aws.sdk.kotlin.services.chimesdkmessaging.model.PushNotificationConfiguration.Builder.() -> kotlin.Unit) {
            this.pushNotification = aws.sdk.kotlin.services.chimesdkmessaging.model.PushNotificationConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (messageId == null) messageId = ""
            return this
        }
    }
}
