// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmessaging.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of a message in a channel.
 */
public class ChannelMessage private constructor(builder: Builder) {
    /**
     * The ARN of the channel.
     */
    public val channelArn: kotlin.String? = builder.channelArn
    /**
     * The content of the channel message. For Amazon Lex V2 bot responses, this field holds a list of messages originating from the bot. For more information, refer to [Processing responses from an AppInstanceBot](https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html) in the *Amazon Chime SDK Messaging Developer Guide*.
     */
    public val content: kotlin.String? = builder.content
    /**
     * The content type of the channel message. For Amazon Lex V2 bot responses, the content type is `application/amz-chime-lex-msgs` for success responses and `application/amz-chime-lex-error` for failure responses. For more information, refer to [Processing responses from an AppInstanceBot](https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html) in the *Amazon Chime SDK Messaging Developer Guide*.
     */
    public val contentType: kotlin.String? = builder.contentType
    /**
     * The time at which the message was created.
     */
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * The time at which a message was edited.
     */
    public val lastEditedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastEditedTimestamp
    /**
     * The time at which a message was updated.
     */
    public val lastUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTimestamp
    /**
     * The attributes for the channel message. For Amazon Lex V2 bot responses, the attributes are mapped to specific fields from the bot. For more information, refer to [Processing responses from an AppInstanceBot](https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html) in the *Amazon Chime SDK Messaging Developer Guide*.
     */
    public val messageAttributes: Map<String, MessageAttributeValue>? = builder.messageAttributes
    /**
     * The ID of a message.
     */
    public val messageId: kotlin.String? = builder.messageId
    /**
     * The message metadata.
     */
    public val metadata: kotlin.String? = builder.metadata
    /**
     * The persistence setting for a channel message.
     */
    public val persistence: aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessagePersistenceType? = builder.persistence
    /**
     * Hides the content of a message.
     */
    public val redacted: kotlin.Boolean = builder.redacted
    /**
     * The message sender.
     */
    public val sender: aws.sdk.kotlin.services.chimesdkmessaging.model.Identity? = builder.sender
    /**
     * The status of the channel message.
     */
    public val status: aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageStatusStructure? = builder.status
    /**
     * The ID of the SubChannel.
     */
    public val subChannelId: kotlin.String? = builder.subChannelId
    /**
     * The target of a message, a sender, a user, or a bot. Only the target and the sender can view targeted messages. Only users who can see targeted messages can take actions on them. However, administrators can delete targeted messages that they can’t see.
     */
    public val target: List<Target>? = builder.target
    /**
     * The message type.
     */
    public val type: aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ChannelMessage(")
        append("channelArn=$channelArn,")
        append("content=*** Sensitive Data Redacted ***,")
        append("contentType=*** Sensitive Data Redacted ***,")
        append("createdTimestamp=$createdTimestamp,")
        append("lastEditedTimestamp=$lastEditedTimestamp,")
        append("lastUpdatedTimestamp=$lastUpdatedTimestamp,")
        append("messageAttributes=$messageAttributes,")
        append("messageId=$messageId,")
        append("metadata=*** Sensitive Data Redacted ***,")
        append("persistence=$persistence,")
        append("redacted=$redacted,")
        append("sender=$sender,")
        append("status=$status,")
        append("subChannelId=$subChannelId,")
        append("target=$target,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelArn?.hashCode() ?: 0
        result = 31 * result + (content?.hashCode() ?: 0)
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lastEditedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (messageAttributes?.hashCode() ?: 0)
        result = 31 * result + (messageId?.hashCode() ?: 0)
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (persistence?.hashCode() ?: 0)
        result = 31 * result + (redacted.hashCode())
        result = 31 * result + (sender?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subChannelId?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ChannelMessage

        if (channelArn != other.channelArn) return false
        if (content != other.content) return false
        if (contentType != other.contentType) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (lastEditedTimestamp != other.lastEditedTimestamp) return false
        if (lastUpdatedTimestamp != other.lastUpdatedTimestamp) return false
        if (messageAttributes != other.messageAttributes) return false
        if (messageId != other.messageId) return false
        if (metadata != other.metadata) return false
        if (persistence != other.persistence) return false
        if (redacted != other.redacted) return false
        if (sender != other.sender) return false
        if (status != other.status) return false
        if (subChannelId != other.subChannelId) return false
        if (target != other.target) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessage = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the channel.
         */
        public var channelArn: kotlin.String? = null
        /**
         * The content of the channel message. For Amazon Lex V2 bot responses, this field holds a list of messages originating from the bot. For more information, refer to [Processing responses from an AppInstanceBot](https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html) in the *Amazon Chime SDK Messaging Developer Guide*.
         */
        public var content: kotlin.String? = null
        /**
         * The content type of the channel message. For Amazon Lex V2 bot responses, the content type is `application/amz-chime-lex-msgs` for success responses and `application/amz-chime-lex-error` for failure responses. For more information, refer to [Processing responses from an AppInstanceBot](https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html) in the *Amazon Chime SDK Messaging Developer Guide*.
         */
        public var contentType: kotlin.String? = null
        /**
         * The time at which the message was created.
         */
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time at which a message was edited.
         */
        public var lastEditedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time at which a message was updated.
         */
        public var lastUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The attributes for the channel message. For Amazon Lex V2 bot responses, the attributes are mapped to specific fields from the bot. For more information, refer to [Processing responses from an AppInstanceBot](https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html) in the *Amazon Chime SDK Messaging Developer Guide*.
         */
        public var messageAttributes: Map<String, MessageAttributeValue>? = null
        /**
         * The ID of a message.
         */
        public var messageId: kotlin.String? = null
        /**
         * The message metadata.
         */
        public var metadata: kotlin.String? = null
        /**
         * The persistence setting for a channel message.
         */
        public var persistence: aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessagePersistenceType? = null
        /**
         * Hides the content of a message.
         */
        public var redacted: kotlin.Boolean = false
        /**
         * The message sender.
         */
        public var sender: aws.sdk.kotlin.services.chimesdkmessaging.model.Identity? = null
        /**
         * The status of the channel message.
         */
        public var status: aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageStatusStructure? = null
        /**
         * The ID of the SubChannel.
         */
        public var subChannelId: kotlin.String? = null
        /**
         * The target of a message, a sender, a user, or a bot. Only the target and the sender can view targeted messages. Only users who can see targeted messages can take actions on them. However, administrators can delete targeted messages that they can’t see.
         */
        public var target: List<Target>? = null
        /**
         * The message type.
         */
        public var type: aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessage) : this() {
            this.channelArn = x.channelArn
            this.content = x.content
            this.contentType = x.contentType
            this.createdTimestamp = x.createdTimestamp
            this.lastEditedTimestamp = x.lastEditedTimestamp
            this.lastUpdatedTimestamp = x.lastUpdatedTimestamp
            this.messageAttributes = x.messageAttributes
            this.messageId = x.messageId
            this.metadata = x.metadata
            this.persistence = x.persistence
            this.redacted = x.redacted
            this.sender = x.sender
            this.status = x.status
            this.subChannelId = x.subChannelId
            this.target = x.target
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessage = ChannelMessage(this)

        /**
         * construct an [aws.sdk.kotlin.services.chimesdkmessaging.model.Identity] inside the given [block]
         */
        public fun sender(block: aws.sdk.kotlin.services.chimesdkmessaging.model.Identity.Builder.() -> kotlin.Unit) {
            this.sender = aws.sdk.kotlin.services.chimesdkmessaging.model.Identity.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageStatusStructure] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageStatusStructure.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageStatusStructure.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
