// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmessaging

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.chimesdkmessaging.auth.ChimeSdkMessagingAuthSchemeProvider
import aws.sdk.kotlin.services.chimesdkmessaging.auth.DefaultChimeSdkMessagingAuthSchemeProvider
import aws.sdk.kotlin.services.chimesdkmessaging.endpoints.ChimeSdkMessagingEndpointParameters
import aws.sdk.kotlin.services.chimesdkmessaging.endpoints.ChimeSdkMessagingEndpointProvider
import aws.sdk.kotlin.services.chimesdkmessaging.endpoints.DefaultChimeSdkMessagingEndpointProvider
import aws.sdk.kotlin.services.chimesdkmessaging.model.AssociateChannelFlowRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.AssociateChannelFlowResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.BatchCreateChannelMembershipRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.BatchCreateChannelMembershipResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelFlowCallbackRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelFlowCallbackResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.CreateChannelBanRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.CreateChannelBanResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.CreateChannelFlowRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.CreateChannelFlowResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.CreateChannelMembershipRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.CreateChannelMembershipResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.CreateChannelModeratorRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.CreateChannelModeratorResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.CreateChannelRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.CreateChannelResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.DeleteChannelBanRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.DeleteChannelBanResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.DeleteChannelFlowRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.DeleteChannelFlowResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.DeleteChannelMembershipRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.DeleteChannelMembershipResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.DeleteChannelMessageRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.DeleteChannelMessageResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.DeleteChannelModeratorRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.DeleteChannelModeratorResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.DeleteChannelRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.DeleteChannelResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.DeleteMessagingStreamingConfigurationsRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.DeleteMessagingStreamingConfigurationsResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.DescribeChannelBanRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.DescribeChannelBanResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.DescribeChannelFlowRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.DescribeChannelFlowResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.DescribeChannelMembershipRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.DescribeChannelMembershipResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.DescribeChannelModeratedByAppInstanceUserRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.DescribeChannelModeratedByAppInstanceUserResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.DescribeChannelModeratorRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.DescribeChannelModeratorResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.DescribeChannelRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.DescribeChannelResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.DisassociateChannelFlowRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.DisassociateChannelFlowResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.GetChannelMembershipPreferencesRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.GetChannelMembershipPreferencesResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.GetChannelMessageRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.GetChannelMessageResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.GetChannelMessageStatusRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.GetChannelMessageStatusResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.GetMessagingSessionEndpointRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.GetMessagingSessionEndpointResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.GetMessagingStreamingConfigurationsRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.GetMessagingStreamingConfigurationsResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelBansRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelBansResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelFlowsRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelFlowsResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelMembershipsRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelMembershipsResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelMessagesRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelMessagesResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelModeratorsRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelModeratorsResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelsRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelsResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListSubChannelsRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListSubChannelsResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.PutChannelExpirationSettingsRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.PutChannelExpirationSettingsResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.PutChannelMembershipPreferencesRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.PutChannelMembershipPreferencesResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.PutMessagingStreamingConfigurationsRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.PutMessagingStreamingConfigurationsResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.RedactChannelMessageRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.RedactChannelMessageResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.SearchChannelsRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.SearchChannelsResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.SendChannelMessageRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.SendChannelMessageResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.TagResourceRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.TagResourceResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.UntagResourceRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.UntagResourceResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.UpdateChannelFlowRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.UpdateChannelFlowResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.UpdateChannelMessageRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.UpdateChannelMessageResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.UpdateChannelReadMarkerRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.UpdateChannelReadMarkerResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.UpdateChannelRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.UpdateChannelResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Chime SDK Messaging"
public const val SdkVersion: String = "1.2.9"
public const val ServiceApiVersion: String = "2021-05-15"

/**
 * The Amazon Chime SDK messaging APIs in this section allow software developers to send and receive messages in custom messaging applications. These APIs depend on the frameworks provided by the Amazon Chime SDK identity APIs. For more information about the messaging APIs, see [Amazon Chime SDK messaging](https://docs.aws.amazon.com/chime/latest/APIReference/API_Operations_Amazon_Chime_SDK_Messaging.html).
 */
public interface ChimeSdkMessagingClient : SdkClient {
    /**
     * ChimeSdkMessagingClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ChimeSdkMessagingClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "ChimeSdkMessaging",
                "CHIME_SDK_MESSAGING",
                "chime_sdk_messaging",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ChimeSdkMessagingClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ChimeSdkMessagingClient = DefaultChimeSdkMessagingClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: ChimeSdkMessagingEndpointProvider = builder.endpointProvider ?: DefaultChimeSdkMessagingEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: ChimeSdkMessagingAuthSchemeProvider = builder.authSchemeProvider ?: DefaultChimeSdkMessagingAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Chime SDK Messaging"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: ChimeSdkMessagingEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: ChimeSdkMessagingAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a channel flow with a channel. Once associated, all messages to that channel go through channel flow processors. To stop processing, use the `DisassociateChannelFlow` API.
     *
     * Only administrators or channel moderators can associate a channel flow. The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun associateChannelFlow(input: AssociateChannelFlowRequest): AssociateChannelFlowResponse

    /**
     * Adds a specified number of users and bots to a channel.
     */
    public suspend fun batchCreateChannelMembership(input: BatchCreateChannelMembershipRequest): BatchCreateChannelMembershipResponse

    /**
     * Calls back Amazon Chime SDK messaging with a processing response message. This should be invoked from the processor Lambda. This is a developer API.
     *
     * You can return one of the following processing responses:
     * + Update message content or metadata
     * + Deny a message
     * + Make no changes to the message
     */
    public suspend fun channelFlowCallback(input: ChannelFlowCallbackRequest): ChannelFlowCallbackResponse

    /**
     * Creates a channel to which you can add users and send messages.
     *
     * **Restriction**: You can't change a channel's privacy.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun createChannel(input: CreateChannelRequest): CreateChannelResponse

    /**
     * Permanently bans a member from a channel. Moderators can't add banned members to a channel. To undo a ban, you first have to `DeleteChannelBan`, and then `CreateChannelMembership`. Bans are cleaned up when you delete users or channels.
     *
     * If you ban a user who is already part of a channel, that user is automatically kicked from the channel.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun createChannelBan(input: CreateChannelBanRequest): CreateChannelBanResponse

    /**
     * Creates a channel flow, a container for processors. Processors are AWS Lambda functions that perform actions on chat messages, such as stripping out profanity. You can associate channel flows with channels, and the processors in the channel flow then take action on all messages sent to that channel. This is a developer API.
     *
     * Channel flows process the following items:
     * + New and updated messages
     * + Persistent and non-persistent messages
     * + The Standard message type
     *
     * Channel flows don't process Control or System messages. For more information about the message types provided by Chime SDK messaging, refer to [Message types](https://docs.aws.amazon.com/chime/latest/dg/using-the-messaging-sdk.html#msg-types) in the *Amazon Chime developer guide*.
     */
    public suspend fun createChannelFlow(input: CreateChannelFlowRequest): CreateChannelFlowResponse

    /**
     * Adds a member to a channel. The `InvitedBy` field in `ChannelMembership` is derived from the request header. A channel member can:
     * + List messages
     * + Send messages
     * + Receive messages
     * + Edit their own messages
     * + Leave the channel
     *
     * Privacy settings impact this action as follows:
     * + Public Channels: You do not need to be a member to list messages, but you must be a member to send messages.
     * + Private Channels: You must be a member to list or send messages.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUserArn` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun createChannelMembership(input: CreateChannelMembershipRequest): CreateChannelMembershipResponse

    /**
     * Creates a new `ChannelModerator`. A channel moderator can:
     * + Add and remove other members of the channel.
     * + Add and remove other moderators of the channel.
     * + Add and remove user bans for the channel.
     * + Redact messages in the channel.
     * + List messages in the channel.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot`of the user that makes the API call as the value in the header.
     */
    public suspend fun createChannelModerator(input: CreateChannelModeratorRequest): CreateChannelModeratorResponse

    /**
     * Immediately makes a channel and its memberships inaccessible and marks them for deletion. This is an irreversible process.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUserArn` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun deleteChannel(input: DeleteChannelRequest): DeleteChannelResponse

    /**
     * Removes a member from a channel's ban list.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun deleteChannelBan(input: DeleteChannelBanRequest): DeleteChannelBanResponse

    /**
     * Deletes a channel flow, an irreversible process. This is a developer API.
     *
     *  This API works only when the channel flow is not associated with any channel. To get a list of all channels that a channel flow is associated with, use the `ListChannelsAssociatedWithChannelFlow` API. Use the `DisassociateChannelFlow` API to disassociate a channel flow from all channels.
     */
    public suspend fun deleteChannelFlow(input: DeleteChannelFlowRequest): DeleteChannelFlowResponse

    /**
     * Removes a member from a channel.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun deleteChannelMembership(input: DeleteChannelMembershipRequest): DeleteChannelMembershipResponse

    /**
     * Deletes a channel message. Only admins can perform this action. Deletion makes messages inaccessible immediately. A background process deletes any revisions created by `UpdateChannelMessage`.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun deleteChannelMessage(input: DeleteChannelMessageRequest): DeleteChannelMessageResponse

    /**
     * Deletes a channel moderator.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun deleteChannelModerator(input: DeleteChannelModeratorRequest): DeleteChannelModeratorResponse

    /**
     * Deletes the streaming configurations for an `AppInstance`. For more information, see [Streaming messaging data](https://docs.aws.amazon.com/chime-sdk/latest/dg/streaming-export.html) in the *Amazon Chime SDK Developer Guide*.
     */
    public suspend fun deleteMessagingStreamingConfigurations(input: DeleteMessagingStreamingConfigurationsRequest): DeleteMessagingStreamingConfigurationsResponse

    /**
     * Returns the full details of a channel in an Amazon Chime `AppInstance`.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun describeChannel(input: DescribeChannelRequest): DescribeChannelResponse

    /**
     * Returns the full details of a channel ban.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun describeChannelBan(input: DescribeChannelBanRequest): DescribeChannelBanResponse

    /**
     * Returns the full details of a channel flow in an Amazon Chime `AppInstance`. This is a developer API.
     */
    public suspend fun describeChannelFlow(input: DescribeChannelFlowRequest): DescribeChannelFlowResponse

    /**
     * Returns the full details of a user's channel membership.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun describeChannelMembership(input: DescribeChannelMembershipRequest): DescribeChannelMembershipResponse

    /**
     * Returns the details of a channel based on the membership of the specified `AppInstanceUser` or `AppInstanceBot`.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun describeChannelMembershipForAppInstanceUser(input: DescribeChannelMembershipForAppInstanceUserRequest): DescribeChannelMembershipForAppInstanceUserResponse

    /**
     * Returns the full details of a channel moderated by the specified `AppInstanceUser` or `AppInstanceBot`.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun describeChannelModeratedByAppInstanceUser(input: DescribeChannelModeratedByAppInstanceUserRequest): DescribeChannelModeratedByAppInstanceUserResponse

    /**
     * Returns the full details of a single ChannelModerator.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun describeChannelModerator(input: DescribeChannelModeratorRequest): DescribeChannelModeratorResponse

    /**
     * Disassociates a channel flow from all its channels. Once disassociated, all messages to that channel stop going through the channel flow processor.
     *
     * Only administrators or channel moderators can disassociate a channel flow.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun disassociateChannelFlow(input: DisassociateChannelFlowRequest): DisassociateChannelFlowResponse

    /**
     * Gets the membership preferences of an `AppInstanceUser` or `AppInstanceBot` for the specified channel. A user or a bot must be a member of the channel and own the membership in order to retrieve membership preferences. Users or bots in the `AppInstanceAdmin` and channel moderator roles can't retrieve preferences for other users or bots. Banned users or bots can't retrieve membership preferences for the channel from which they are banned.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun getChannelMembershipPreferences(input: GetChannelMembershipPreferencesRequest): GetChannelMembershipPreferencesResponse

    /**
     * Gets the full details of a channel message.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun getChannelMessage(input: GetChannelMessageRequest): GetChannelMessageResponse

    /**
     * Gets message status for a specified `messageId`. Use this API to determine the intermediate status of messages going through channel flow processing. The API provides an alternative to retrieving message status if the event was not received because a client wasn't connected to a websocket.
     *
     * Messages can have any one of these statuses.
     *
     * ## SENT
     * Message processed successfully
     *
     * ## PENDING
     * Ongoing processing
     *
     * ## FAILED
     * Processing failed
     *
     * ## DENIED
     * Message denied by the processor
     *
     * + This API does not return statuses for denied messages, because we don't store them once the processor denies them.
     * + Only the message sender can invoke this API.
     * + The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun getChannelMessageStatus(input: GetChannelMessageStatusRequest): GetChannelMessageStatusResponse

    /**
     * The details of the endpoint for the messaging session.
     */
    public suspend fun getMessagingSessionEndpoint(input: GetMessagingSessionEndpointRequest = GetMessagingSessionEndpointRequest { }): GetMessagingSessionEndpointResponse

    /**
     * Retrieves the data streaming configuration for an `AppInstance`. For more information, see [Streaming messaging data](https://docs.aws.amazon.com/chime-sdk/latest/dg/streaming-export.html) in the *Amazon Chime SDK Developer Guide*.
     */
    public suspend fun getMessagingStreamingConfigurations(input: GetMessagingStreamingConfigurationsRequest): GetMessagingStreamingConfigurationsResponse

    /**
     * Lists all the users and bots banned from a particular channel.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun listChannelBans(input: ListChannelBansRequest): ListChannelBansResponse

    /**
     * Returns a paginated lists of all the channel flows created under a single Chime. This is a developer API.
     */
    public suspend fun listChannelFlows(input: ListChannelFlowsRequest): ListChannelFlowsResponse

    /**
     * Lists all channel memberships in a channel.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     *
     * If you want to list the channels to which a specific app instance user belongs, see the [ListChannelMembershipsForAppInstanceUser](https://docs.aws.amazon.com/chime/latest/APIReference/API_messaging-chime_ListChannelMembershipsForAppInstanceUser.html) API.
     */
    public suspend fun listChannelMemberships(input: ListChannelMembershipsRequest): ListChannelMembershipsResponse

    /**
     * Lists all channels that an `AppInstanceUser` or `AppInstanceBot` is a part of. Only an `AppInstanceAdmin` can call the API with a user ARN that is not their own.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun listChannelMembershipsForAppInstanceUser(input: ListChannelMembershipsForAppInstanceUserRequest): ListChannelMembershipsForAppInstanceUserResponse

    /**
     * List all the messages in a channel. Returns a paginated list of `ChannelMessages`. By default, sorted by creation timestamp in descending order.
     *
     * Redacted messages appear in the results as empty, since they are only redacted, not deleted. Deleted messages do not appear in the results. This action always returns the latest version of an edited message.
     *
     * Also, the `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun listChannelMessages(input: ListChannelMessagesRequest): ListChannelMessagesResponse

    /**
     * Lists all the moderators for a channel.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun listChannelModerators(input: ListChannelModeratorsRequest): ListChannelModeratorsResponse

    /**
     * Lists all Channels created under a single Chime App as a paginated list. You can specify filters to narrow results.
     *
     * **Functionality & restrictions**
     * + Use privacy = `PUBLIC` to retrieve all public channels in the account.
     * + Only an `AppInstanceAdmin` can set privacy = `PRIVATE` to list the private channels in an account.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun listChannels(input: ListChannelsRequest): ListChannelsResponse

    /**
     * Lists all channels associated with a specified channel flow. You can associate a channel flow with multiple channels, but you can only associate a channel with one channel flow. This is a developer API.
     */
    public suspend fun listChannelsAssociatedWithChannelFlow(input: ListChannelsAssociatedWithChannelFlowRequest): ListChannelsAssociatedWithChannelFlowResponse

    /**
     * A list of the channels moderated by an `AppInstanceUser`.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun listChannelsModeratedByAppInstanceUser(input: ListChannelsModeratedByAppInstanceUserRequest): ListChannelsModeratedByAppInstanceUserResponse

    /**
     * Lists all the SubChannels in an elastic channel when given a channel ID. Available only to the app instance admins and channel moderators of elastic channels.
     */
    public suspend fun listSubChannels(input: ListSubChannelsRequest): ListSubChannelsResponse

    /**
     * Lists the tags applied to an Amazon Chime SDK messaging resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Sets the number of days before the channel is automatically deleted.
     *
     * + A background process deletes expired channels within 6 hours of expiration. Actual deletion times may vary.
     * + Expired channels that have not yet been deleted appear as active, and you can update their expiration settings. The system honors the new settings.
     * + The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun putChannelExpirationSettings(input: PutChannelExpirationSettingsRequest): PutChannelExpirationSettingsResponse

    /**
     * Sets the membership preferences of an `AppInstanceUser` or `AppInstanceBot` for the specified channel. The user or bot must be a member of the channel. Only the user or bot who owns the membership can set preferences. Users or bots in the `AppInstanceAdmin` and channel moderator roles can't set preferences for other users. Banned users or bots can't set membership preferences for the channel from which they are banned.
     *
     * The x-amz-chime-bearer request header is mandatory. Use the ARN of an `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun putChannelMembershipPreferences(input: PutChannelMembershipPreferencesRequest): PutChannelMembershipPreferencesResponse

    /**
     * Sets the data streaming configuration for an `AppInstance`. For more information, see [Streaming messaging data](https://docs.aws.amazon.com/chime-sdk/latest/dg/streaming-export.html) in the *Amazon Chime SDK Developer Guide*.
     */
    public suspend fun putMessagingStreamingConfigurations(input: PutMessagingStreamingConfigurationsRequest): PutMessagingStreamingConfigurationsResponse

    /**
     * Redacts message content, but not metadata. The message exists in the back end, but the action returns null content, and the state shows as redacted.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun redactChannelMessage(input: RedactChannelMessageRequest): RedactChannelMessageResponse

    /**
     * Allows the `ChimeBearer` to search channels by channel members. Users or bots can search across the channels that they belong to. Users in the `AppInstanceAdmin` role can search across all channels.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun searchChannels(input: SearchChannelsRequest): SearchChannelsResponse

    /**
     * Sends a message to a particular channel that the member is a part of.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     *
     * Also, `STANDARD` messages can be up to 4KB in size and contain metadata. Metadata is arbitrary, and you can use it in a variety of ways, such as containing a link to an attachment.
     *
     * `CONTROL` messages are limited to 30 bytes and do not contain metadata.
     */
    public suspend fun sendChannelMessage(input: SendChannelMessageRequest): SendChannelMessageResponse

    /**
     * Applies the specified tags to the specified Amazon Chime SDK messaging resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the specified tags from the specified Amazon Chime SDK messaging resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Update a channel's attributes.
     *
     * **Restriction**: You can't change a channel's privacy.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun updateChannel(input: UpdateChannelRequest): UpdateChannelResponse

    /**
     * Updates channel flow attributes. This is a developer API.
     */
    public suspend fun updateChannelFlow(input: UpdateChannelFlowRequest): UpdateChannelFlowResponse

    /**
     * Updates the content of a message.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun updateChannelMessage(input: UpdateChannelMessageRequest): UpdateChannelMessageResponse

    /**
     * The details of the time when a user last read messages in a channel.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
     */
    public suspend fun updateChannelReadMarker(input: UpdateChannelReadMarkerRequest): UpdateChannelReadMarkerResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ChimeSdkMessagingClient.withConfig(block: ChimeSdkMessagingClient.Config.Builder.() -> Unit): ChimeSdkMessagingClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultChimeSdkMessagingClient(newConfig)
}

/**
 * Associates a channel flow with a channel. Once associated, all messages to that channel go through channel flow processors. To stop processing, use the `DisassociateChannelFlow` API.
 *
 * Only administrators or channel moderators can associate a channel flow. The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.associateChannelFlow(crossinline block: AssociateChannelFlowRequest.Builder.() -> Unit): AssociateChannelFlowResponse = associateChannelFlow(AssociateChannelFlowRequest.Builder().apply(block).build())

/**
 * Adds a specified number of users and bots to a channel.
 */
public suspend inline fun ChimeSdkMessagingClient.batchCreateChannelMembership(crossinline block: BatchCreateChannelMembershipRequest.Builder.() -> Unit): BatchCreateChannelMembershipResponse = batchCreateChannelMembership(BatchCreateChannelMembershipRequest.Builder().apply(block).build())

/**
 * Calls back Amazon Chime SDK messaging with a processing response message. This should be invoked from the processor Lambda. This is a developer API.
 *
 * You can return one of the following processing responses:
 * + Update message content or metadata
 * + Deny a message
 * + Make no changes to the message
 */
public suspend inline fun ChimeSdkMessagingClient.channelFlowCallback(crossinline block: ChannelFlowCallbackRequest.Builder.() -> Unit): ChannelFlowCallbackResponse = channelFlowCallback(ChannelFlowCallbackRequest.Builder().apply(block).build())

/**
 * Creates a channel to which you can add users and send messages.
 *
 * **Restriction**: You can't change a channel's privacy.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.createChannel(crossinline block: CreateChannelRequest.Builder.() -> Unit): CreateChannelResponse = createChannel(CreateChannelRequest.Builder().apply(block).build())

/**
 * Permanently bans a member from a channel. Moderators can't add banned members to a channel. To undo a ban, you first have to `DeleteChannelBan`, and then `CreateChannelMembership`. Bans are cleaned up when you delete users or channels.
 *
 * If you ban a user who is already part of a channel, that user is automatically kicked from the channel.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.createChannelBan(crossinline block: CreateChannelBanRequest.Builder.() -> Unit): CreateChannelBanResponse = createChannelBan(CreateChannelBanRequest.Builder().apply(block).build())

/**
 * Creates a channel flow, a container for processors. Processors are AWS Lambda functions that perform actions on chat messages, such as stripping out profanity. You can associate channel flows with channels, and the processors in the channel flow then take action on all messages sent to that channel. This is a developer API.
 *
 * Channel flows process the following items:
 * + New and updated messages
 * + Persistent and non-persistent messages
 * + The Standard message type
 *
 * Channel flows don't process Control or System messages. For more information about the message types provided by Chime SDK messaging, refer to [Message types](https://docs.aws.amazon.com/chime/latest/dg/using-the-messaging-sdk.html#msg-types) in the *Amazon Chime developer guide*.
 */
public suspend inline fun ChimeSdkMessagingClient.createChannelFlow(crossinline block: CreateChannelFlowRequest.Builder.() -> Unit): CreateChannelFlowResponse = createChannelFlow(CreateChannelFlowRequest.Builder().apply(block).build())

/**
 * Adds a member to a channel. The `InvitedBy` field in `ChannelMembership` is derived from the request header. A channel member can:
 * + List messages
 * + Send messages
 * + Receive messages
 * + Edit their own messages
 * + Leave the channel
 *
 * Privacy settings impact this action as follows:
 * + Public Channels: You do not need to be a member to list messages, but you must be a member to send messages.
 * + Private Channels: You must be a member to list or send messages.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUserArn` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.createChannelMembership(crossinline block: CreateChannelMembershipRequest.Builder.() -> Unit): CreateChannelMembershipResponse = createChannelMembership(CreateChannelMembershipRequest.Builder().apply(block).build())

/**
 * Creates a new `ChannelModerator`. A channel moderator can:
 * + Add and remove other members of the channel.
 * + Add and remove other moderators of the channel.
 * + Add and remove user bans for the channel.
 * + Redact messages in the channel.
 * + List messages in the channel.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot`of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.createChannelModerator(crossinline block: CreateChannelModeratorRequest.Builder.() -> Unit): CreateChannelModeratorResponse = createChannelModerator(CreateChannelModeratorRequest.Builder().apply(block).build())

/**
 * Immediately makes a channel and its memberships inaccessible and marks them for deletion. This is an irreversible process.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUserArn` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.deleteChannel(crossinline block: DeleteChannelRequest.Builder.() -> Unit): DeleteChannelResponse = deleteChannel(DeleteChannelRequest.Builder().apply(block).build())

/**
 * Removes a member from a channel's ban list.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.deleteChannelBan(crossinline block: DeleteChannelBanRequest.Builder.() -> Unit): DeleteChannelBanResponse = deleteChannelBan(DeleteChannelBanRequest.Builder().apply(block).build())

/**
 * Deletes a channel flow, an irreversible process. This is a developer API.
 *
 *  This API works only when the channel flow is not associated with any channel. To get a list of all channels that a channel flow is associated with, use the `ListChannelsAssociatedWithChannelFlow` API. Use the `DisassociateChannelFlow` API to disassociate a channel flow from all channels.
 */
public suspend inline fun ChimeSdkMessagingClient.deleteChannelFlow(crossinline block: DeleteChannelFlowRequest.Builder.() -> Unit): DeleteChannelFlowResponse = deleteChannelFlow(DeleteChannelFlowRequest.Builder().apply(block).build())

/**
 * Removes a member from a channel.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.deleteChannelMembership(crossinline block: DeleteChannelMembershipRequest.Builder.() -> Unit): DeleteChannelMembershipResponse = deleteChannelMembership(DeleteChannelMembershipRequest.Builder().apply(block).build())

/**
 * Deletes a channel message. Only admins can perform this action. Deletion makes messages inaccessible immediately. A background process deletes any revisions created by `UpdateChannelMessage`.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.deleteChannelMessage(crossinline block: DeleteChannelMessageRequest.Builder.() -> Unit): DeleteChannelMessageResponse = deleteChannelMessage(DeleteChannelMessageRequest.Builder().apply(block).build())

/**
 * Deletes a channel moderator.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.deleteChannelModerator(crossinline block: DeleteChannelModeratorRequest.Builder.() -> Unit): DeleteChannelModeratorResponse = deleteChannelModerator(DeleteChannelModeratorRequest.Builder().apply(block).build())

/**
 * Deletes the streaming configurations for an `AppInstance`. For more information, see [Streaming messaging data](https://docs.aws.amazon.com/chime-sdk/latest/dg/streaming-export.html) in the *Amazon Chime SDK Developer Guide*.
 */
public suspend inline fun ChimeSdkMessagingClient.deleteMessagingStreamingConfigurations(crossinline block: DeleteMessagingStreamingConfigurationsRequest.Builder.() -> Unit): DeleteMessagingStreamingConfigurationsResponse = deleteMessagingStreamingConfigurations(DeleteMessagingStreamingConfigurationsRequest.Builder().apply(block).build())

/**
 * Returns the full details of a channel in an Amazon Chime `AppInstance`.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.describeChannel(crossinline block: DescribeChannelRequest.Builder.() -> Unit): DescribeChannelResponse = describeChannel(DescribeChannelRequest.Builder().apply(block).build())

/**
 * Returns the full details of a channel ban.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.describeChannelBan(crossinline block: DescribeChannelBanRequest.Builder.() -> Unit): DescribeChannelBanResponse = describeChannelBan(DescribeChannelBanRequest.Builder().apply(block).build())

/**
 * Returns the full details of a channel flow in an Amazon Chime `AppInstance`. This is a developer API.
 */
public suspend inline fun ChimeSdkMessagingClient.describeChannelFlow(crossinline block: DescribeChannelFlowRequest.Builder.() -> Unit): DescribeChannelFlowResponse = describeChannelFlow(DescribeChannelFlowRequest.Builder().apply(block).build())

/**
 * Returns the full details of a user's channel membership.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.describeChannelMembership(crossinline block: DescribeChannelMembershipRequest.Builder.() -> Unit): DescribeChannelMembershipResponse = describeChannelMembership(DescribeChannelMembershipRequest.Builder().apply(block).build())

/**
 * Returns the details of a channel based on the membership of the specified `AppInstanceUser` or `AppInstanceBot`.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.describeChannelMembershipForAppInstanceUser(crossinline block: DescribeChannelMembershipForAppInstanceUserRequest.Builder.() -> Unit): DescribeChannelMembershipForAppInstanceUserResponse = describeChannelMembershipForAppInstanceUser(DescribeChannelMembershipForAppInstanceUserRequest.Builder().apply(block).build())

/**
 * Returns the full details of a channel moderated by the specified `AppInstanceUser` or `AppInstanceBot`.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.describeChannelModeratedByAppInstanceUser(crossinline block: DescribeChannelModeratedByAppInstanceUserRequest.Builder.() -> Unit): DescribeChannelModeratedByAppInstanceUserResponse = describeChannelModeratedByAppInstanceUser(DescribeChannelModeratedByAppInstanceUserRequest.Builder().apply(block).build())

/**
 * Returns the full details of a single ChannelModerator.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.describeChannelModerator(crossinline block: DescribeChannelModeratorRequest.Builder.() -> Unit): DescribeChannelModeratorResponse = describeChannelModerator(DescribeChannelModeratorRequest.Builder().apply(block).build())

/**
 * Disassociates a channel flow from all its channels. Once disassociated, all messages to that channel stop going through the channel flow processor.
 *
 * Only administrators or channel moderators can disassociate a channel flow.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.disassociateChannelFlow(crossinline block: DisassociateChannelFlowRequest.Builder.() -> Unit): DisassociateChannelFlowResponse = disassociateChannelFlow(DisassociateChannelFlowRequest.Builder().apply(block).build())

/**
 * Gets the membership preferences of an `AppInstanceUser` or `AppInstanceBot` for the specified channel. A user or a bot must be a member of the channel and own the membership in order to retrieve membership preferences. Users or bots in the `AppInstanceAdmin` and channel moderator roles can't retrieve preferences for other users or bots. Banned users or bots can't retrieve membership preferences for the channel from which they are banned.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.getChannelMembershipPreferences(crossinline block: GetChannelMembershipPreferencesRequest.Builder.() -> Unit): GetChannelMembershipPreferencesResponse = getChannelMembershipPreferences(GetChannelMembershipPreferencesRequest.Builder().apply(block).build())

/**
 * Gets the full details of a channel message.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.getChannelMessage(crossinline block: GetChannelMessageRequest.Builder.() -> Unit): GetChannelMessageResponse = getChannelMessage(GetChannelMessageRequest.Builder().apply(block).build())

/**
 * Gets message status for a specified `messageId`. Use this API to determine the intermediate status of messages going through channel flow processing. The API provides an alternative to retrieving message status if the event was not received because a client wasn't connected to a websocket.
 *
 * Messages can have any one of these statuses.
 *
 * ## SENT
 * Message processed successfully
 *
 * ## PENDING
 * Ongoing processing
 *
 * ## FAILED
 * Processing failed
 *
 * ## DENIED
 * Message denied by the processor
 *
 * + This API does not return statuses for denied messages, because we don't store them once the processor denies them.
 * + Only the message sender can invoke this API.
 * + The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.getChannelMessageStatus(crossinline block: GetChannelMessageStatusRequest.Builder.() -> Unit): GetChannelMessageStatusResponse = getChannelMessageStatus(GetChannelMessageStatusRequest.Builder().apply(block).build())

/**
 * The details of the endpoint for the messaging session.
 */
public suspend inline fun ChimeSdkMessagingClient.getMessagingSessionEndpoint(crossinline block: GetMessagingSessionEndpointRequest.Builder.() -> Unit): GetMessagingSessionEndpointResponse = getMessagingSessionEndpoint(GetMessagingSessionEndpointRequest.Builder().apply(block).build())

/**
 * Retrieves the data streaming configuration for an `AppInstance`. For more information, see [Streaming messaging data](https://docs.aws.amazon.com/chime-sdk/latest/dg/streaming-export.html) in the *Amazon Chime SDK Developer Guide*.
 */
public suspend inline fun ChimeSdkMessagingClient.getMessagingStreamingConfigurations(crossinline block: GetMessagingStreamingConfigurationsRequest.Builder.() -> Unit): GetMessagingStreamingConfigurationsResponse = getMessagingStreamingConfigurations(GetMessagingStreamingConfigurationsRequest.Builder().apply(block).build())

/**
 * Lists all the users and bots banned from a particular channel.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.listChannelBans(crossinline block: ListChannelBansRequest.Builder.() -> Unit): ListChannelBansResponse = listChannelBans(ListChannelBansRequest.Builder().apply(block).build())

/**
 * Returns a paginated lists of all the channel flows created under a single Chime. This is a developer API.
 */
public suspend inline fun ChimeSdkMessagingClient.listChannelFlows(crossinline block: ListChannelFlowsRequest.Builder.() -> Unit): ListChannelFlowsResponse = listChannelFlows(ListChannelFlowsRequest.Builder().apply(block).build())

/**
 * Lists all channel memberships in a channel.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 *
 * If you want to list the channels to which a specific app instance user belongs, see the [ListChannelMembershipsForAppInstanceUser](https://docs.aws.amazon.com/chime/latest/APIReference/API_messaging-chime_ListChannelMembershipsForAppInstanceUser.html) API.
 */
public suspend inline fun ChimeSdkMessagingClient.listChannelMemberships(crossinline block: ListChannelMembershipsRequest.Builder.() -> Unit): ListChannelMembershipsResponse = listChannelMemberships(ListChannelMembershipsRequest.Builder().apply(block).build())

/**
 * Lists all channels that an `AppInstanceUser` or `AppInstanceBot` is a part of. Only an `AppInstanceAdmin` can call the API with a user ARN that is not their own.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.listChannelMembershipsForAppInstanceUser(crossinline block: ListChannelMembershipsForAppInstanceUserRequest.Builder.() -> Unit): ListChannelMembershipsForAppInstanceUserResponse = listChannelMembershipsForAppInstanceUser(ListChannelMembershipsForAppInstanceUserRequest.Builder().apply(block).build())

/**
 * List all the messages in a channel. Returns a paginated list of `ChannelMessages`. By default, sorted by creation timestamp in descending order.
 *
 * Redacted messages appear in the results as empty, since they are only redacted, not deleted. Deleted messages do not appear in the results. This action always returns the latest version of an edited message.
 *
 * Also, the `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.listChannelMessages(crossinline block: ListChannelMessagesRequest.Builder.() -> Unit): ListChannelMessagesResponse = listChannelMessages(ListChannelMessagesRequest.Builder().apply(block).build())

/**
 * Lists all the moderators for a channel.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.listChannelModerators(crossinline block: ListChannelModeratorsRequest.Builder.() -> Unit): ListChannelModeratorsResponse = listChannelModerators(ListChannelModeratorsRequest.Builder().apply(block).build())

/**
 * Lists all Channels created under a single Chime App as a paginated list. You can specify filters to narrow results.
 *
 * **Functionality & restrictions**
 * + Use privacy = `PUBLIC` to retrieve all public channels in the account.
 * + Only an `AppInstanceAdmin` can set privacy = `PRIVATE` to list the private channels in an account.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.listChannels(crossinline block: ListChannelsRequest.Builder.() -> Unit): ListChannelsResponse = listChannels(ListChannelsRequest.Builder().apply(block).build())

/**
 * Lists all channels associated with a specified channel flow. You can associate a channel flow with multiple channels, but you can only associate a channel with one channel flow. This is a developer API.
 */
public suspend inline fun ChimeSdkMessagingClient.listChannelsAssociatedWithChannelFlow(crossinline block: ListChannelsAssociatedWithChannelFlowRequest.Builder.() -> Unit): ListChannelsAssociatedWithChannelFlowResponse = listChannelsAssociatedWithChannelFlow(ListChannelsAssociatedWithChannelFlowRequest.Builder().apply(block).build())

/**
 * A list of the channels moderated by an `AppInstanceUser`.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.listChannelsModeratedByAppInstanceUser(crossinline block: ListChannelsModeratedByAppInstanceUserRequest.Builder.() -> Unit): ListChannelsModeratedByAppInstanceUserResponse = listChannelsModeratedByAppInstanceUser(ListChannelsModeratedByAppInstanceUserRequest.Builder().apply(block).build())

/**
 * Lists all the SubChannels in an elastic channel when given a channel ID. Available only to the app instance admins and channel moderators of elastic channels.
 */
public suspend inline fun ChimeSdkMessagingClient.listSubChannels(crossinline block: ListSubChannelsRequest.Builder.() -> Unit): ListSubChannelsResponse = listSubChannels(ListSubChannelsRequest.Builder().apply(block).build())

/**
 * Lists the tags applied to an Amazon Chime SDK messaging resource.
 */
public suspend inline fun ChimeSdkMessagingClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Sets the number of days before the channel is automatically deleted.
 *
 * + A background process deletes expired channels within 6 hours of expiration. Actual deletion times may vary.
 * + Expired channels that have not yet been deleted appear as active, and you can update their expiration settings. The system honors the new settings.
 * + The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.putChannelExpirationSettings(crossinline block: PutChannelExpirationSettingsRequest.Builder.() -> Unit): PutChannelExpirationSettingsResponse = putChannelExpirationSettings(PutChannelExpirationSettingsRequest.Builder().apply(block).build())

/**
 * Sets the membership preferences of an `AppInstanceUser` or `AppInstanceBot` for the specified channel. The user or bot must be a member of the channel. Only the user or bot who owns the membership can set preferences. Users or bots in the `AppInstanceAdmin` and channel moderator roles can't set preferences for other users. Banned users or bots can't set membership preferences for the channel from which they are banned.
 *
 * The x-amz-chime-bearer request header is mandatory. Use the ARN of an `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.putChannelMembershipPreferences(crossinline block: PutChannelMembershipPreferencesRequest.Builder.() -> Unit): PutChannelMembershipPreferencesResponse = putChannelMembershipPreferences(PutChannelMembershipPreferencesRequest.Builder().apply(block).build())

/**
 * Sets the data streaming configuration for an `AppInstance`. For more information, see [Streaming messaging data](https://docs.aws.amazon.com/chime-sdk/latest/dg/streaming-export.html) in the *Amazon Chime SDK Developer Guide*.
 */
public suspend inline fun ChimeSdkMessagingClient.putMessagingStreamingConfigurations(crossinline block: PutMessagingStreamingConfigurationsRequest.Builder.() -> Unit): PutMessagingStreamingConfigurationsResponse = putMessagingStreamingConfigurations(PutMessagingStreamingConfigurationsRequest.Builder().apply(block).build())

/**
 * Redacts message content, but not metadata. The message exists in the back end, but the action returns null content, and the state shows as redacted.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.redactChannelMessage(crossinline block: RedactChannelMessageRequest.Builder.() -> Unit): RedactChannelMessageResponse = redactChannelMessage(RedactChannelMessageRequest.Builder().apply(block).build())

/**
 * Allows the `ChimeBearer` to search channels by channel members. Users or bots can search across the channels that they belong to. Users in the `AppInstanceAdmin` role can search across all channels.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.searchChannels(crossinline block: SearchChannelsRequest.Builder.() -> Unit): SearchChannelsResponse = searchChannels(SearchChannelsRequest.Builder().apply(block).build())

/**
 * Sends a message to a particular channel that the member is a part of.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 *
 * Also, `STANDARD` messages can be up to 4KB in size and contain metadata. Metadata is arbitrary, and you can use it in a variety of ways, such as containing a link to an attachment.
 *
 * `CONTROL` messages are limited to 30 bytes and do not contain metadata.
 */
public suspend inline fun ChimeSdkMessagingClient.sendChannelMessage(crossinline block: SendChannelMessageRequest.Builder.() -> Unit): SendChannelMessageResponse = sendChannelMessage(SendChannelMessageRequest.Builder().apply(block).build())

/**
 * Applies the specified tags to the specified Amazon Chime SDK messaging resource.
 */
public suspend inline fun ChimeSdkMessagingClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the specified Amazon Chime SDK messaging resource.
 */
public suspend inline fun ChimeSdkMessagingClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Update a channel's attributes.
 *
 * **Restriction**: You can't change a channel's privacy.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.updateChannel(crossinline block: UpdateChannelRequest.Builder.() -> Unit): UpdateChannelResponse = updateChannel(UpdateChannelRequest.Builder().apply(block).build())

/**
 * Updates channel flow attributes. This is a developer API.
 */
public suspend inline fun ChimeSdkMessagingClient.updateChannelFlow(crossinline block: UpdateChannelFlowRequest.Builder.() -> Unit): UpdateChannelFlowResponse = updateChannelFlow(UpdateChannelFlowRequest.Builder().apply(block).build())

/**
 * Updates the content of a message.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.updateChannelMessage(crossinline block: UpdateChannelMessageRequest.Builder.() -> Unit): UpdateChannelMessageResponse = updateChannelMessage(UpdateChannelMessageRequest.Builder().apply(block).build())

/**
 * The details of the time when a user last read messages in a channel.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the ARN of the `AppInstanceUser` or `AppInstanceBot` that makes the API call as the value in the header.
 */
public suspend inline fun ChimeSdkMessagingClient.updateChannelReadMarker(crossinline block: UpdateChannelReadMarkerRequest.Builder.() -> Unit): UpdateChannelReadMarkerResponse = updateChannelReadMarker(UpdateChannelReadMarkerRequest.Builder().apply(block).build())
