// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmessaging.serde

import aws.sdk.kotlin.services.chimesdkmessaging.model.UpdateChannelMessageRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateChannelMessageOperationSerializer: HttpSerialize<UpdateChannelMessageRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateChannelMessageRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.channelArn) { "channelArn is bound to the URI and must not be null" }
            requireNotNull(input.messageId) { "messageId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("channels"))
                add(PercentEncoding.SmithyLabel.encode("${input.channelArn}"))
                add(PercentEncoding.Path.encode("messages"))
                add(PercentEncoding.SmithyLabel.encode("${input.messageId}"))
            }
        }

        builder.headers {
            if (input.chimeBearer?.isNotEmpty() == true) append("x-amz-chime-bearer", input.chimeBearer)
        }

        val payload = serializeUpdateChannelMessageOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateChannelMessageOperationBody(context: ExecutionContext, input: UpdateChannelMessageRequest): ByteArray {
    val serializer = JsonSerializer()
    val CONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Content"))
    val CONTENTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ContentType"))
    val METADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Metadata"))
    val SUBCHANNELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SubChannelId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTENT_DESCRIPTOR)
        field(CONTENTTYPE_DESCRIPTOR)
        field(METADATA_DESCRIPTOR)
        field(SUBCHANNELID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.content?.let { field(CONTENT_DESCRIPTOR, it) }
        input.contentType?.let { field(CONTENTTYPE_DESCRIPTOR, it) }
        input.metadata?.let { field(METADATA_DESCRIPTOR, it) }
        input.subChannelId?.let { field(SUBCHANNELID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
