// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmessaging.serde

import aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageSummary
import aws.sdk.kotlin.services.chimesdkmessaging.model.ChimeSdkMessagingException
import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelMessagesResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListChannelMessagesOperationDeserializer: HttpDeserialize<ListChannelMessagesResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ListChannelMessagesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListChannelMessagesError(context, call)
        }
        val builder = ListChannelMessagesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListChannelMessagesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwListChannelMessagesError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ChimeSdkMessagingException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "UnauthorizedClientException" -> UnauthorizedClientExceptionDeserializer().deserialize(context, wrappedCall)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottledClientException" -> ThrottledClientExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceFailureException" -> ServiceFailureExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ChimeSdkMessagingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListChannelMessagesOperationBody(builder: ListChannelMessagesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CHANNELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChannelArn"))
    val CHANNELMESSAGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ChannelMessages"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val SUBCHANNELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SubChannelId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHANNELARN_DESCRIPTOR)
        field(CHANNELMESSAGES_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SUBCHANNELID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHANNELARN_DESCRIPTOR.index -> builder.channelArn = deserializeString()
                CHANNELMESSAGES_DESCRIPTOR.index -> builder.channelMessages =
                    deserializer.deserializeList(CHANNELMESSAGES_DESCRIPTOR) {
                        val col0 = mutableListOf<ChannelMessageSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeChannelMessageSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                SUBCHANNELID_DESCRIPTOR.index -> builder.subChannelId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
