// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmessaging.serde

import aws.sdk.kotlin.services.chimesdkmessaging.model.AssociateChannelFlowResponse
import aws.sdk.kotlin.services.chimesdkmessaging.model.ChimeSdkMessagingException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class AssociateChannelFlowOperationDeserializer: HttpDeserialize<AssociateChannelFlowResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): AssociateChannelFlowResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAssociateChannelFlowError(context, call)
        }
        val builder = AssociateChannelFlowResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwAssociateChannelFlowError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ChimeSdkMessagingException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "UnauthorizedClientException" -> UnauthorizedClientExceptionDeserializer().deserialize(context, wrappedCall)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottledClientException" -> ThrottledClientExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceFailureException" -> ServiceFailureExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ChimeSdkMessagingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
