// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmessaging.model



/**
 * The attributes required to configure and create an elastic channel. An elastic channel can support a maximum of 1-million members.
 */
public class ElasticChannelConfiguration private constructor(builder: Builder) {
    /**
     * The maximum number of SubChannels that you want to allow in the elastic channel.
     */
    public val maximumSubChannels: kotlin.Int = requireNotNull(builder.maximumSubChannels) { "A non-null value must be provided for maximumSubChannels" }
    /**
     * The minimum allowed percentage of TargetMembershipsPerSubChannel users. Ceil of the calculated value is used in balancing members among SubChannels of the elastic channel.
     */
    public val minimumMembershipPercentage: kotlin.Int = requireNotNull(builder.minimumMembershipPercentage) { "A non-null value must be provided for minimumMembershipPercentage" }
    /**
     * The maximum number of members allowed in a SubChannel.
     */
    public val targetMembershipsPerSubChannel: kotlin.Int = requireNotNull(builder.targetMembershipsPerSubChannel) { "A non-null value must be provided for targetMembershipsPerSubChannel" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chimesdkmessaging.model.ElasticChannelConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ElasticChannelConfiguration(")
        append("maximumSubChannels=$maximumSubChannels,")
        append("minimumMembershipPercentage=$minimumMembershipPercentage,")
        append("targetMembershipsPerSubChannel=$targetMembershipsPerSubChannel")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maximumSubChannels
        result = 31 * result + (minimumMembershipPercentage)
        result = 31 * result + (targetMembershipsPerSubChannel)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ElasticChannelConfiguration

        if (maximumSubChannels != other.maximumSubChannels) return false
        if (minimumMembershipPercentage != other.minimumMembershipPercentage) return false
        if (targetMembershipsPerSubChannel != other.targetMembershipsPerSubChannel) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chimesdkmessaging.model.ElasticChannelConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of SubChannels that you want to allow in the elastic channel.
         */
        public var maximumSubChannels: kotlin.Int? = null
        /**
         * The minimum allowed percentage of TargetMembershipsPerSubChannel users. Ceil of the calculated value is used in balancing members among SubChannels of the elastic channel.
         */
        public var minimumMembershipPercentage: kotlin.Int? = null
        /**
         * The maximum number of members allowed in a SubChannel.
         */
        public var targetMembershipsPerSubChannel: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chimesdkmessaging.model.ElasticChannelConfiguration) : this() {
            this.maximumSubChannels = x.maximumSubChannels
            this.minimumMembershipPercentage = x.minimumMembershipPercentage
            this.targetMembershipsPerSubChannel = x.targetMembershipsPerSubChannel
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chimesdkmessaging.model.ElasticChannelConfiguration = ElasticChannelConfiguration(this)

        internal fun correctErrors(): Builder {
            if (maximumSubChannels == null) maximumSubChannels = 0
            if (minimumMembershipPercentage == null) minimumMembershipPercentage = 0
            if (targetMembershipsPerSubChannel == null) targetMembershipsPerSubChannel = 0
            return this
        }
    }
}
