// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmessaging.serde

import aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessagePersistenceType
import aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageType
import aws.sdk.kotlin.services.chimesdkmessaging.model.MessageAttributeValue
import aws.sdk.kotlin.services.chimesdkmessaging.model.PushNotificationConfiguration
import aws.sdk.kotlin.services.chimesdkmessaging.model.SendChannelMessageRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.Target
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class SendChannelMessageOperationSerializer: HttpSerialize<SendChannelMessageRequest> {
    override suspend fun serialize(context: ExecutionContext, input: SendChannelMessageRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.channelArn) { "channelArn is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("channels"))
                add(PercentEncoding.SmithyLabel.encode("${input.channelArn}"))
                add(PercentEncoding.Path.encode("messages"))
            }
        }

        builder.headers {
            if (input.chimeBearer?.isNotEmpty() == true) append("x-amz-chime-bearer", input.chimeBearer)
        }

        val payload = serializeSendChannelMessageOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeSendChannelMessageOperationBody(context: ExecutionContext, input: SendChannelMessageRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientRequestToken"))
    val CONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Content"))
    val CONTENTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ContentType"))
    val MESSAGEATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("MessageAttributes"))
    val METADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Metadata"))
    val PERSISTENCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Persistence"))
    val PUSHNOTIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("PushNotification"))
    val SUBCHANNELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SubChannelId"))
    val TARGET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Target"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(CONTENT_DESCRIPTOR)
        field(CONTENTTYPE_DESCRIPTOR)
        field(MESSAGEATTRIBUTES_DESCRIPTOR)
        field(METADATA_DESCRIPTOR)
        field(PERSISTENCE_DESCRIPTOR)
        field(PUSHNOTIFICATION_DESCRIPTOR)
        field(SUBCHANNELID_DESCRIPTOR)
        field(TARGET_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.content?.let { field(CONTENT_DESCRIPTOR, it) }
        input.contentType?.let { field(CONTENTTYPE_DESCRIPTOR, it) }
        if (input.messageAttributes != null) {
            mapField(MESSAGEATTRIBUTES_DESCRIPTOR) {
                input.messageAttributes.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeMessageAttributeValueDocument)) }
            }
        }
        input.metadata?.let { field(METADATA_DESCRIPTOR, it) }
        input.persistence?.let { field(PERSISTENCE_DESCRIPTOR, it.value) }
        input.pushNotification?.let { field(PUSHNOTIFICATION_DESCRIPTOR, it, ::serializePushNotificationConfigurationDocument) }
        input.subChannelId?.let { field(SUBCHANNELID_DESCRIPTOR, it) }
        if (input.target != null) {
            listField(TARGET_DESCRIPTOR) {
                for (el0 in input.target) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTargetDocument))
                }
            }
        }
        input.type?.let { field(TYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
