// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmessaging.serde

import aws.sdk.kotlin.services.chimesdkmessaging.model.RedactChannelMessageRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class RedactChannelMessageOperationSerializer: HttpSerialize<RedactChannelMessageRequest> {
    override suspend fun serialize(context: ExecutionContext, input: RedactChannelMessageRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.channelArn) { "channelArn is bound to the URI and must not be null" }
            requireNotNull(input.messageId) { "messageId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("channels"))
                add(PercentEncoding.SmithyLabel.encode("${input.channelArn}"))
                add(PercentEncoding.Path.encode("messages"))
                add(PercentEncoding.SmithyLabel.encode("${input.messageId}"))
            }
            parameters.decodedParameters {
                add("operation", "redact")
            }
        }

        builder.headers {
            if (input.chimeBearer?.isNotEmpty() == true) append("x-amz-chime-bearer", input.chimeBearer)
        }

        val payload = serializeRedactChannelMessageOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeRedactChannelMessageOperationBody(context: ExecutionContext, input: RedactChannelMessageRequest): ByteArray {
    val serializer = JsonSerializer()
    val SUBCHANNELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SubChannelId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SUBCHANNELID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.subChannelId?.let { field(SUBCHANNELID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
