// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmessaging.serde

import aws.sdk.kotlin.services.chimesdkmessaging.model.ListChannelMessagesRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.SortOrder
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ListChannelMessagesOperationSerializer: HttpSerialize<ListChannelMessagesRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListChannelMessagesRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            requireNotNull(input.channelArn) { "channelArn is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("channels"))
                add(PercentEncoding.SmithyLabel.encode("${input.channelArn}"))
                add(PercentEncoding.Path.encode("messages"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.maxResults != null) add("max-results", "${input.maxResults}")
                if (input.nextToken != null) add("next-token", input.nextToken)
                if (input.notAfter != null) add("not-after", input.notAfter.format(TimestampFormat.ISO_8601))
                if (input.notBefore != null) add("not-before", input.notBefore.format(TimestampFormat.ISO_8601))
                if (input.sortOrder != null) add("sort-order", input.sortOrder.value)
                if (input.subChannelId != null) add("sub-channel-id", input.subChannelId)
            }
        }

        builder.headers {
            if (input.chimeBearer?.isNotEmpty() == true) append("x-amz-chime-bearer", input.chimeBearer)
        }

        return builder
    }
}
