// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkmessaging.serde

import aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelFlowCallbackRequest
import aws.sdk.kotlin.services.chimesdkmessaging.model.ChannelMessageCallback
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class ChannelFlowCallbackOperationSerializer: HttpSerialize<ChannelFlowCallbackRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ChannelFlowCallbackRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.channelArn) { "channelArn is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("channels"))
                add(PercentEncoding.SmithyLabel.encode("${input.channelArn}"))
            }
            parameters.decodedParameters {
                add("operation", "channel-flow-callback")
            }
        }

        val payload = serializeChannelFlowCallbackOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeChannelFlowCallbackOperationBody(context: ExecutionContext, input: ChannelFlowCallbackRequest): ByteArray {
    val serializer = JsonSerializer()
    val CALLBACKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CallbackId"))
    val CHANNELMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ChannelMessage"))
    val DELETERESOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("DeleteResource"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CALLBACKID_DESCRIPTOR)
        field(CHANNELMESSAGE_DESCRIPTOR)
        field(DELETERESOURCE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.callbackId?.let { field(CALLBACKID_DESCRIPTOR, it) } ?: field(CALLBACKID_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.channelMessage?.let { field(CHANNELMESSAGE_DESCRIPTOR, it, ::serializeChannelMessageCallbackDocument) }
        input.deleteResource?.let { field(DELETERESOURCE_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
